/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class IRTypeConverter {
    private static final HashMap UnitMapping = new HashMap();

    static {
        UnitMapping.put("cm", new Short(6));
        UnitMapping.put("cm", new Short(6));
        UnitMapping.put("em", new Short(3));
        UnitMapping.put("ex", new Short(4));
        UnitMapping.put("in", new Short(8));
        UnitMapping.put("mm", new Short(7));
        UnitMapping.put("pc", new Short(10));
        UnitMapping.put("%", new Short(2));
        UnitMapping.put("pt", new Short(9));
        UnitMapping.put("px", new Short(5));
    }

    public static CSSValue toColor(Object value) {
        return IRTypeConverter.toRGBColor(value);
    }

    public static CSSPrimitiveValue toCSSValue(short type, Object value) {
        Value tempValue = null;
        switch (type) {
            case 25: {
                tempValue = IRTypeConverter.toRGBColor(value);
                break;
            }
            case 0: {
                tempValue = IRTypeConverter.toFloatValue(value);
                break;
            }
            case 19: 
            case 20: {
                return IRTypeConverter.toStringValue(type, value);
            }
            default: {
                tempValue = IRTypeConverter.toFloatValue(value);
            }
        }
        if (tempValue != null) {
            return tempValue;
        }
        return IRTypeConverter.toStringValue(value);
    }

    public static RGBColorValue toRGBColor(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return IRTypeConverter.toRGBColor(((Number)value).intValue());
        }
        return IRTypeConverter.toRGBColor(value.toString());
    }

    public static RGBColorValue toRGBColor(String strValue) {
        return IRTypeConverter.toRGBColor(ColorUtil.parseColor((String)strValue));
    }

    public static RGBColorValue toRGBColor(int intValue) {
        if (intValue > 0xFFFFFF || intValue < 0) {
            return null;
        }
        float r = intValue >> 16;
        float g = intValue >> 8 & 0xFF;
        float b = intValue & 0xFF;
        return new RGBColorValue(IRTypeConverter.toFloatValue(r), IRTypeConverter.toFloatValue(g), IRTypeConverter.toFloatValue(b));
    }

    public static StringValue toStringValue(short type, String value) {
        return new StringValue(type, value);
    }

    public static StringValue toStringValue(short type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return IRTypeConverter.toStringValue(type, (Boolean)value != false ? "true" : "false");
        }
        return IRTypeConverter.toStringValue(type, value.toString());
    }

    public static StringValue toStringValue(Object value) {
        return IRTypeConverter.toStringValue((short)19, value);
    }

    public static FloatValue toFloatValue(float value) {
        return new FloatValue(1, value);
    }

    public static FloatValue toFloatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return new FloatValue(1, ((Number)value).floatValue());
        }
        if (value instanceof DimensionType) {
            return IRTypeConverter.toFloatValue((DimensionType)value);
        }
        return IRTypeConverter.toFloatValue(value.toString());
    }

    public static FloatValue toFloatValue(String value) {
        try {
            Float fValue = new Float(value);
            return new FloatValue(1, fValue.floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            return IRTypeConverter.toFloatValue(DimensionType.parserUnit(value));
        }
    }

    public static FloatValue toFloatValue(DimensionType value) {
        if (value.getValueType() == 1) {
            Object obj = UnitMapping.get(value.getUnits());
            short unit = obj != null ? (Short)obj : (short)1;
            return new FloatValue(unit, (float)value.getMeasure());
        }
        return null;
    }
}

