/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IAutoTextEventHandler;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.AutoText;
import org.eclipse.birt.report.engine.script.internal.instance.AutoTextInstance;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class AutoTextScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(AutoTextHandle autoTextHandle, ExecutionContext context) {
        try {
            AutoText cell = new AutoText((ReportItemHandle)autoTextHandle);
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextHandle, context);
            if (eh != null) {
                eh.onPrepare(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IAutoTextContent content, ExecutionContext context) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign autoTextItemDesign = (ReportItemDesign)generateBy;
            if (!AutoTextScriptExecutor.needOnCreate(autoTextItemDesign)) {
                return;
            }
            AutoTextInstance autoText = new AutoTextInstance(content, context);
            if (AutoTextScriptExecutor.handleJS(autoText, autoTextItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextItemDesign, context);
            if (eh != null) {
                eh.onCreate(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IAutoTextContent content, ExecutionContext context) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign autoTextDesign = (ReportItemDesign)generateBy;
            if (!AutoTextScriptExecutor.needOnRender(autoTextDesign)) {
                return;
            }
            AutoTextInstance autoText = new AutoTextInstance(content, context);
            if (AutoTextScriptExecutor.handleJS(autoText, autoTextDesign.getOnRender(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextDesign, context);
            if (eh != null) {
                eh.onRender(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IAutoTextContent content, ExecutionContext context) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign autoTextDesign = (ReportItemDesign)generateBy;
            if (!AutoTextScriptExecutor.needOnPageBreak(autoTextDesign)) {
                return;
            }
            AutoTextInstance autoText = new AutoTextInstance(content, context);
            if (AutoTextScriptExecutor.handleJS(autoText, autoTextDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextDesign, context);
            if (eh != null) {
                eh.onPageBreak(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e);
        }
    }

    private static IAutoTextEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IAutoTextEventHandler)AutoTextScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            String string = design.getJavaClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IAutoTextEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AutoTextScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }

    private static IAutoTextEventHandler getEventHandler(AutoTextHandle handle, ExecutionContext context) {
        try {
            return (IAutoTextEventHandler)AutoTextScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IAutoTextEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AutoTextScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }
}

