/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.birt.report.engine.api.TOCNode;

public class TOCTreeNode
extends TOCNode {
    private boolean isGroupRoot;
    protected Set hiddenFormats = null;
    protected String hiddenFormatsString;
    protected boolean isAllHidden;
    protected Object tocValue;
    private long elementId = -1L;

    public TOCTreeNode() {
    }

    public TOCTreeNode(TOCNode node) {
        super(node);
    }

    public TOCTreeNode(TOCTreeNode node) {
        super(node);
        this.hiddenFormats = node.hiddenFormats;
        this.hiddenFormatsString = node.hiddenFormatsString;
        this.isGroupRoot = node.isGroupRoot;
        this.tocValue = node.tocValue;
        this.elementId = node.elementId;
    }

    public boolean isGroupRoot() {
        return this.isGroupRoot;
    }

    public String getHiddenFormats() {
        return this.hiddenFormatsString;
    }

    public void setHideFormats(String formats) {
        if ("all".equalsIgnoreCase(formats)) {
            this.isAllHidden = true;
            this.hiddenFormatsString = "all";
            return;
        }
        this.hiddenFormats = this.parseHiddenFormats(formats);
        this.hiddenFormatsString = this.generateHiddenFormatsString();
    }

    public void setIsGroupRoot(boolean isGroupRoot) {
        this.isGroupRoot = isGroupRoot;
    }

    public boolean isHidden(String format) {
        if (format == null) {
            return false;
        }
        if (this.isAllHidden) {
            return true;
        }
        if (this.hiddenFormats == null) {
            return false;
        }
        return this.hiddenFormats.contains(format);
    }

    public boolean isBlank() {
        return this.tocValue == null;
    }

    public Object getTOCValue() {
        return this.tocValue;
    }

    public void setTOCValue(Object tocValue) {
        this.tocValue = tocValue;
    }

    public long getElementId() {
        return this.elementId;
    }

    public void setElementId(long elementId) {
        this.elementId = elementId;
    }

    public int hashCode() {
        return this.nodeId == null ? 0 : this.nodeId.hashCode();
    }

    private Set parseHiddenFormats(String formats) {
        if (formats == null || formats.trim().length() == 0) {
            return null;
        }
        String[] allFormats = formats.split(",");
        HashSet<String> hiddenFormats = new HashSet<String>(allFormats.length);
        int i = 0;
        while (i < allFormats.length) {
            String format = allFormats[i].trim();
            hiddenFormats.add(format);
            ++i;
        }
        return hiddenFormats;
    }

    private String generateHiddenFormatsString() {
        if (this.hiddenFormats == null) {
            return null;
        }
        StringBuffer formats = new StringBuffer();
        Iterator iterator = this.hiddenFormats.iterator();
        while (iterator.hasNext()) {
            if (formats.length() != 0) {
                formats.append(',');
            }
            formats.append(iterator.next());
        }
        return formats.toString();
    }
}

