/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.Blob;
import org.eclipse.birt.report.data.oda.jdbc.Clob;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ParameterDefn;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.SPParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.SPParameterPositionUtil;
import org.eclipse.birt.report.data.oda.jdbc.SPResultSet;
import org.eclipse.birt.report.data.oda.jdbc.SPResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IParameterRowSet;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;

public class CallStatement
implements IAdvancedQuery {
    protected CallableStatement callStat;
    protected Connection conn;
    protected int maxrows;
    protected boolean maxRowsUpToDate = false;
    private SPParameterPositionUtil paramUtil;
    private static final String ERRMSG_SET_PARAMETER = "Error setting value for SQL parameter #";
    private static Logger logger;
    private IParameterMetaData parameterDefn;
    private IResultSetMetaData cachedResultMetaData;
    private IResultSet cachedResultSet;
    private IParameterMetaData cachedParameterMetaData;
    protected String[] resultSetNames;
    private static final String ORACLE_FLOAT_NAME = "FLOAT";
    private static final String ORACLE_CURSOR_NAME = "REF CURSOR";
    private static final int ORACLE_CURSOR_TYPE = -10;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.StatementCannotNull", 117);
        }
    }

    public CallStatement(Connection connection) throws OdaException {
        if (connection == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
        this.callStat = null;
        this.conn = connection;
        this.maxrows = 0;
    }

    public void prepare(String command) throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "prepare", "CallableStatement.prepare( \"" + command + "\" )");
        try {
            if (command == null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.FINE, clazz2.getName(), "prepare", "Query text can not be null.");
                throw new OdaException("Query text can not be null.");
            }
            this.paramUtil = new SPParameterPositionUtil(command, '@');
            this.callStat = this.conn.prepareCall(command);
            this.cachedResultMetaData = null;
            this.cachedResultSet = null;
            this.cachedParameterMetaData = null;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.StatementCannotPrepared", e);
        }
    }

    public void setAppContext(Object context) throws OdaException {
        if (context instanceof Map) {
            this.parameterDefn = (IParameterMetaData)((Map)context).get("org.eclipse.birt.report.data.oda.jdbc.ParameterHints");
        }
    }

    public void setProperty(String name, String value) throws OdaException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.equals("queryTimeOut")) {
            if (value != null && value.length() > 0) {
                try {
                    double secs = Double.parseDouble(value);
                    this.callStat.setQueryTimeout((int)secs);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, "CallStatement.setQueryTimeout failed", e);
                }
            }
        } else if (!(name.equals("OdaConnProfileName") || name.equals("OdaConnProfileStore") || name.equals("OdaConnProfileStorePath"))) {
            OdaException e = new OdaException("Unsupported query property: " + name);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "setProperty", "Unsupported property", e);
            throw e;
        }
    }

    public void close() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "close", "CallStatement.close( )");
        try {
            if (this.callStat != null) {
                this.callStat.close();
            }
            this.cachedResultMetaData = null;
            this.cachedResultSet = null;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotClosePreparedStatement", e);
        }
    }

    public void setMaxRows(int max) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setMaxRows", "CallStatement.setMaxRows( " + max + " )");
        if (max != this.maxrows && max >= 0) {
            this.maxrows = max;
            this.maxRowsUpToDate = false;
        }
    }

    public int getMaxRows() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getMaxRows", "CallStatement.getMaxRows( )");
        return this.maxrows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getMetaData", "CallableStatement.getMetaData( )");
        if (this.cachedResultMetaData != null) {
            return this.cachedResultMetaData;
        }
        java.sql.ResultSetMetaData resultmd = null;
        try {
            this.assertNotNull(this.callStat);
            resultmd = this.callStat.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            resultmd = null;
        }
        catch (SQLException sQLException) {}
        if (resultmd != null) {
            this.cachedResultMetaData = new ResultSetMetaData(resultmd);
        } else {
            try {
                this.cachedResultSet = this.executeQuery();
                this.cachedResultMetaData = this.cachedResultSet != null ? this.cachedResultSet.getMetaData() : new SPResultSetMetaData(null);
            }
            catch (OdaException odaException) {
                this.cachedResultSet = null;
            }
        }
        return this.cachedResultMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "executeQuery", "CallableStatement.executeQuery( )");
        if (this.cachedResultSet != null) {
            IResultSet ret = this.cachedResultSet;
            this.cachedResultSet = null;
            return ret;
        }
        if (!this.maxRowsUpToDate) {
            try {
                this.assertNotNull(this.callStat);
                this.callStat.setMaxRows(this.maxrows);
            }
            catch (SQLException sQLException) {}
            this.maxRowsUpToDate = true;
        }
        this.registerOutputParameter();
        java.sql.ResultSet rs = null;
        try {
            this.callStat.execute();
            rs = this.callStat.getResultSet();
            while (rs == null && this.callStat.getMoreResults()) {
                rs = this.callStat.getResultSet();
            }
            if (rs != null) {
                return new ResultSet(rs);
            }
            java.sql.ResultSet resultSet = this.getOutputParamResultSet();
            if (resultSet != null) {
                return new ResultSet(resultSet);
            }
            return new SPResultSet(null);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotReturn", e);
        }
    }

    private java.sql.ResultSet getOutputParamResultSet() throws OdaException, SQLException {
        if (this.parameterDefn != null) {
            int i = 0;
            while (i < this.parameterDefn.getParameterCount()) {
                Object expected;
                if (this.parameterDefn.getParameterMode(i) == 3 && (expected = this.callStat.getObject(i + 1)) instanceof java.sql.ResultSet) {
                    return (java.sql.ResultSet)expected;
                }
                ++i;
            }
        }
        return null;
    }

    private void registerOutputParameter() throws OdaException {
        if (this.parameterDefn != null) {
            int i = 0;
            while (i < this.parameterDefn.getParameterCount()) {
                if (this.parameterDefn.getParameterMode(i) == 3 || this.parameterDefn.getParameterMode(i) == 2) {
                    this.registerOutParameter(i + 1, this.getParameterType(i));
                }
                ++i;
            }
        }
    }

    private int getParameterType(int i) throws OdaException {
        if (this.parameterDefn.getParameterType(i) != 1) {
            return this.parameterDefn.getParameterType(i);
        }
        IParameterMetaData paramMetaData = this.getParameterMetaData();
        if (paramMetaData != null && paramMetaData.getParameterCount() > i) {
            return paramMetaData.getParameterType(i + 1);
        }
        return this.parameterDefn.getParameterType(i);
    }

    void registerOutParameter(int position, int type) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.registerOutParameter(position, type);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    void registerOutParameter(String name, int type) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.registerOutParameter(name, type);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    public boolean execute() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "execute", "CallableStatement.execute( )");
        this.assertNotNull(this.callStat);
        try {
            if (!this.maxRowsUpToDate) {
                this.callStat.setMaxRows(this.maxrows);
                this.maxRowsUpToDate = true;
            }
            return this.callStat.execute();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setInt(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setInt(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDouble(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDouble(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBigDecimal(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBigDecimal(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setString(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setString(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDate(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDate(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTime(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTime(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTimestamp(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTimestamp(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBoolean(parameterName, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBoolean(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setNull(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "findInParameter", "No named Parameter supported.", e);
        throw e;
    }

    public void setNull(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            if (this.getParameterMetaData() != null) {
                this.callStat.setNull(parameterId, this.getParameterMetaData().getParameterType(parameterId));
            } else {
                this.callStat.setNull(parameterId, 1111);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetNullValue", e);
        }
    }

    public IParameterRowSet setNewRow(String parameterName) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRow(int parameterId) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRowSet(String parameterName) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRowSet(int parameterId) throws OdaException {
        return null;
    }

    public int getInt(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getInt(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
        }
    }

    public int getInt(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getInt(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
        }
    }

    public double getDouble(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDouble(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public double getDouble(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDouble(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public BigDecimal getBigDecimal(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBigDecimal(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public BigDecimal getBigDecimal(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBigDecimal(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public String getString(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getString(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public String getString(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getString(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public Date getDate(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDate(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Date getDate(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDate(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Time getTime(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTime(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Time getTime(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTime(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Timestamp getTimestamp(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTimestamp(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public Timestamp getTimestamp(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTimestamp(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public IBlob getBlob(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Blob blob = this.callStat.getBlob(parameterName);
            return new Blob(blob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IBlob getBlob(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Blob blob = this.callStat.getBlob(parameterId);
            return new Blob(blob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IClob getClob(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Clob clob = this.callStat.getClob(parameterName);
            return new Clob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IClob getClob(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Clob clob = this.callStat.getClob(parameterId);
            return new Clob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public boolean getBoolean(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBoolean(parameterName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public boolean getBoolean(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBoolean(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public IParameterRowSet getRow(String parameterName) throws OdaException {
        return null;
    }

    public IResultSet getResultSet() throws OdaException {
        try {
            return new ResultSet(this.callStat.getResultSet());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSet", e);
        }
    }

    public IResultSet getResultSet(String resultSetName) throws OdaException {
        try {
            return new ResultSet(this.callStat.getResultSet());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSet", e);
        }
    }

    public boolean getMoreResults() throws OdaException {
        try {
            return this.callStat.getMoreResults();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSet", e);
        }
    }

    public IParameterRowSet getRow(int parameterId) throws OdaException {
        return null;
    }

    public IResultSetMetaData getMetaDataOf(String resultSetName) throws OdaException {
        return null;
    }

    public int findInParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "findInParameter", "No named Parameter supported.", e);
        throw e;
    }

    public int findOutParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "findOutParameter", "No named Parameter supported.", e);
        throw e;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.assertNotNull(this.callStat);
        if (this.cachedParameterMetaData != null) {
            return this.cachedParameterMetaData;
        }
        int[] positionArray = this.paramUtil.getParameterPositions();
        List paramMetaList1 = this.getCallableParamMetaData();
        ArrayList paramMetaList2 = new ArrayList();
        int i = 0;
        while (i < positionArray.length) {
            int index = positionArray[i];
            if (paramMetaList1.size() >= index) {
                paramMetaList2.add(paramMetaList1.get(index - 1));
            }
            ++i;
        }
        this.cachedParameterMetaData = new SPParameterMetaData(paramMetaList2);
        return this.cachedParameterMetaData;
    }

    private List getCallableParamMetaData() {
        ArrayList<ParameterDefn> paramMetaDataList = new ArrayList<ParameterDefn>();
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            String cataLog = this.conn.getCatalog();
            ArrayList<String> schemaList = null;
            String columnNamePattern = null;
            String procedureNamePattern = this.paramUtil.getProcedureName();
            String packagePattern = "";
            String schemaPattern = this.paramUtil.getSchemaName();
            if (!metaData.supportsCatalogsInProcedureCalls()) {
                packagePattern = this.paramUtil.getPackageName();
            }
            if (schemaPattern != null) {
                schemaList = new ArrayList<String>();
                schemaList.add(schemaPattern);
            } else {
                java.sql.ResultSet rs = metaData.getSchemas();
                schemaList = this.createSchemaList(rs);
                rs.close();
            }
            if (schemaList == null || schemaList.size() == 0) {
                if (schemaList == null) {
                    schemaList = new ArrayList<String>();
                }
                schemaList.add("");
                columnNamePattern = "";
            }
            int i = 0;
            while (i < schemaList.size()) {
                java.sql.ResultSet rs = null;
                rs = packagePattern.trim().length() > 0 ? metaData.getProcedureColumns(packagePattern, schemaList.get(i).toString(), procedureNamePattern, columnNamePattern) : metaData.getProcedureColumns(cataLog, schemaList.get(i).toString(), procedureNamePattern, columnNamePattern);
                while (rs.next()) {
                    ParameterDefn p = new ParameterDefn();
                    p.setParamName(rs.getString("COLUMN_NAME"));
                    p.setParamInOutType(rs.getInt("COLUMN_TYPE"));
                    p.setParamType(rs.getInt("DATA_TYPE"));
                    p.setParamTypeName(rs.getString("TYPE_NAME"));
                    p.setPrecision(rs.getInt("PRECISION"));
                    p.setScale(rs.getInt("SCALE"));
                    p.setIsNullable(rs.getInt("NULLABLE"));
                    if (p.getParamType() == 1111) {
                        this.correctParamType(p);
                    }
                    if (p.getParamInOutType() == 5) continue;
                    paramMetaDataList.add(p);
                }
                rs.close();
                ++i;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (JDBCException jDBCException) {}
        return paramMetaDataList;
    }

    private void correctParamType(ParameterDefn parameterDefn) {
        String parameterName = parameterDefn.getParamTypeName().toUpperCase();
        if (parameterName.equals(ORACLE_FLOAT_NAME)) {
            parameterDefn.setParamType(6);
        } else if (parameterName.equals(ORACLE_CURSOR_NAME)) {
            parameterDefn.setParamType(-10);
        } else {
            parameterDefn.setParamType(12);
        }
    }

    private ArrayList createSchemaList(java.sql.ResultSet schemaRs) {
        if (schemaRs == null) {
            return null;
        }
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<String> allSchemas = new ArrayList<String>();
        try {
            while (schemaRs.next()) {
                allSchemas.add(schemaRs.getString("TABLE_SCHEM"));
            }
            Iterator it = allSchemas.iterator();
            while (it.hasNext()) {
                String schema = it.next().toString();
                schemas.add(schema);
            }
        }
        catch (SQLException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        return schemas;
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        this.setSortSpec(null, sortBy);
    }

    public void setSortSpec(String resultSetName, SortSpec sortBy) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setSortSpec", "setSortSpec is not supported.", e);
        throw e;
    }

    public SortSpec getSortSpec() throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public SortSpec getSortSpec(String resultSetName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public void clearInParameters() throws OdaException {
        try {
            this.assertNotNull(this.callStat);
            this.callStat.clearParameters();
        }
        catch (SQLException ex) {
            throw new JDBCException("odajdbc.ClearParametersError", ex);
        }
    }

    private static void rethrowRunTimeException(RuntimeException e, String msg) throws OdaException {
        OdaException odaException = new OdaException(msg);
        odaException.initCause((Throwable)e);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.CallStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "rethrowRunTimeException", msg, odaException);
        throw odaException;
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public String[] getResultSetNames() throws OdaException {
        return this.resultSetNames;
    }
}

