/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class SPParameterPositionUtil {
    private int[] position;
    private char escaper;
    private String[] namePattern;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.SPParameterPositionUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SPParameterPositionUtil(String sqlTxt, char escaper) throws OdaException {
        try {
            if (!$assertionsDisabled && sqlTxt == null) {
                throw new AssertionError();
            }
            this.escaper = escaper;
            int[] point = this.getPosition(sqlTxt);
            String paramTxt = this.getParameterDefinitionChars(sqlTxt, point);
            this.parseQueryText(paramTxt);
            this.parseProcedureName(sqlTxt, point);
        }
        catch (Throwable throwable) {}
    }

    private void parseQueryText(String queryText) throws IOException {
        int i;
        StringReader reader = new StringReader(queryText);
        int nextPosition = 1;
        boolean escaped = false;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while ((i = reader.read()) != -1) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (i == this.escaper) {
                escaped = true;
                continue;
            }
            if (i == 34 || i == 39) {
                SPParameterPositionUtil.readNextQuote(reader, i);
                continue;
            }
            if (i == 40) {
                if (!SPParameterPositionUtil.readNextBracket(reader)) continue;
                result.add(new Integer(nextPosition));
                continue;
            }
            if (i == 44) {
                ++nextPosition;
                continue;
            }
            if (i != 63) continue;
            result.add(new Integer(nextPosition));
        }
        this.position = new int[result.size()];
        int k = 0;
        while (k < result.size()) {
            this.position[k] = new Integer(result.get(k).toString());
            ++k;
        }
    }

    private static void readNextQuote(StringReader reader, int quote) throws IOException {
        int i = -1;
        while ((i = reader.read()) != -1) {
            if (i == quote) break;
        }
    }

    private static boolean readNextBracket(StringReader reader) throws IOException {
        int i = -1;
        boolean hasPlaceHolder = false;
        while ((i = reader.read()) != -1) {
            if (i == 63) {
                hasPlaceHolder = true;
                continue;
            }
            if (i == 41) break;
        }
        return hasPlaceHolder;
    }

    public int[] getParameterPositions() {
        return this.position == null ? new int[]{} : this.position;
    }

    public String getProcedureName() throws JDBCException {
        if (this.namePattern != null && this.namePattern.length > 0) {
            return this.namePattern[this.namePattern.length - 1];
        }
        throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
    }

    public String getSchemaName() {
        if (this.namePattern != null && this.namePattern.length >= 2) {
            return this.namePattern[0];
        }
        return null;
    }

    public String getPackageName() {
        if (this.namePattern != null && this.namePattern.length > 2) {
            return this.namePattern[1];
        }
        return "";
    }

    private void parseProcedureName(String sqlTxt, int[] point) throws JDBCException {
        int start = sqlTxt.toLowerCase().indexOf("call");
        int end = point[0];
        if (point[0] == -1 && point[1] == -1) {
            end = sqlTxt.indexOf("}");
        }
        if (start == -1 || start + 4 >= end) {
            throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
        }
        String name = sqlTxt.substring(start + 4, end).trim();
        String[] pattern = name.split("\\Q.\\E");
        int i = 0;
        while (i < pattern.length) {
            pattern[i] = this.escapeIdentifier(pattern[i]);
            ++i;
        }
        this.namePattern = pattern;
    }

    private String escapeIdentifier(String text) {
        if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("[") && text.endsWith("]")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private String getParameterDefinitionChars(String sqlTxt, int[] point) throws OdaException {
        int startPoint = point[0];
        int endPoint = point[1];
        if (startPoint == -1 && endPoint == -1) {
            return "";
        }
        if (startPoint >= endPoint || startPoint == -1) {
            throw new JDBCException("odajdbc.InvalidStoredPrecedure", 118);
        }
        return sqlTxt.substring(startPoint + 1, endPoint);
    }

    private int[] getPosition(String queryText) {
        char[] temp = queryText.toCharArray();
        int[] point = new int[]{-1, -1};
        boolean validBracket = true;
        int i = 0;
        while (i < temp.length) {
            if (i <= 0 || temp[i - 1] != this.escaper) {
                if (validBracket && '(' == temp[i]) {
                    point[0] = i;
                    break;
                }
                if ('\"' == temp[i]) {
                    validBracket = !validBracket;
                }
            }
            ++i;
        }
        i = temp.length - 1;
        while (i >= 0) {
            if (i <= 0 || temp[i - 1] != this.escaper) {
                if (validBracket && ')' == temp[i]) {
                    point[1] = i;
                    break;
                }
                if ('\"' == temp[i]) {
                    validBracket = !validBracket;
                }
            }
            --i;
        }
        return point;
    }
}

