/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

public final class ByteBuffer {
    private byte[] data;
    private int pos;
    private int limit;

    private ByteBuffer() {
    }

    public byte[] array() {
        byte[] result = new byte[this.limit];
        int i = 0;
        while (i < this.limit) {
            result[i] = this.data[i];
            ++i;
        }
        return result;
    }

    public static ByteBuffer wrap(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        ByteBuffer result = new ByteBuffer();
        result.data = data;
        result.pos = 0;
        result.limit = data.length;
        return result;
    }

    public int limit() {
        return this.limit;
    }

    public int remaining() {
        return this.limit - this.pos;
    }

    public byte get() {
        if (this.pos < this.limit) {
            return this.data[this.pos++];
        }
        throw new IndexOutOfBoundsException();
    }

    public void get(byte[] dst, int offset, int length) {
        if (offset < 0 || offset + length > dst.length || this.pos + length > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            dst[offset++] = this.data[this.pos++];
            ++i;
        }
    }

    public static final ByteBuffer allocate(int size) {
        ByteBuffer ret = new ByteBuffer();
        ret.data = new byte[size];
        return ret;
    }
}

