/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.DateNumberFormat;
import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private DateFormatSymbols formatData;
    private transient ULocale locale;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private transient long defaultCenturyBase;
    private transient TimeZone parsedTimeZone;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static final String SUPPRESS_NEGATIVE_PREFIX = "\uab00";
    private transient boolean useFastFormat;
    private static ULocale cachedDefaultLocale = null;
    private static String cachedDefaultPattern = null;
    private static final String FALLBACKPATTERN = "yy/MM/dd HH:mm";
    private static final int PATTERN_CHAR_BASE = 64;
    private static final int[] PATTERN_CHAR_TO_INDEX;
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD;
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD;
    private static ICUCache PARSED_PATTERN_CACHE;
    private transient Object[] patternItems;
    private transient boolean useLocalZeroPaddingNumberFormat;
    private transient char zeroDigit;
    private transient char[] decimalBuf;
    private static final String NUMERIC_FORMAT_CHARS = "MyudhHmsSDFwWkK";

    static {
        int[] nArray = new int[64];
        nArray[0] = -1;
        nArray[1] = 22;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = 10;
        nArray[5] = 9;
        nArray[6] = 11;
        nArray[8] = 5;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = 16;
        nArray[12] = 26;
        nArray[13] = 2;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = 27;
        nArray[18] = -1;
        nArray[19] = 8;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = 13;
        nArray[24] = -1;
        nArray[25] = 18;
        nArray[26] = 23;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = -1;
        nArray[33] = 14;
        nArray[34] = -1;
        nArray[35] = 25;
        nArray[36] = 3;
        nArray[37] = 19;
        nArray[38] = -1;
        nArray[39] = 21;
        nArray[40] = 15;
        nArray[41] = -1;
        nArray[42] = -1;
        nArray[43] = 4;
        nArray[44] = -1;
        nArray[45] = 6;
        nArray[46] = -1;
        nArray[47] = -1;
        nArray[48] = -1;
        nArray[49] = 28;
        nArray[50] = -1;
        nArray[51] = 7;
        nArray[52] = -1;
        nArray[53] = 20;
        nArray[54] = 24;
        nArray[55] = 12;
        nArray[56] = -1;
        nArray[57] = 1;
        nArray[58] = 17;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        PATTERN_CHAR_TO_INDEX = nArray;
        int[] nArray2 = new int[29];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 5;
        nArray2[4] = 11;
        nArray2[5] = 11;
        nArray2[6] = 12;
        nArray2[7] = 13;
        nArray2[8] = 14;
        nArray2[9] = 7;
        nArray2[10] = 6;
        nArray2[11] = 8;
        nArray2[12] = 3;
        nArray2[13] = 4;
        nArray2[14] = 9;
        nArray2[15] = 10;
        nArray2[16] = 10;
        nArray2[17] = 15;
        nArray2[18] = 17;
        nArray2[19] = 18;
        nArray2[20] = 19;
        nArray2[21] = 20;
        nArray2[22] = 21;
        nArray2[23] = 15;
        nArray2[24] = 15;
        nArray2[25] = 7;
        nArray2[26] = 2;
        nArray2[27] = 2;
        nArray2[28] = 2;
        PATTERN_INDEX_TO_CALENDAR_FIELD = nArray2;
        int[] nArray3 = new int[29];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 5;
        nArray3[6] = 6;
        nArray3[7] = 7;
        nArray3[8] = 8;
        nArray3[9] = 9;
        nArray3[10] = 10;
        nArray3[11] = 11;
        nArray3[12] = 12;
        nArray3[13] = 13;
        nArray3[14] = 14;
        nArray3[15] = 15;
        nArray3[16] = 16;
        nArray3[17] = 17;
        nArray3[18] = 18;
        nArray3[19] = 19;
        nArray3[20] = 20;
        nArray3[21] = 21;
        nArray3[22] = 22;
        nArray3[23] = 23;
        nArray3[24] = 24;
        nArray3[25] = 25;
        nArray3[26] = 26;
        nArray3[27] = 27;
        nArray3[28] = 28;
        PATTERN_INDEX_TO_DATE_FORMAT_FIELD = nArray3;
        PARSED_PATTERN_CACHE = new SimpleCache();
    }

    public SimpleDateFormat() {
        this(SimpleDateFormat.getDefaultPattern(), null, null, null, null, true);
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, null, null, null, null, true);
    }

    public SimpleDateFormat(String pattern, Locale loc) {
        this(pattern, null, null, null, ULocale.forLocale(loc), true);
    }

    public SimpleDateFormat(String pattern, ULocale loc) {
        this(pattern, null, null, null, loc, true);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData) {
        this(pattern, (DateFormatSymbols)formatData.clone(), null, null, null, true);
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData, ULocale loc) {
        this(pattern, (DateFormatSymbols)formatData.clone(), null, null, loc, true);
    }

    SimpleDateFormat(String pattern, DateFormatSymbols formatData, Calendar calendar, ULocale locale, boolean useFastFormat) {
        this(pattern, (DateFormatSymbols)formatData.clone(), (Calendar)calendar.clone(), null, locale, useFastFormat);
    }

    private SimpleDateFormat(String pattern, DateFormatSymbols formatData, Calendar calendar, NumberFormat numberFormat, ULocale locale, boolean useFastFormat) {
        this.pattern = pattern;
        this.formatData = formatData;
        this.calendar = calendar;
        this.numberFormat = numberFormat;
        this.locale = locale;
        this.useFastFormat = useFastFormat;
        this.initialize();
    }

    public static SimpleDateFormat getInstance(Calendar.FormatConfiguration formatConfig) {
        return new SimpleDateFormat(formatConfig.getPatternString(), formatConfig.getDateFormatSymbols(), formatConfig.getCalendar(), null, formatConfig.getLocale(), true);
    }

    private void initialize() {
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        if (this.formatData == null) {
            this.formatData = new DateFormatSymbols(this.locale);
        }
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.locale);
        }
        if (this.numberFormat == null) {
            this.numberFormat = new DateNumberFormat(this.locale);
        }
        this.defaultCenturyBase = System.currentTimeMillis();
        this.initLocalZeroPaddingNumberFormat();
    }

    private static synchronized String getDefaultPattern() {
        ULocale defaultLocale = ULocale.getDefault();
        if (!defaultLocale.equals(cachedDefaultLocale)) {
            cachedDefaultLocale = defaultLocale;
            Calendar cal = Calendar.getInstance(cachedDefaultLocale);
            try {
                CalendarData calData = new CalendarData(cachedDefaultLocale, cal.getType());
                String[] dateTimePatterns = calData.getStringArray("DateTimePatterns");
                cachedDefaultPattern = MessageFormat.format(dateTimePatterns[8], dateTimePatterns[3], dateTimePatterns[7]);
            }
            catch (MissingResourceException missingResourceException) {
                cachedDefaultPattern = FALLBACKPATTERN;
            }
        }
        return cachedDefaultPattern;
    }

    private void parseAmbiguousDatesAsAfter(Date startDate) {
        this.defaultCenturyStart = startDate;
        this.calendar.setTime(startDate);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    private void initializeDefaultCenturyStart(long baseTime) {
        this.defaultCenturyBase = baseTime;
        Calendar tmpCal = (Calendar)this.calendar.clone();
        tmpCal.setTimeInMillis(baseTime);
        tmpCal.add(1, -80);
        this.defaultCenturyStart = tmpCal.getTime();
        this.defaultCenturyStartYear = tmpCal.get(1);
    }

    private Date getDefaultCenturyStart() {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        return this.defaultCenturyStart;
    }

    private int getDefaultCenturyStartYear() {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        return this.defaultCenturyStartYear;
    }

    public void set2DigitYearStart(Date startDate) {
        this.parseAmbiguousDatesAsAfter(startDate);
    }

    public Date get2DigitYearStart() {
        return this.getDefaultCenturyStart();
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        Object[] items = this.getPatternItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof String) {
                toAppendTo.append((String)items[i]);
            } else {
                PatternItem item = (PatternItem)items[i];
                if (this.useFastFormat) {
                    this.subFormat(toAppendTo, item.type, item.length, toAppendTo.length(), pos, cal);
                } else {
                    toAppendTo.append(this.subFormat(item.type, item.length, toAppendTo.length(), pos, this.formatData, cal));
                }
            }
            ++i;
        }
        return toAppendTo;
    }

    protected String subFormat(char ch, int count, int beginOffset, FieldPosition pos, DateFormatSymbols formatData, Calendar cal) throws IllegalArgumentException {
        StringBuffer buf = new StringBuffer();
        this.subFormat(buf, ch, count, beginOffset, pos, cal);
        return buf.toString();
    }

    protected void subFormat(StringBuffer buf, char ch, int count, int beginOffset, FieldPosition pos, Calendar cal) {
        int bufstart = buf.length();
        int patternCharIndex = -1;
        if ('A' <= ch && ch <= 'z') {
            patternCharIndex = PATTERN_CHAR_TO_INDEX[ch - 64];
        }
        if (patternCharIndex == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + ch + "' in \"" + new String(this.pattern) + '\"');
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        int value = cal.get(field);
        switch (patternCharIndex) {
            case 0: {
                if (count == 5) {
                    buf.append(this.formatData.narrowEras[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.eraNames[value]);
                    break;
                }
                buf.append(this.formatData.eras[value]);
                break;
            }
            case 1: {
                if (count == 2) {
                    this.zeroPaddingNumber(buf, value, 2, 2);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 2: {
                if (count == 5) {
                    buf.append(this.formatData.narrowMonths[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.months[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.shortMonths[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value + 1, count, Integer.MAX_VALUE);
                break;
            }
            case 4: {
                if (value == 0) {
                    this.zeroPaddingNumber(buf, cal.getMaximum(11) + 1, count, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 8: {
                this.numberFormat.setMinimumIntegerDigits(Math.min(3, count));
                this.numberFormat.setMaximumIntegerDigits(Integer.MAX_VALUE);
                if (count == 1) {
                    value = (value + 50) / 100;
                } else if (count == 2) {
                    value = (value + 5) / 10;
                }
                FieldPosition p = new FieldPosition(-1);
                this.numberFormat.format(value, buf, p);
                if (count <= 3) break;
                this.numberFormat.setMinimumIntegerDigits(count - 3);
                this.numberFormat.format(0L, buf, p);
                break;
            }
            case 9: {
                if (count == 5) {
                    buf.append(this.formatData.narrowWeekdays[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.weekdays[value]);
                    break;
                }
                buf.append(this.formatData.shortWeekdays[value]);
                break;
            }
            case 14: {
                buf.append(this.formatData.ampms[value]);
                break;
            }
            case 15: {
                if (value == 0) {
                    this.zeroPaddingNumber(buf, cal.getLeastMaximum(10) + 1, count, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
                break;
            }
            case 17: 
            case 24: {
                boolean isGeneric;
                String res = null;
                String zid = ZoneMeta.getCanonicalID(cal.getTimeZone().getID());
                boolean bl = isGeneric = patternCharIndex == 24;
                if (zid != null) {
                    res = patternCharIndex == 24 ? (count < 4 ? this.formatData.getZoneString(zid, 0) : this.formatData.getZoneString(zid, 3)) : (cal.get(16) != 0 ? (count < 4 ? this.formatData.getZoneString(zid, 2) : this.formatData.getZoneString(zid, 5)) : (count < 4 ? this.formatData.getZoneString(zid, 1) : this.formatData.getZoneString(zid, 4)));
                }
                if (res == null || res.length() == 0) {
                    if (zid == null || !isGeneric || ZoneMeta.getCanonicalCountry(zid) == null) {
                        long offset = cal.get(15) + cal.get(16);
                        res = ZoneMeta.displayGMT(offset, this.locale);
                    } else {
                        res = this.formatData.getZoneString(zid, 6);
                        if (res == null) {
                            res = ZoneMeta.displayFallback(zid, null, this.locale);
                        }
                    }
                }
                if (res.length() == 0) {
                    this.appendGMT(buf, cal);
                    break;
                }
                buf.append(res);
                break;
            }
            case 23: {
                if (count < 4) {
                    long val = (cal.get(15) + cal.get(16)) / 60000;
                    char sign = '+';
                    if (val < 0L) {
                        val = -val;
                        sign = '-';
                    }
                    val = val / 60L * 100L + val % 60L;
                    buf.append(sign);
                    int num = (int)(val % 10000L);
                    int denom = 1000;
                    while (denom >= 1) {
                        char digit = (char)(num / denom + 48);
                        buf.append(digit);
                        num %= denom;
                        denom /= 10;
                    }
                    break;
                }
                long val = cal.get(15) + cal.get(16);
                buf.append(ZoneMeta.displayGMT(val, this.locale));
                break;
            }
            case 25: {
                if (count == 5) {
                    buf.append(this.formatData.standaloneNarrowWeekdays[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.standaloneWeekdays[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.standaloneShortWeekdays[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value, 1, Integer.MAX_VALUE);
                break;
            }
            case 26: {
                if (count == 5) {
                    buf.append(this.formatData.standaloneNarrowMonths[value]);
                    break;
                }
                if (count == 4) {
                    buf.append(this.formatData.standaloneMonths[value]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.standaloneShortMonths[value]);
                    break;
                }
                this.zeroPaddingNumber(buf, value + 1, count, Integer.MAX_VALUE);
                break;
            }
            case 27: {
                if (count >= 4) {
                    buf.append(this.formatData.quarters[value / 3]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.shortQuarters[value / 3]);
                    break;
                }
                this.zeroPaddingNumber(buf, value / 3 + 1, count, Integer.MAX_VALUE);
                break;
            }
            case 28: {
                if (count >= 4) {
                    buf.append(this.formatData.standaloneQuarters[value / 3]);
                    break;
                }
                if (count == 3) {
                    buf.append(this.formatData.standaloneShortQuarters[value / 3]);
                    break;
                }
                this.zeroPaddingNumber(buf, value / 3 + 1, count, Integer.MAX_VALUE);
                break;
            }
            default: {
                this.zeroPaddingNumber(buf, value, count, Integer.MAX_VALUE);
            }
        }
        if (pos.getBeginIndex() == pos.getEndIndex() && pos.getField() == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[patternCharIndex]) {
            pos.setBeginIndex(beginOffset);
            pos.setEndIndex(beginOffset + buf.length() - bufstart);
        }
    }

    private Object[] getPatternItems() {
        if (this.patternItems != null) {
            return this.patternItems;
        }
        this.patternItems = (Object[])PARSED_PATTERN_CACHE.get(this.pattern);
        if (this.patternItems != null) {
            return this.patternItems;
        }
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuffer text = new StringBuffer();
        char itemType = '\u0000';
        int itemLength = 1;
        ArrayList<Object> items = new ArrayList<Object>();
        int i = 0;
        while (i < this.pattern.length()) {
            char ch = this.pattern.charAt(i);
            if (ch == '\'') {
                if (isPrevQuote) {
                    text.append('\'');
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                    if (itemType != '\u0000') {
                        items.add(new PatternItem(itemType, itemLength));
                        itemType = '\u0000';
                    }
                }
                inQuote = !inQuote;
            } else {
                isPrevQuote = false;
                if (inQuote) {
                    text.append(ch);
                } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                    if (ch == itemType) {
                        ++itemLength;
                    } else {
                        if (itemType == '\u0000') {
                            if (text.length() > 0) {
                                items.add(text.toString());
                                text.setLength(0);
                            }
                        } else {
                            items.add(new PatternItem(itemType, itemLength));
                        }
                        itemType = ch;
                        itemLength = 1;
                    }
                } else {
                    if (itemType != '\u0000') {
                        items.add(new PatternItem(itemType, itemLength));
                        itemType = '\u0000';
                    }
                    text.append(ch);
                }
            }
            ++i;
        }
        if (itemType == '\u0000') {
            if (text.length() > 0) {
                items.add(text.toString());
                text.setLength(0);
            }
        } else {
            items.add(new PatternItem(itemType, itemLength));
        }
        this.patternItems = new Object[items.size()];
        items.toArray(this.patternItems);
        PARSED_PATTERN_CACHE.put(this.pattern, this.patternItems);
        return this.patternItems;
    }

    private void appendGMT(StringBuffer buf, Calendar cal) {
        int value = cal.get(15) + cal.get(16);
        if (value < 0) {
            buf.append(GMT_MINUS);
            value = -value;
        } else {
            buf.append(GMT_PLUS);
        }
        this.zeroPaddingNumber(buf, value / 3600000, 2, 2);
        buf.append(':');
        this.zeroPaddingNumber(buf, value % 3600000 / 60000, 2, 2);
    }

    protected void zeroPaddingNumber(StringBuffer buf, int value, int minDigits, int maxDigits) {
        if (this.useLocalZeroPaddingNumberFormat) {
            this.fastZeroPaddingNumber(buf, value, minDigits, maxDigits);
        } else {
            this.numberFormat.setMinimumIntegerDigits(minDigits);
            this.numberFormat.setMaximumIntegerDigits(maxDigits);
            this.numberFormat.format(value, buf, new FieldPosition(-1));
        }
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        super.setNumberFormat(newNumberFormat);
        this.initLocalZeroPaddingNumberFormat();
    }

    private void initLocalZeroPaddingNumberFormat() {
        if (this.numberFormat instanceof DecimalFormat) {
            this.zeroDigit = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols().getZeroDigit();
            this.useLocalZeroPaddingNumberFormat = true;
        } else if (this.numberFormat instanceof DateNumberFormat) {
            this.zeroDigit = ((DateNumberFormat)this.numberFormat).getZeroDigit();
            this.useLocalZeroPaddingNumberFormat = true;
        } else {
            this.useLocalZeroPaddingNumberFormat = false;
        }
        if (this.useLocalZeroPaddingNumberFormat) {
            this.decimalBuf = new char[10];
        }
    }

    private void fastZeroPaddingNumber(StringBuffer buf, int value, int minDigits, int maxDigits) {
        int limit = this.decimalBuf.length < maxDigits ? this.decimalBuf.length : maxDigits;
        int index = limit - 1;
        while (true) {
            this.decimalBuf[index] = (char)(value % 10 + this.zeroDigit);
            if (index == 0 || (value /= 10) == 0) break;
            --index;
        }
        int padding = minDigits - (limit - index);
        while (padding > 0) {
            this.decimalBuf[--index] = this.zeroDigit;
            --padding;
        }
        int length = limit - index;
        buf.append(this.decimalBuf, index, length);
    }

    protected String zeroPaddingNumber(long value, int minDigits, int maxDigits) {
        this.numberFormat.setMinimumIntegerDigits(minDigits);
        this.numberFormat.setMaximumIntegerDigits(maxDigits);
        return this.numberFormat.format(value);
    }

    private static final boolean isNumeric(char formatChar, int count) {
        int i = NUMERIC_FORMAT_CHARS.indexOf(formatChar);
        return i > 0 || i == 0 && count < 3;
    }

    public void parse(String text, Calendar cal, ParsePosition parsePos) {
        int pos;
        int start = pos = parsePos.getIndex();
        boolean[] ambiguousYear = new boolean[1];
        this.parsedTimeZone = null;
        int numericFieldStart = -1;
        int numericFieldLength = 0;
        int numericStartPos = 0;
        Object[] items = this.getPatternItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof PatternItem) {
                PatternItem field = (PatternItem)items[i];
                if (field.isNumeric && numericFieldStart == -1 && i + 1 < items.length && items[i + 1] instanceof PatternItem && ((PatternItem)items[i + 1]).isNumeric) {
                    numericFieldStart = i;
                    numericFieldLength = field.length;
                    numericStartPos = pos;
                }
                if (numericFieldStart != -1) {
                    int len = field.length;
                    if (numericFieldStart == i) {
                        len = numericFieldLength;
                    }
                    if ((pos = this.subParse(text, pos, field.type, len, true, false, ambiguousYear, cal)) < 0) {
                        if (--numericFieldLength == 0) {
                            parsePos.setIndex(start);
                            parsePos.setErrorIndex(pos);
                            return;
                        }
                        i = numericFieldStart;
                        pos = numericStartPos;
                        continue;
                    }
                } else {
                    numericFieldStart = -1;
                    int s = pos;
                    if ((pos = this.subParse(text, pos, field.type, field.length, false, true, ambiguousYear, cal)) < 0) {
                        parsePos.setIndex(start);
                        parsePos.setErrorIndex(s);
                        return;
                    }
                }
            } else {
                numericFieldStart = -1;
                String patl = (String)items[i];
                int plen = patl.length();
                int tlen = text.length();
                int idx = 0;
                while (idx < plen && pos < tlen) {
                    char pch = patl.charAt(idx);
                    char ich = text.charAt(pos);
                    if (UCharacterProperty.isRuleWhiteSpace(pch) && UCharacterProperty.isRuleWhiteSpace(ich)) {
                        while (idx + 1 < plen && UCharacterProperty.isRuleWhiteSpace(patl.charAt(idx + 1))) {
                            ++idx;
                        }
                        while (pos + 1 < tlen && UCharacterProperty.isRuleWhiteSpace(text.charAt(pos + 1))) {
                            ++pos;
                        }
                    } else if (pch != ich) break;
                    ++idx;
                    ++pos;
                }
                if (idx != plen) {
                    parsePos.setIndex(start);
                    parsePos.setErrorIndex(pos);
                    return;
                }
            }
            ++i;
        }
        parsePos.setIndex(pos);
        try {
            if (ambiguousYear[0] || this.parsedTimeZone != null) {
                Date parsedDate;
                Calendar copy = (Calendar)cal.clone();
                if (ambiguousYear[0] && (parsedDate = copy.getTime()).before(this.getDefaultCenturyStart())) {
                    cal.set(1, this.getDefaultCenturyStartYear() + 100);
                }
                if (this.parsedTimeZone != null) {
                    TimeZone tz = this.parsedTimeZone;
                    int[] offsets = new int[2];
                    tz.getOffset(copy.getTimeInMillis() + (long)tz.getRawOffset(), true, offsets);
                    cal.set(15, offsets[0]);
                    cal.set(16, offsets[1]);
                    cal.setTimeZone(tz);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePos.setErrorIndex(pos);
            parsePos.setIndex(start);
        }
    }

    protected int matchString(String text, int start, int field, String[] data, Calendar cal) {
        int i = 0;
        int count = data.length;
        if (field == 7) {
            i = 1;
        }
        int bestMatchLength = 0;
        int bestMatch = -1;
        while (i < count) {
            int length = data[i].length();
            if (length > bestMatchLength && text.regionMatches(true, start, data[i], 0, length)) {
                bestMatch = i;
                bestMatchLength = length;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            cal.set(field, bestMatch);
            return start + bestMatchLength;
        }
        return -start;
    }

    protected int matchQuarterString(String text, int start, int field, String[] data, Calendar cal) {
        int i = 0;
        int count = data.length;
        int bestMatchLength = 0;
        int bestMatch = -1;
        while (i < count) {
            int length = data[i].length();
            if (length > bestMatchLength && text.regionMatches(true, start, data[i], 0, length)) {
                bestMatch = i;
                bestMatchLength = length;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            cal.set(field, bestMatch * 3);
            return start + bestMatchLength;
        }
        return -start;
    }

    private int subParseZoneString(String text, int start, Calendar cal) {
        TimeZone tz = null;
        String zid = null;
        String value = null;
        int type = -1;
        DateFormatSymbols.ZoneItem item = this.formatData.findZoneIDTypeValue(text, start);
        if (item != null) {
            zid = item.zid;
            value = item.value;
            type = item.type;
        }
        if (zid != null) {
            tz = TimeZone.getTimeZone(zid);
        }
        if (tz != null) {
            cal.set(15, tz.getRawOffset());
            if (type == 1 || type == 4) {
                cal.set(16, 0);
                tz = null;
            } else if (type == 2 || type == 5) {
                cal.set(16, 3600000);
                tz = null;
            } else {
                this.parsedTimeZone = tz;
            }
            if (value != null) {
                return start + value.length();
            }
        }
        return 0;
    }

    protected int subParse(String text, int start, char ch, int count, boolean obeyCount, boolean allowNegative, boolean[] ambiguousYear, Calendar cal) {
        Number number = null;
        int value = 0;
        ParsePosition pos = new ParsePosition(0);
        int patternCharIndex = -1;
        if ('A' <= ch && ch <= 'z') {
            patternCharIndex = PATTERN_CHAR_TO_INDEX[ch - 64];
        }
        if (patternCharIndex == -1) {
            return -start;
        }
        int field = PATTERN_INDEX_TO_CALENDAR_FIELD[patternCharIndex];
        while (true) {
            if (start >= text.length()) {
                return -start;
            }
            int c = UTF16.charAt(text, start);
            if (!UCharacter.isUWhiteSpace(c)) break;
            start += UTF16.getCharCount(c);
        }
        pos.setIndex(start);
        if (patternCharIndex == 4 || patternCharIndex == 15 || patternCharIndex == 2 && count <= 2 || patternCharIndex == 1 || patternCharIndex == 8) {
            if (obeyCount) {
                if (start + count > text.length()) {
                    return -start;
                }
                number = this.parseInt(text.substring(0, start + count), pos, allowNegative);
            } else {
                number = this.parseInt(text, pos, allowNegative);
            }
            if (number == null) {
                return -start;
            }
            value = number.intValue();
        }
        switch (patternCharIndex) {
            case 0: {
                if (count == 4) {
                    return this.matchString(text, start, 0, this.formatData.eraNames, cal);
                }
                return this.matchString(text, start, 0, this.formatData.eras, cal);
            }
            case 1: {
                if (count == 2 && pos.getIndex() - start == 2 && Character.isDigit(text.charAt(start)) && Character.isDigit(text.charAt(start + 1))) {
                    int ambiguousTwoDigitYear = this.getDefaultCenturyStartYear() % 100;
                    ambiguousYear[0] = value == ambiguousTwoDigitYear;
                    value += this.getDefaultCenturyStartYear() / 100 * 100 + (value < ambiguousTwoDigitYear ? 100 : 0);
                }
                cal.set(1, value);
                return pos.getIndex();
            }
            case 2: {
                if (count <= 2) {
                    cal.set(2, value - 1);
                    return pos.getIndex();
                }
                int newStart = this.matchString(text, start, 2, this.formatData.months, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 2, this.formatData.shortMonths, cal);
            }
            case 26: {
                if (count <= 2) {
                    cal.set(2, value - 1);
                    return pos.getIndex();
                }
                int newStart = this.matchString(text, start, 2, this.formatData.standaloneMonths, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 2, this.formatData.standaloneShortMonths, cal);
            }
            case 4: {
                if (value == cal.getMaximum(11) + 1) {
                    value = 0;
                }
                cal.set(11, value);
                return pos.getIndex();
            }
            case 8: {
                int i = pos.getIndex() - start;
                if (i < 3) {
                    while (i < 3) {
                        value *= 10;
                        ++i;
                    }
                } else {
                    int a = 1;
                    while (i > 3) {
                        a *= 10;
                        --i;
                    }
                    value = (value + (a >> 1)) / a;
                }
                cal.set(14, value);
                return pos.getIndex();
            }
            case 9: {
                int newStart = this.matchString(text, start, 7, this.formatData.weekdays, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 7, this.formatData.shortWeekdays, cal);
            }
            case 25: {
                int newStart = this.matchString(text, start, 7, this.formatData.standaloneWeekdays, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchString(text, start, 7, this.formatData.standaloneShortWeekdays, cal);
            }
            case 14: {
                return this.matchString(text, start, 9, this.formatData.ampms, cal);
            }
            case 15: {
                if (value == cal.getLeastMaximum(10) + 1) {
                    value = 0;
                }
                cal.set(10, value);
                return pos.getIndex();
            }
            case 17: 
            case 23: 
            case 24: {
                int offset;
                int sign = 0;
                if (text.length() - start >= GMT.length() && text.regionMatches(true, start, GMT, 0, GMT.length())) {
                    cal.set(16, 0);
                    pos.setIndex(start + GMT.length());
                    try {
                        switch (text.charAt(pos.getIndex())) {
                            case '+': {
                                sign = 1;
                                break;
                            }
                            case '-': {
                                sign = -1;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    if (sign == 0) {
                        cal.set(15, 0);
                        return pos.getIndex();
                    }
                    pos.setIndex(pos.getIndex() + 1);
                    int st = pos.getIndex();
                    Number tzNumber = this.numberFormat.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    if (pos.getIndex() < text.length() && text.charAt(pos.getIndex()) == ':') {
                        offset = tzNumber.intValue() * 60;
                        pos.setIndex(pos.getIndex() + 1);
                        tzNumber = this.numberFormat.parse(text, pos);
                        if (tzNumber == null) {
                            return -start;
                        }
                        offset += tzNumber.intValue();
                    } else {
                        offset = tzNumber.intValue();
                        offset = offset < 24 && pos.getIndex() - st <= 2 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                    }
                } else {
                    int i = this.subParseZoneString(text, start, cal);
                    if (i != 0) {
                        return i;
                    }
                    DecimalFormat fmt = new DecimalFormat("+####;-####");
                    fmt.setParseIntegerOnly(true);
                    Number tzNumber = fmt.parse(text, pos);
                    if (tzNumber == null) {
                        return -start;
                    }
                    offset = tzNumber.intValue();
                    sign = 1;
                    if (offset < 0) {
                        sign = -1;
                        offset = -offset;
                    }
                    offset = offset < 24 && pos.getIndex() - start <= 3 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
                }
                offset *= 60000 * sign;
                if (cal.getTimeZone().useDaylightTime()) {
                    cal.set(16, 3600000);
                    offset -= 3600000;
                }
                cal.set(15, offset);
                return pos.getIndex();
            }
            case 27: {
                if (count <= 2) {
                    cal.set(2, (value - 1) * 3);
                    return pos.getIndex();
                }
                int newStart = this.matchQuarterString(text, start, 2, this.formatData.quarters, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchQuarterString(text, start, 2, this.formatData.shortQuarters, cal);
            }
            case 28: {
                if (count <= 2) {
                    cal.set(2, (value - 1) * 3);
                    return pos.getIndex();
                }
                int newStart = this.matchQuarterString(text, start, 2, this.formatData.standaloneQuarters, cal);
                if (newStart > 0) {
                    return newStart;
                }
                return this.matchQuarterString(text, start, 2, this.formatData.standaloneShortQuarters, cal);
            }
        }
        if (obeyCount) {
            if (start + count > text.length()) {
                return -start;
            }
            number = this.parseInt(text.substring(0, start + count), pos, allowNegative);
        } else {
            number = this.parseInt(text, pos, allowNegative);
        }
        if (number != null) {
            cal.set(field, number.intValue());
            return pos.getIndex();
        }
        return -start;
    }

    private Number parseInt(String text, ParsePosition pos, boolean allowNegative) {
        Number number;
        if (allowNegative) {
            number = this.numberFormat.parse(text, pos);
        } else if (this.numberFormat instanceof DecimalFormat) {
            String oldPrefix = ((DecimalFormat)this.numberFormat).getNegativePrefix();
            ((DecimalFormat)this.numberFormat).setNegativePrefix(SUPPRESS_NEGATIVE_PREFIX);
            number = this.numberFormat.parse(text, pos);
            ((DecimalFormat)this.numberFormat).setNegativePrefix(oldPrefix);
        } else {
            boolean dateNumberFormat = this.numberFormat instanceof DateNumberFormat;
            if (dateNumberFormat) {
                ((DateNumberFormat)this.numberFormat).setParsePositiveOnly(true);
            }
            number = this.numberFormat.parse(text, pos);
            if (dateNumberFormat) {
                ((DateNumberFormat)this.numberFormat).setParsePositiveOnly(false);
            }
        }
        return number;
    }

    private String translatePattern(String pattern, String from, String to) {
        StringBuffer result = new StringBuffer();
        boolean inQuote = false;
        int i = 0;
        while (i < pattern.length()) {
            int ci;
            char c = pattern.charAt(i);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (ci = from.indexOf(c)) != -1) {
                c = to.charAt(ci);
            }
            result.append(c);
            ++i;
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return result.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzYeugAZvcLQq", this.formatData.localPatternChars);
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        this.setLocale(null, null);
        this.patternItems = null;
    }

    public void applyLocalizedPattern(String pattern) {
        this.pattern = this.translatePattern(pattern, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKzYeugAZvcLQq");
        this.setLocale(null, null);
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        this.formatData = (DateFormatSymbols)newFormatSymbols.clone();
    }

    protected DateFormatSymbols getSymbols() {
        return this.formatData;
    }

    public Object clone() {
        SimpleDateFormat other = (SimpleDateFormat)super.clone();
        other.formatData = (DateFormatSymbols)this.formatData.clone();
        return other;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SimpleDateFormat that = (SimpleDateFormat)obj;
        return this.pattern.equals(that.pattern) && this.formatData.equals(that.formatData);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.defaultCenturyBase = System.currentTimeMillis();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        this.locale = this.getLocale(ULocale.VALID_LOCALE);
        this.initLocalZeroPaddingNumberFormat();
    }

    private static class PatternItem {
        final char type;
        final int length;
        final boolean isNumeric;

        PatternItem(char type, int length) {
            this.type = type;
            this.length = length;
            this.isNumeric = SimpleDateFormat.isNumeric(type, length);
        }
    }
}

