/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
implements ExportedPackage {
    String specVersion;
    ExportPackageDescription exportedPackage;
    BundleLoaderProxy supplier;

    public ExportedPackageImpl(ExportPackageDescription exportedPackage, BundleLoaderProxy supplier) {
        this.exportedPackage = exportedPackage;
        this.supplier = supplier;
        Version version = exportedPackage.getVersion();
        if (version != null) {
            this.specVersion = version.toString();
        }
    }

    public String getName() {
        return this.exportedPackage.getName();
    }

    public Bundle getExportingBundle() {
        if (this.supplier.isStale()) {
            return null;
        }
        return this.supplier.getBundleHost();
    }

    public Bundle[] getImportingBundles() {
        if (this.supplier.isStale()) {
            return null;
        }
        AbstractBundle bundle = (AbstractBundle)this.getExportingBundle();
        if (bundle == null) {
            return null;
        }
        AbstractBundle[] bundles = bundle.framework.getAllBundles();
        ArrayList<AbstractBundle> importers = new ArrayList<AbstractBundle>(10);
        PackageSource supplierSource = this.supplier.createPackageSource(this.exportedPackage, false);
        int i = 0;
        while (i < bundles.length) {
            BundleLoader loader;
            if (bundles[i] instanceof BundleHost && (loader = ((BundleHost)bundles[i]).getBundleLoader()) != null) {
                PackageSource importerSource = loader.getPackageSource(this.getName());
                if (supplierSource != null && supplierSource.hasCommonSource(importerSource)) {
                    importers.add(bundles[i]);
                }
            }
            ++i;
        }
        return importers.toArray(new Bundle[importers.size()]);
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public Version getVersion() {
        return this.exportedPackage.getVersion();
    }

    public boolean isRemovalPending() {
        BundleDescription exporter = this.exportedPackage.getExporter();
        if (exporter != null) {
            return exporter.isRemovalPending();
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getName());
        if (this.specVersion != null) {
            result.append("; ").append("version");
            result.append("=\"").append(this.specVersion).append("\"");
        }
        return result.toString();
    }
}

