/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.Driver20;
import org.apache.derby.jdbc.ReferenceableDataSource;

class EmbedPooledConnection
implements PooledConnection,
BrokeredConnectionControl {
    private static int idCounter = 0;
    private int connectionId = this.nextId();
    private String idString;
    private Vector eventListener;
    protected EmbedConnection realConnection;
    protected int defaultIsolationLevel;
    private boolean defaultReadOnly;
    protected BrokeredConnection currentConnectionHandle;
    protected final ReferenceableDataSource dataSource;
    private final String username;
    private final String password;
    private final boolean requestPassword;
    private boolean isActive;

    private synchronized int nextId() {
        return idCounter++;
    }

    EmbedPooledConnection(ReferenceableDataSource referenceableDataSource, String string, String string2, boolean bl) throws SQLException {
        this.dataSource = referenceableDataSource;
        this.username = string;
        this.password = string2;
        this.requestPassword = bl;
        this.isActive = true;
        this.openRealConnection();
    }

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        this.closeCurrentConnectionHandle();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        Connection connection = this.getNewCurrentConnectionHandle();
        return connection;
    }

    protected final void openRealConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection(this.username, this.password, this.requestPassword);
        this.realConnection = (EmbedConnection)connection;
        this.defaultIsolationLevel = connection.getTransactionIsolation();
        this.defaultReadOnly = connection.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    protected final Connection getNewCurrentConnectionHandle() {
        BrokeredConnection brokeredConnection = this.currentConnectionHandle = ((Driver20)this.realConnection.getLocalDriver()).newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(brokeredConnection);
        return brokeredConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            Vector vector = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                this.eventListener = vector;
            }
            this.currentConnectionHandle = null;
        }
    }

    protected void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 1) {
            this.realConnection.setHoldability(1);
        }
        this.realConnection.resetFromPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (!this.isActive) {
            return;
        }
        this.closeCurrentConnectionHandle();
        try {
            if (this.realConnection != null && !this.realConnection.isClosed()) {
                this.realConnection.close();
            }
            Object var2_1 = null;
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
            throw throwable;
        }
    }

    public final synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.isActive) {
            return;
        }
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new Vector();
        }
        this.eventListener.addElement(connectionEventListener);
    }

    public final synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.removeElement(connectionEventListener);
        }
    }

    public synchronized Connection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized void notifyError(SQLException sQLException) {
        if (sQLException.getErrorCode() < 40000) {
            return;
        }
        if (this.eventListener != null && this.eventListener.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            Enumeration enumeration = this.eventListener.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized void notifyClose() {
        if (this.eventListener != null && this.eventListener.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Enumeration enumeration = this.eventListener.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    protected final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw Util.noCurrentConnection();
        }
    }

    public boolean isIsolationLevelSetUsingSQLorJDBC() throws SQLException {
        if (this.realConnection != null) {
            return this.realConnection.getLanguageConnection().isIsolationLevelSetUsingSQLorJDBC();
        }
        return false;
    }

    public void resetIsolationLevelFlag() throws SQLException {
        this.realConnection.getLanguageConnection().resetIsolationLevelFlagUsedForSQLandJDBC();
    }

    public void notifyException(SQLException sQLException) {
        this.notifyError(sQLException);
    }

    public void checkAutoCommit(boolean bl) throws SQLException {
    }

    public void checkHoldCursors(int n) throws SQLException {
    }

    public void checkSavepoint() throws SQLException {
    }

    public void checkRollback() throws SQLException {
    }

    public void checkCommit() throws SQLException {
    }

    public boolean closingConnection() throws SQLException {
        this.notifyClose();
        this.currentConnectionHandle = null;
        return false;
    }

    public Statement wrapStatement(Statement statement) throws SQLException {
        return statement;
    }

    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        return preparedStatement;
    }

    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        return callableStatement;
    }

    public void setDrdaID(String string) {
        this.realConnection.setDrdaID(string);
    }

    public void setPrepareIsolation(int n) throws SQLException {
        this.realConnection.setPrepareIsolation(n);
    }

    public int getPrepareIsolation() throws SQLException {
        return this.realConnection.getPrepareIsolation();
    }

    public String toString() {
        if (this.idString == null) {
            this.idString = Integer.toString(this.connectionId);
        }
        return this.idString;
    }
}

