/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.datatools.enablement.oda.ws.util.WSLeafNode;
import org.eclipse.datatools.enablement.oda.ws.util.WSNonLeafNode;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLAdvisor {
    public static final String RE_DELIMITER_OPEARTION = "\\Q$-$\\E";
    public static final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    public static final String SOAP_ENVELOPE_START = "<SOAP-ENV:Envelope";
    public static final String SOAP_ENVELOPE_END = "</SOAP-ENV:Envelope>";
    public static final String SOAP_HEADER_START = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_END = "</SOAP-ENV:Header>";
    public static final String SOAP_BODY_START = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_END = "</SOAP-ENV:Body>";
    public static final String NS_SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NS_SOAP_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_KEY_SOAP_ENV = "SOAP-ENV";
    public static final String NS_KEY_SOAP_ENC = "SOAP-ENC";
    public static final String NS_KEY_XSI = "xsi";
    public static final String NS_KEY_XSD = "xsd";
    public static final String NS_KEY_DEFAULT = "m";
    public static final String NS_DEFAULT = "m:";
    public static final String EMPTY_STRING = "";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String REF = "ref";
    public static final String BASE = "base";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String COMPLEX_TYPE = "complexType";
    private static Map definitionMap = new HashMap();
    private static List primitiveDataTypeList;

    public static Definition getDefinition(String wsdlURI) {
        Definition definition;
        if (definitionMap.containsKey(wsdlURI)) {
            return (Definition)definitionMap.get(wsdlURI);
        }
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            definition = reader.readWSDL(null, wsdlURI);
            definitionMap.put(wsdlURI, definition);
        }
        catch (WSDLException e) {
            return null;
        }
        return definition;
    }

    public static String getLocationURI(String wsdlURI, String operationTrace) {
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return null;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return null;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        List extElements = port.getExtensibilityElements();
        String locationURI = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPAddress)) continue;
                locationURI = ((SOAPAddress)extElements.get(i)).getLocationURI();
                break;
            }
        }
        return locationURI;
    }

    private static boolean checkOperationTrace(String operationTrace) {
        if (WSUtil.isNull(operationTrace)) {
            return false;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        return opSplit.length == 3;
    }

    public static String getSOAPActionURI(String wsdlURI, String operationTrace) {
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return null;
        }
        List extElements = bindingOperation.getExtensibilityElements();
        String soapActionURI = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPOperation)) continue;
                soapActionURI = ((SOAPOperation)extElements.get(i)).getSoapActionURI();
                break;
            }
        }
        return soapActionURI;
    }

    public static String retrieveDocument(Operation operation) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(operation)) {
            return result;
        }
        Element element = operation.getDocumentationElement();
        if (!WSUtil.isNull(element)) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 3) continue;
                result = result + node.getNodeValue();
            }
        }
        return result;
    }

    private static BindingOperation getBindingOperation(String wsdlURI, String operationTrace) {
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return null;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return null;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        BindingOperation bindingOperation = port.getBinding().getBindingOperation(opSplit[2], null, null);
        return bindingOperation;
    }

    public String getSOAPRequestTemplate(String wsdlURI, String operationTrace) {
        String template = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return template;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return template;
        }
        String inOrOutput = "in";
        template = WSDLAdvisor.buildStart() + this.buildHeader(wsdlURI, operationTrace, inOrOutput) + this.buildBody(wsdlURI, operationTrace, inOrOutput) + WSDLAdvisor.buildEnd();
        return template;
    }

    public String getLocalSOAPResponseTemplate(String wsdlURI, String operationTrace) {
        String template = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return template;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return template;
        }
        String inOrOutput = "out";
        template = WSDLAdvisor.buildStart() + this.buildHeader(wsdlURI, operationTrace, inOrOutput) + this.buildBody(wsdlURI, operationTrace, inOrOutput) + WSDLAdvisor.buildEnd();
        return template;
    }

    private static String buildStart() {
        return XML_DECLARATION + WSDLAdvisor.enter() + SOAP_ENVELOPE_START + WSDLAdvisor.buildNamespaceDeclarations();
    }

    private static String buildEnd() {
        return WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_BODY_END + WSDLAdvisor.enter() + SOAP_ENVELOPE_END;
    }

    private static String enter() {
        return "\n";
    }

    private static String tab(int num) {
        String tabs = EMPTY_STRING;
        for (int i = 0; i < num; ++i) {
            tabs = tabs + "\t";
        }
        return tabs;
    }

    private static String buildNamespaceDeclarations() {
        HashMap namespaceURIs = new HashMap();
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENV, NS_SOAP_ENV);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENC, NS_SOAP_ENC);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSI, NS_XSI);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSD, NS_XSD);
        String result = EMPTY_STRING;
        Set uris = namespaceURIs.keySet();
        Iterator iterator = uris.iterator();
        while (iterator.hasNext()) {
            String uri = (String)iterator.next();
            String prefix = (String)namespaceURIs.get(uri);
            result = result + WSDLAdvisor.enter() + "xmlns:" + prefix + "=\"" + uri + "\"";
        }
        return result + ">";
    }

    private static void checkNamespace(Map namespaceURIs, String namespace, String namespaceURI) {
        String resultNS = namespace;
        if (namespaceURI != null && (resultNS = (String)namespaceURIs.get(namespaceURI)) == null) {
            resultNS = namespace;
            while (namespaceURIs.containsValue(resultNS)) {
                resultNS = resultNS + "_" + Integer.toString(namespaceURIs.size());
            }
            namespaceURIs.put(namespaceURI, resultNS);
        }
    }

    private String buildHeader(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPHeader)) continue;
                SOAPHeader soapHeader = (SOAPHeader)extElements.get(i);
                String nameSpace = soapHeader.getMessage().getNamespaceURI();
                String localPart = soapHeader.getPart();
                if (WSUtil.isNull(localPart)) break;
                ArrayList paramNameList = new ArrayList();
                ArrayList paramTypeList = new ArrayList();
                WSDLAdvisor.addParamComplexType(wsdlURI, localPart, paramNameList, paramTypeList);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_START;
                result = inOrOutput == "in" ? result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + localPart + " " + WSDLAdvisor.getQNameSpace(nameSpace) + ">" : result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + localPart + " " + WSDLAdvisor.getQNameSpace(nameSpace) + ">";
                result = result + WSDLAdvisor.buildParametersByList(wsdlURI, NS_DEFAULT, paramNameList, paramTypeList, 3, inOrOutput);
                result = inOrOutput == "in" ? result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + localPart + ">" : result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + localPart + ">";
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_END;
                break;
            }
        }
        return result;
    }

    private WSNonLeafNode generateTargetNode(String wsdlURI, String localPart) {
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        Types types = definition.getTypes();
        if (types != null && types.getExtensibilityElements() != null) {
            List extElements = types.getExtensibilityElements();
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof UnknownExtensibilityElement)) continue;
                Element element = ((UnknownExtensibilityElement)extElements.get(i)).getElement();
                String[] parentNode = new String[]{EMPTY_STRING};
                WSNonLeafNode node = new WSNonLeafNode();
                node = this.generateNode(localPart, element, parentNode, null);
                if (node.getNodeList().size() == 0) continue;
                return node;
            }
        }
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode.setName(localPart);
        ArrayList lowerLeverList = new ArrayList();
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private WSNonLeafNode handleAnonymousComplexNode(Node node, Element element, String[] parentNode, String[] anonymousComplexParentNode) {
        WSNonLeafNode newNode = new WSNonLeafNode();
        ArrayList lowerLeverList = new ArrayList();
        String nodeName = node.getAttributes().getNamedItem(NAME).getNodeValue();
        newNode.setName(nodeName);
        for (int k = 0; k < anonymousComplexParentNode.length; ++k) {
            if (!nodeName.equals(anonymousComplexParentNode[k].toString())) continue;
            newNode.setNodeList(lowerLeverList);
            return newNode;
        }
        String[] subNodeParents = this.generateSubNodeParents(nodeName, parentNode);
        String[] subAnonymousNodeParents = this.generateSubNodeParents(nodeName, anonymousComplexParentNode);
        Node middleNode = this.getSignificantNode(node);
        if (middleNode != null) {
            NodeList subs = middleNode.getChildNodes();
            for (int i = 0; i < subs.getLength(); ++i) {
                Node sub = subs.item(i);
                if (sub.getNodeType() != 1) continue;
                NamedNodeMap nodeMap = sub.getAttributes();
                if (!WSUtil.isNull(nodeMap.getNamedItem(NAME))) {
                    this.handleNodes(element, lowerLeverList, subNodeParents, subAnonymousNodeParents, sub);
                    continue;
                }
                if (!WSUtil.isNull(nodeMap.getNamedItem(REF))) {
                    this.addRef(lowerLeverList, sub, element, subNodeParents);
                    continue;
                }
                this.handleAnonymousComplexNode(sub, element, subNodeParents, subAnonymousNodeParents);
            }
        }
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private boolean isComplexType(Node node, Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node XMLNode = nodes.item(i);
            if (XMLNode.getNodeType() != 1 || WSUtil.isNull(nodeMap = XMLNode.getAttributes()) || WSUtil.isNull(nodeMap.getNamedItem(NAME)) || WSUtil.isNull(node.getAttributes().getNamedItem(TYPE)) || !WSDLAdvisor.getParamTypeLocalPart(node.getAttributes().getNamedItem(TYPE).getNodeValue()).equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue()) || !WSDLAdvisor.getParamTypeLocalPart(XMLNode.getNodeName()).equals(COMPLEX_TYPE)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedSimpleType(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !WSDLAdvisor.getParamTypeLocalPart(node.getNodeName()).equals(SIMPLE_TYPE)) continue;
            return true;
        }
        return false;
    }

    private void addNestedSimpleType(List lowerLeverList, Node node) {
        NodeList subs = node.getChildNodes();
        block0: for (int i = 0; i < subs.getLength(); ++i) {
            Node sub = subs.item(i);
            if (sub.getNodeType() != 1 || !WSDLAdvisor.getParamTypeLocalPart(sub.getNodeName()).equals(SIMPLE_TYPE)) continue;
            NodeList subNodes = sub.getChildNodes();
            for (int j = 0; j < subs.getLength(); ++j) {
                NamedNodeMap subNodeMap;
                Node subNode = subNodes.item(i);
                if (subNode.getNodeType() != 1 || WSUtil.isNull((subNodeMap = subNode.getAttributes()).getNamedItem(BASE)) || WSUtil.isNull(subNode.getParentNode().getParentNode().getAttributes().getNamedItem(NAME))) continue;
                WSLeafNode leafNode = new WSLeafNode();
                leafNode.setName(subNode.getParentNode().getParentNode().getAttributes().getNamedItem(NAME).getNodeValue());
                leafNode.setType(subNodeMap.getNamedItem(BASE).getNodeValue());
                lowerLeverList.add(leafNode);
                continue block0;
            }
        }
    }

    private boolean isAnonymousComplexType(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !WSDLAdvisor.getParamTypeLocalPart(node.getNodeName()).equals(COMPLEX_TYPE) || WSUtil.isNull(XMLNode.getAttributes().getNamedItem(NAME))) continue;
            return true;
        }
        return false;
    }

    private Node getSignificantNode(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || WSUtil.isNull(nodeMap = node.getAttributes())) continue;
            if (!WSUtil.isNull(nodeMap.getNamedItem(NAME)) || !WSUtil.isNull(nodeMap.getNamedItem(REF))) {
                return node.getParentNode();
            }
            return this.getSignificantNode(node);
        }
        return null;
    }

    private String[] generateSubNodeParents(String nodeName, String[] parentNode) {
        String[] subNodeParents = new String[parentNode.length + 1];
        System.arraycopy(parentNode, 0, subNodeParents, 0, parentNode.length);
        subNodeParents[subNodeParents.length - 1] = nodeName;
        return subNodeParents;
    }

    public WSNonLeafNode generateNode(String nodeName, Element element, String[] parentNode, String complexTypeName) {
        String localPart = complexTypeName != null ? complexTypeName : nodeName;
        ArrayList lowerLeverList = new ArrayList();
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode.setName(nodeName);
        for (int k = 0; k < parentNode.length; ++k) {
            if (!nodeName.equals(parentNode[k].toString())) continue;
            newNode.setNodeList(lowerLeverList);
            return newNode;
        }
        String[] subNodeParents = this.generateSubNodeParents(localPart, parentNode);
        NodeList nodes = element.getChildNodes();
        Node XMLNode = this.findElementNodeByName(nodes, localPart);
        if (XMLNode != null) {
            Node middleNode = this.getSignificantNode(XMLNode);
            this.genetateLowerLeverList(element, lowerLeverList, subNodeParents, middleNode, null);
        }
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private Node findElementNodeByName(NodeList nodes, String name) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap XMLNodeNodeMap;
            Node XMLNode = nodes.item(i);
            if (XMLNode.getNodeType() != 1 || WSUtil.isNull(XMLNodeNodeMap = XMLNode.getAttributes()) || WSUtil.isNull(XMLNodeNodeMap.getNamedItem(NAME)) || !name.equalsIgnoreCase(XMLNodeNodeMap.getNamedItem(NAME).getNodeValue())) continue;
            return XMLNode;
        }
        return null;
    }

    private void genetateLowerLeverList(Element element, List lowerLeverList, String[] subNodeParents, Node middleNode, String[] anonymousComplexParentNode) {
        if (middleNode == null) {
            return;
        }
        NodeList subs = middleNode.getChildNodes();
        for (int j = 0; j < subs.getLength(); ++j) {
            Node sub = subs.item(j);
            if (sub == null) {
                return;
            }
            if (sub.getNodeType() != 1) continue;
            this.handleNodes(element, lowerLeverList, subNodeParents, anonymousComplexParentNode, sub);
        }
    }

    private void handleNodes(Element element, List lowerLeverList, String[] subNodeParents, String[] anonymousComplexParentNode, Node sub) {
        NamedNodeMap nodeMap = sub.getAttributes();
        if (!WSUtil.isNull(nodeMap.getNamedItem(TYPE)) && nodeMap.getNamedItem(TYPE).getNodeValue() != REF) {
            String XMLType = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
            if (WSDLAdvisor.isPrimitiveDataType(XMLType)) {
                this.addSimpleType(lowerLeverList, nodeMap);
            } else if (this.isComplexType(sub, element)) {
                this.addComplexType(lowerLeverList, nodeMap, element, subNodeParents);
            } else {
                this.addSimpleType(lowerLeverList, nodeMap);
            }
        } else if (!WSUtil.isNull(nodeMap.getNamedItem(REF))) {
            this.addRef(lowerLeverList, sub, element, subNodeParents);
        } else {
            if (this.isNestedSimpleType(sub)) {
                this.addNestedSimpleType(lowerLeverList, sub);
            }
            if (this.isAnonymousComplexType(sub)) {
                if (anonymousComplexParentNode == null) {
                    anonymousComplexParentNode = new String[]{EMPTY_STRING};
                }
                lowerLeverList.add(this.handleAnonymousComplexNode(sub, element, subNodeParents, anonymousComplexParentNode));
            }
        }
    }

    private void addSimpleType(List lowerLeverList, NamedNodeMap nodeMap) {
        String XMLType = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
        WSLeafNode leafNode = new WSLeafNode();
        leafNode.setName(nodeMap.getNamedItem(NAME).getNodeValue());
        leafNode.setType(XMLType);
        lowerLeverList.add(leafNode);
    }

    private void addComplexType(List lowerLeverList, NamedNodeMap nodeMap, Element element, String[] parentNode) {
        String nodeName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(NAME).getNodeValue());
        String complexTyneName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
        lowerLeverList.add(this.generateNode(nodeName, element, parentNode, complexTyneName));
    }

    private void addRef(List lowerLeverList, Node node, Element element, String[] parentNode) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node XMLNode = nodes.item(i);
            if (XMLNode.getNodeType() != 1 || WSUtil.isNull(nodeMap = XMLNode.getAttributes()) || WSUtil.isNull(nodeMap.getNamedItem(NAME)) || !WSDLAdvisor.getParamTypeLocalPart(node.getAttributes().getNamedItem(REF).getNodeValue()).equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue()) || !this.isNestedSimpleType(XMLNode)) continue;
            this.addNestedSimpleType(lowerLeverList, XMLNode);
            return;
        }
        NamedNodeMap nodeMap = node.getAttributes();
        String nodeName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(REF).getNodeValue());
        lowerLeverList.add(this.generateNode(nodeName, element, parentNode, null));
    }

    private String buildInputParameters(String wsdlURI, String nameSpace, String name, int tabCount) {
        String result = EMPTY_STRING;
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode = this.generateTargetNode(wsdlURI, name);
        result = this.builderRequestParameters(newNode, nameSpace, tabCount);
        return result;
    }

    private String builderRequestParameters(WSNonLeafNode newNode, String nameSpace, int tabCount) {
        String result = EMPTY_STRING;
        List nodeList = newNode.getNodeList();
        for (int i = 0; i < nodeList.size(); ++i) {
            if (nodeList.get(i) instanceof WSLeafNode) {
                WSLeafNode leafnode = (WSLeafNode)nodeList.get(i);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + leafnode.getName() + WSDLAdvisor.buildParamType(leafnode.getType()) + ">&?" + leafnode.getName() + "?&</" + nameSpace + leafnode.getName() + ">";
                continue;
            }
            if (!(nodeList.get(i) instanceof WSNonLeafNode)) continue;
            WSNonLeafNode nonLeafnode = (WSNonLeafNode)nodeList.get(i);
            result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + nonLeafnode.getName() + ">";
            result = result + this.builderRequestParameters(nonLeafnode, nameSpace, tabCount + 1);
            result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + nonLeafnode.getName() + ">";
        }
        return result;
    }

    private String builderResponseParameters(WSNonLeafNode newNode) {
        String result = EMPTY_STRING;
        List nodeList = newNode.getNodeList();
        for (int i = 0; i < nodeList.size(); ++i) {
            if (nodeList.get(i) instanceof WSLeafNode) {
                WSLeafNode leafnode = (WSLeafNode)nodeList.get(i);
                result = result + WSDLAdvisor.enter() + "<" + leafnode.getName() + ">" + "</" + leafnode.getName() + ">";
                continue;
            }
            if (!(nodeList.get(i) instanceof WSNonLeafNode)) continue;
            WSNonLeafNode nonLeafnode = (WSNonLeafNode)nodeList.get(i);
            result = result + WSDLAdvisor.enter() + "<" + nonLeafnode.getName() + ">";
            result = result + this.builderResponseParameters(nonLeafnode);
            result = result + WSDLAdvisor.enter() + "</" + nonLeafnode.getName() + ">";
        }
        return result;
    }

    private String buildOutputParameters(String wsdlURI, String name) {
        String result = EMPTY_STRING;
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode = this.generateTargetNode(wsdlURI, name);
        result = this.builderResponseParameters(newNode);
        return result;
    }

    private static String getParamTypeLocalPart(String paramType) {
        return paramType.substring(paramType.lastIndexOf(":") + 1);
    }

    private static String buildParamType(String paramType) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(paramType)) {
            return result;
        }
        result = result + " xsi:type=\"xsd:" + WSDLAdvisor.getParamTypeLocalPart(paramType) + "\"";
        return result;
    }

    private String buildBody(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_BODY_START;
        result = WSDLAdvisor.isRPC(wsdlURI, operationTrace) ? result + this.buildBodyRPC(wsdlURI, operationTrace, inOrOutput) : result + this.buildBodyDoc(wsdlURI, operationTrace, inOrOutput);
        return result;
    }

    private static boolean isRPC(String wsdlURI, String operationTrace) {
        boolean isRPC = false;
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        Port port = service.getPort(opSplit[1]);
        Binding binding = port.getBinding();
        List extElements = binding.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPBinding)) continue;
                isRPC = !WSUtil.isNull(((SOAPBinding)extElements.get(i)).getStyle()) && ((SOAPBinding)extElements.get(i)).getStyle().equalsIgnoreCase("rpc");
                break;
            }
        }
        return isRPC;
    }

    private String buildBodyRPC(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = operation.getInput().getMessage().getOrderedParts(partOrder);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            ArrayList<String> paramNameList = new ArrayList<String>();
            ArrayList<String> paramTypeList = new ArrayList<String>();
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                QName typeName = part.getTypeName();
                paramNameList.add(part.getName());
                paramTypeList.add(WSUtil.getNonNullString(WSUtil.isNull(typeName) ? EMPTY_STRING : typeName.getLocalPart()));
            }
            result = inOrOutput == "in" ? result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + operation.getName() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceRPC(bindingOperation)) + ">" : result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + operation.getName() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceRPC(bindingOperation)) + ">";
            result = result + WSDLAdvisor.buildParametersByList(wsdlURI, EMPTY_STRING, paramNameList, paramTypeList, 3, inOrOutput);
            result = inOrOutput == "in" ? result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + operation.getName() + ">" : result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + operation.getName() + ">";
        }
        return result;
    }

    private static String getNameSpaceRPC(BindingOperation bindingOperation) {
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        String nameSpace = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPBody)) continue;
                nameSpace = ((SOAPBody)extElements.get(i)).getNamespaceURI();
                break;
            }
        }
        return nameSpace;
    }

    private static String getQNameSpace(String nameSpace) {
        if (WSUtil.isNull(nameSpace)) {
            return EMPTY_STRING;
        }
        return "xmlns:m=\"" + nameSpace + "\"";
    }

    private String buildBodyDoc(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = inOrOutput == "in" ? operation.getInput().getMessage().getOrderedParts(partOrder) : operation.getOutput().getMessage().getOrderedParts(partOrder);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                if (WSUtil.isNull(part.getElementName())) continue;
                result = inOrOutput == "in" ? this.compositeInputBodyDoc(wsdlURI, part.getElementName().getLocalPart(), result) : this.compositeOutputBodyDoc(wsdlURI, part.getElementName().getLocalPart(), result);
            }
        }
        return result;
    }

    private String compositeInputBodyDoc(String wsdlURI, String name, String result) {
        result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + name + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceDoc(wsdlURI)) + ">";
        result = result + this.buildInputParameters(wsdlURI, NS_DEFAULT, name, 3);
        result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + name + ">";
        return result;
    }

    private String compositeOutputBodyDoc(String wsdlURI, String name, String result) {
        result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + name + ">";
        result = result + this.buildOutputParameters(wsdlURI, name);
        result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + name + ">";
        return result;
    }

    private static void addParamComplexType(String wsdlURI, String localPart, List paramNameList, List paramTypeList) {
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        Types types = definition.getTypes();
        List extElements = types.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            if (!(extElements.get(i) instanceof UnknownExtensibilityElement)) continue;
            Element element = ((UnknownExtensibilityElement)extElements.get(i)).getElement();
            List teList = WSDLAdvisor.retrieveTargetElementList(element, localPart);
            for (int j = 0; j < teList.size(); ++j) {
                Element te = (Element)teList.get(j);
                if (WSUtil.isNull(te)) continue;
                paramNameList.add(te.getAttribute(NAME));
                paramTypeList.add(te.getAttribute(TYPE));
            }
        }
    }

    private static List retrieveTargetElementList(Element element, String localPart) {
        ArrayList teList = new ArrayList();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || WSUtil.isNull(nodeMap = node.getAttributes()) || WSUtil.isNull(nodeMap.getNamedItem(NAME)) || !localPart.equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue())) continue;
            if (WSUtil.isNull(nodeMap.getNamedItem(TYPE))) {
                WSDLAdvisor.retrieveNamedElements(teList, node);
                continue;
            }
            WSDLAdvisor.retrieveTargetElementList(element, nodeMap.getNamedItem(TYPE).getNodeName());
        }
        return teList;
    }

    private static void retrieveNamedElements(List teList, Node node) {
        NodeList subs = node.getChildNodes();
        for (int i = 0; i < subs.getLength(); ++i) {
            Node sub = subs.item(i);
            if (sub.getNodeType() != 1) continue;
            NamedNodeMap subMap = sub.getAttributes();
            if (WSUtil.isNull(subMap) || WSUtil.isNull(subMap.getNamedItem(NAME))) {
                WSDLAdvisor.retrieveNamedElements(teList, sub);
                continue;
            }
            teList.add((Element)sub);
        }
    }

    private static String buildParametersByList(String wsdlURI, String nameSpace, List paramNames, List paramTypes, int tabCount, String inOrOutput) {
        String result = EMPTY_STRING;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i).toString();
            String paramType = paramTypes.get(i).toString();
            if (!WSDLAdvisor.isPrimitiveDataType(paramType)) {
                ArrayList paramNameList = new ArrayList();
                ArrayList paramTypeList = new ArrayList();
                WSDLAdvisor.addParamComplexType(wsdlURI, WSDLAdvisor.getParamTypeLocalPart(paramType), paramNameList, paramTypeList);
                if (paramNameList.isEmpty() && paramTypeList.isEmpty()) {
                    if (inOrOutput == "in") {
                        result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">&?" + paramName + "?&</" + nameSpace + paramName + ">";
                        continue;
                    }
                    result = result + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">";
                    continue;
                }
                if (inOrOutput == "in") {
                    result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">";
                    result = result + WSDLAdvisor.buildParametersByList(wsdlURI, nameSpace, paramNameList, paramTypeList, tabCount + 1, inOrOutput);
                    result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + paramName + ">";
                    continue;
                }
                result = result + WSDLAdvisor.enter() + "<" + paramName + ">";
                result = result + WSDLAdvisor.buildParametersByList(wsdlURI, nameSpace, paramNameList, paramTypeList, tabCount, inOrOutput);
                result = result + WSDLAdvisor.enter() + "</" + paramName + ">";
                continue;
            }
            result = inOrOutput == "in" ? result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + WSDLAdvisor.buildParamType(paramType) + ">&?" + paramName + "?&</" + nameSpace + paramName + ">" : result + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">";
        }
        return result;
    }

    private static String getNameSpaceDoc(String wsdlURI) {
        String namespace = EMPTY_STRING;
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        Types types = definition.getTypes();
        List extElements = types.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            if (!(extElements.get(i) instanceof UnknownExtensibilityElement)) continue;
            Element element = ((UnknownExtensibilityElement)extElements.get(i)).getElement();
            namespace = element.getAttribute("targetNamespace");
            return namespace;
        }
        return namespace;
    }

    private static boolean isPrimitiveDataType(String dataType) {
        if (WSUtil.isNull(dataType)) {
            return true;
        }
        return WSDLAdvisor.getDataTypeList().contains(dataType.substring(dataType.indexOf(":") + 1).toLowerCase());
    }

    private static List getDataTypeList() {
        if (WSUtil.isNull(primitiveDataTypeList)) {
            primitiveDataTypeList = new ArrayList();
        }
        if (primitiveDataTypeList.isEmpty()) {
            WSDLAdvisor.initDataTypeList();
        }
        return primitiveDataTypeList;
    }

    private static void initDataTypeList() {
        primitiveDataTypeList.add("short");
        primitiveDataTypeList.add("int");
        primitiveDataTypeList.add("float");
        primitiveDataTypeList.add("double");
        primitiveDataTypeList.add("decimal");
        primitiveDataTypeList.add("string");
        primitiveDataTypeList.add("boolean");
        primitiveDataTypeList.add("datetime ");
        primitiveDataTypeList.add("date");
        primitiveDataTypeList.add("time");
    }
}

