/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import org.eclipse.birt.report.item.crosstab.core.IAggregationCellConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class AggregationCellHandle
extends CrosstabCellHandle
implements IAggregationCellConstants,
ICrosstabConstants {
    AggregationCellHandle(DesignElementHandle handle) {
        super(handle);
    }

    public LevelHandle getAggregationOnRow() {
        return (LevelHandle)this.handle.getElementProperty("aggregationOnRow");
    }

    public LevelHandle getAggregationOnColumn() {
        return (LevelHandle)this.handle.getElementProperty("aggregationOnColumn");
    }

    protected LevelHandle getLevel(int axisType) {
        switch (axisType) {
            case 0: {
                return this.getAggregationOnRow();
            }
            case 1: {
                return this.getAggregationOnColumn();
            }
        }
        return null;
    }

    public String getDimensionName(int axisType) {
        LevelHandle cubeLevel = this.getLevel(axisType);
        if (cubeLevel == null) {
            return null;
        }
        DesignElementHandle hierarchy = cubeLevel.getContainer();
        DesignElementHandle dimension = hierarchy == null ? null : hierarchy.getContainer();
        return dimension == null ? null : dimension.getQualifiedName();
    }

    public String getLevelName(int axisType) {
        switch (axisType) {
            case 0: {
                return this.handle.getStringProperty("aggregationOnRow");
            }
            case 1: {
                return this.handle.getStringProperty("aggregationOnColumn");
            }
        }
        return null;
    }

    public int getDimensionViewIndex(int axisType) {
        DimensionViewHandle dimensionView = this.getDimensionView(axisType);
        return dimensionView == null ? -1 : dimensionView.getIndex();
    }

    public DimensionViewHandle getDimensionView(int axisType) {
        ExtendedItemHandle crosstab = (ExtendedItemHandle)this.getCrosstabHandle();
        if (crosstab == null) {
            return null;
        }
        CrosstabReportItemHandle crosstabItem = (CrosstabReportItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)crosstab);
        if (crosstabItem == null) {
            return null;
        }
        DimensionViewHandle dimensionView = crosstabItem.getDimension(this.getDimensionName(axisType));
        return dimensionView;
    }

    public int getLevelViewIndex(int axisType) {
        DimensionViewHandle dimensionView = this.getDimensionView(axisType);
        if (dimensionView == null) {
            return -1;
        }
        LevelViewHandle levelView = dimensionView.getLevel(this.getLevelName(axisType));
        return levelView == null ? -1 : levelView.getIndex();
    }

    public LevelViewHandle getLevelView(int axisType) {
        DimensionViewHandle dimensionView = this.getDimensionView(axisType);
        if (dimensionView == null) {
            return null;
        }
        return dimensionView.getLevel(this.getLevelName(axisType));
    }
}

