/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabViewTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.LevelViewTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;

public class CrosstabReportItemTask
extends AbstractCrosstabModelTask {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabReportItemTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CrosstabReportItemTask(CrosstabReportItemHandle focus) {
        super(focus);
        this.crosstab = focus;
    }

    public CrosstabCellHandle addGrandTotal(int axisType, List measureList, List functionList) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return null;
        }
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.add.grandtotal"));
        CrosstabCellHandle grandTotal = null;
        try {
            CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
            if (crosstabView == null) {
                crosstabView = this.crosstab.addCrosstabView(axisType);
            }
            grandTotal = new CrosstabViewTask(crosstabView).addGrandTotal(measureList, functionList, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return grandTotal;
    }

    public void removeGrandTotal(int axisType) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeGrandTotal();
        }
    }

    public void removeGrandTotal(int axisType, int measureIndex) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeGrandTotal(measureIndex);
        }
    }

    public List getAggregationMeasures(int axisType) {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MeasureViewHandle> measures = new ArrayList<MeasureViewHandle>();
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            if (!measures.contains(measureView) && CrosstabModelUtil.isAggregationOn(measureView, null, axisType)) {
                measures.add(measureView);
            }
            ++i;
        }
        return measures;
    }

    public String getAggregationFunction(int axisType, MeasureViewHandle measureView) {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null || measureView == null || this.crosstab != measureView.getCrosstab()) {
            return null;
        }
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            String function;
            AggregationCellHandle cell = measureView.getAggregationCell(j);
            if ((axisType == 1 && cell.getAggregationOnColumn() == null || axisType == 0 && cell.getAggregationOnRow() == null) && (function = CrosstabModelUtil.getAggregationFunction(this.crosstab, cell)) != null) {
                return function;
            }
            ++j;
        }
        return null;
    }

    public void setAggregationFunction(int axisType, MeasureViewHandle measureView, String function) throws SemanticException {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null || measureView == null || this.crosstab != measureView.getCrosstab()) {
            return;
        }
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.set.aggregate.function"));
        try {
            int j = 0;
            while (j < measureView.getAggregationCount()) {
                AggregationCellHandle cell = measureView.getAggregationCell(j);
                if (axisType == 1 && cell.getAggregationOnColumn() == null || axisType == 0 && cell.getAggregationOnRow() == null) {
                    CrosstabModelUtil.setAggregationFunction(this.crosstab, cell, function);
                }
                ++j;
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void pivotDimension(String name, int targetAxisType, int targetIndex) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(name);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), new String[]{name, this.crosstab.getModelHandle().getElement().getIdentifier()}, "Error.CrosstabException.DIMENSION_NOT_FOUND");
        }
        this.moveDimension(dimensionView, targetAxisType, targetIndex);
    }

    private void moveDimension(DimensionViewHandle dimensionView, int targetAxisType, int targetIndex) throws SemanticException {
        if (!$assertionsDisabled && dimensionView == null) {
            throw new AssertionError();
        }
        HashMap functionListMap = new HashMap();
        HashMap<String, List> measureListMap = new HashMap<String, List>();
        int i = 0;
        while (i < dimensionView.getLevelCount()) {
            LevelViewHandle levelView = dimensionView.getLevel(i);
            String name = levelView.getCubeLevelName();
            if (name != null) {
                List measureList = levelView.getAggregationMeasures();
                ArrayList<String> functionList = new ArrayList<String>();
                int j = 0;
                while (j < measureList.size()) {
                    MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(j);
                    String function = levelView.getAggregationFunction(measureView);
                    if (function == null) {
                        functionList.add("sum");
                    } else {
                        functionList.add(function);
                    }
                    ++j;
                }
                functionListMap.put(name, functionList);
                measureListMap.put(name, measureList);
            }
            ++i;
        }
        List grandMeasureList = this.getAggregationMeasures(targetAxisType);
        ArrayList<String> grandFunctionList = new ArrayList<String>();
        int j = 0;
        while (j < grandMeasureList.size()) {
            MeasureViewHandle measureView = (MeasureViewHandle)grandMeasureList.get(j);
            String function = this.getAggregationFunction(targetAxisType, measureView);
            if (function == null) {
                grandFunctionList.add("sum");
            } else {
                grandFunctionList.add(function);
            }
            ++j;
        }
        DimensionViewHandle clonedDimensionView = (DimensionViewHandle)CrosstabUtil.getReportItem(dimensionView.getModelHandle().copy().getHandle(dimensionView.getModelHandle().getModule()));
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.pivot.dimension"));
        try {
            int i2;
            CrosstabViewHandle srcCrosstabView = (CrosstabViewHandle)dimensionView.getContainer();
            new CrosstabViewTask(srcCrosstabView).removeDimension(dimensionView, false);
            CrosstabViewHandle targetCrosstabView = this.crosstab.getCrosstabView(targetAxisType);
            if (targetCrosstabView == null) {
                targetCrosstabView = this.crosstab.addCrosstabView(targetAxisType);
            }
            ArrayList<MeasureViewHandle> transferMeasureList = new ArrayList<MeasureViewHandle>();
            ArrayList<String> transferFunctionList = new ArrayList<String>();
            if (targetCrosstabView.getDimensionCount() == 0 && targetCrosstabView.getGrandTotal() == null) {
                i2 = 0;
                while (i2 < srcCrosstabView.getDimensionCount()) {
                    DimensionViewHandle dv = srcCrosstabView.getDimension(i2);
                    int j2 = 0;
                    while (j2 < dv.getLevelCount()) {
                        LevelViewHandle lv = dv.getLevel(j2);
                        if (lv.getAggregationHeader() != null) {
                            int k = 0;
                            while (k < this.crosstab.getMeasureCount()) {
                                AggregationCellHandle aggCell;
                                MeasureViewHandle mv = this.crosstab.getMeasure(k);
                                String rowDimension = null;
                                String rowLevel = null;
                                String colDimension = dv.getCubeDimensionName();
                                String colLevel = lv.getCubeLevelName();
                                if (srcCrosstabView.getAxisType() == 0) {
                                    rowDimension = colDimension;
                                    rowLevel = colLevel;
                                    colDimension = null;
                                    colLevel = null;
                                }
                                if ((aggCell = mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel)) != null) {
                                    aggCell.getModelHandle().drop();
                                }
                                ++k;
                            }
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (srcCrosstabView.getGrandTotal() != null) {
                    i2 = 0;
                    while (i2 < this.crosstab.getMeasureCount()) {
                        MeasureViewHandle mv = this.crosstab.getMeasure(i2);
                        AggregationCellHandle aggCell = mv.getAggregationCell(null, null, null, null);
                        if (aggCell != null) {
                            String function = this.getAggregationFunction(srcCrosstabView.getAxisType(), mv);
                            aggCell.getModelHandle().drop();
                            transferMeasureList.add(mv);
                            transferFunctionList.add(function);
                        }
                        ++i2;
                    }
                }
            }
            targetCrosstabView.getViewsProperty().add(clonedDimensionView.getModelHandle(), targetIndex);
            if (transferMeasureList.size() > 0 && clonedDimensionView.getLevelCount() > 0) {
                this.addMeasureAggregations(clonedDimensionView.getLevel(clonedDimensionView.getLevelCount() - 1), transferMeasureList, transferFunctionList, false);
            }
            i2 = 0;
            while (i2 < clonedDimensionView.getLevelCount()) {
                LevelViewHandle levelView = clonedDimensionView.getLevel(i2);
                String levelName = levelView.getCubeLevelName();
                if (levelName != null) {
                    if (levelView.isInnerMost()) {
                        if (levelView.getAggregationHeaderProperty().getContentCount() > 0) {
                            levelView.getAggregationHeaderProperty().drop(0);
                        }
                    } else {
                        List measureList = (List)measureListMap.get(levelName);
                        List functionList = (List)functionListMap.get(levelName);
                        new LevelViewTask(levelView).addSubTotal(measureList, functionList, false);
                    }
                }
                ++i2;
            }
            if (grandMeasureList.size() > 0) {
                this.addMeasureAggregations(targetAxisType, grandMeasureList, grandFunctionList, false);
            }
            this.validateCrosstab();
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void pivotDimension(int srcAxisType, int srcIndex, int targetAxisType, int targetIndex) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(srcAxisType, srcIndex);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.INFO, "Error.CrosstabException.DIMENSION_NOT_FOUND", new Object[]{String.valueOf(srcAxisType), String.valueOf(srcIndex)});
            return;
        }
        this.moveDimension(dimensionView, targetAxisType, targetIndex);
    }

    public DimensionViewHandle insertDimension(DimensionHandle dimensionHandle, int axisType, int index) throws SemanticException {
        if (dimensionHandle != null && this.crosstab.getDimension(dimensionHandle.getQualifiedName()) != null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_DIMENSION", dimensionHandle.getQualifiedName());
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), new String[]{dimensionHandle.getQualifiedName(), this.crosstab.getModelHandle().getElement().getIdentifier()}, "Error.CrosstabException.DUPLICATE_DIMENSION");
        }
        DimensionViewHandle dimensionView = null;
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.insert.dimension"));
        try {
            CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
            if (crosstabView == null) {
                crosstabView = this.crosstab.addCrosstabView(axisType);
            }
            dimensionView = crosstabView.insertDimension(dimensionHandle, index);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return dimensionView;
    }

    public void removeDimension(String name) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(name);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), new String[]{name, this.crosstab.getModelHandle().getElement().getIdentifier()}, "Error.CrosstabException.DIMENSION_NOT_FOUND");
        }
        this.removeDimension(dimensionView.getAxisType(), dimensionView.getIndex());
    }

    public void removeDimension(int axisType, int index) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeDimension(index);
        }
    }
}

