/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TOCHandle;

class ContentUtil {
    private ContentUtil() {
    }

    static void processStyle(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        IStyle style = ContentUtil.processStyle(context.getReportContent(), handle, evaluator, styleCache);
        if (style != null && !style.isEmpty()) {
            content.setInlineStyle(style);
        }
    }

    static IStyle processStyle(IReportContent reportContent, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        ReportElementHandle modelHandle = ContentUtil.getReportElementHandle(handle);
        if (modelHandle == null || modelHandle.getPrivateStyle() == null || reportContent == null) {
            return null;
        }
        IStyle style = reportContent.createStyle();
        if (styleCache != null && handle instanceof CrosstabCellHandle) {
            IStyle cachedStyle = (IStyle)styleCache.get(modelHandle);
            if (cachedStyle != null) {
                style.setProperties(cachedStyle);
            } else {
                ContentUtil.setupPrivateStyle(modelHandle, style);
                styleCache.put(modelHandle, style);
            }
        } else {
            ContentUtil.setupPrivateStyle(modelHandle, style);
        }
        if (evaluator != null) {
            IStyle highlightStyle = reportContent.createStyle();
            ContentUtil.setupHighlightStyle(modelHandle, highlightStyle, evaluator);
            if (!highlightStyle.isEmpty()) {
                IStyle newStyle = reportContent.createStyle();
                newStyle.setProperties(style);
                newStyle.setProperties(highlightStyle);
                return newStyle;
            }
        }
        return style;
    }

    static void setupHighlightStyle(ReportElementHandle handle, IStyle style, IBaseResultSet evaluator) throws BirtException {
        Iterator itr = handle.getPrivateStyle().highlightRulesIterator();
        while (itr != null && itr.hasNext()) {
            HighlightRuleHandle rule = (HighlightRuleHandle)itr.next();
            IConditionalExpression expression = ExpressionUtil.transformConditionalExpression((IConditionalExpression)new ConditionalExpression(rule.getTestExpression(), ContentUtil.toDteFilterOperator(rule.getOperator()), rule.getValue1(), rule.getValue2()));
            Object value = evaluator.evaluate((IBaseExpression)expression);
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            ContentUtil.setupRuleStyle((StructureHandle)rule, style);
        }
    }

    static void processVisibility(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        String visibleFormat = ContentUtil.processVisibility(handle, evaluator);
        if (visibleFormat != null) {
            content.getStyle().setVisibleFormat(visibleFormat);
        }
    }

    static String processVisibility(AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return null;
        }
        Iterator visItr = modelHandle.visibilityRulesIterator();
        if (visItr != null && visItr.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            while (visItr.hasNext()) {
                boolean isHidden;
                HideRuleHandle rule = (HideRuleHandle)visItr.next();
                String expr = ContentUtil.validExpression(rule.getExpression());
                Object result = null;
                if (expr != null) {
                    result = evaluator.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean) || !(isHidden = ((Boolean)result).booleanValue())) continue;
                buffer.append(rule.getFormat()).append(", ");
            }
            int len = buffer.length();
            if (len > 2) {
                buffer.delete(len - 2, len);
            }
            return buffer.toString();
        }
        return null;
    }

    static void processBookmark(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        Object tmp;
        TOCHandle toc;
        Object tmp2;
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return;
        }
        String bookmark = modelHandle.getBookmark();
        if (bookmark != null && (tmp2 = evaluator.evaluate(ContentUtil.validExpression(bookmark))) != null && !tmp2.equals("")) {
            content.setBookmark(tmp2.toString());
        }
        if ((toc = modelHandle.getTOC()) != null && (tmp = evaluator.evaluate(ContentUtil.validExpression(toc.getExpression()))) != null) {
            content.setTOC(tmp);
        }
    }

    static void processAction(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle) {
    }

    static String validExpression(String expr) {
        if (expr != null && expr.trim().length() > 0) {
            return expr;
        }
        return null;
    }

    static ReportItemHandle getReportItemHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportItemHandle) {
            return (ReportItemHandle)handle.getModelHandle();
        }
        return null;
    }

    static ReportElementHandle getReportElementHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportElementHandle) {
            return (ReportElementHandle)handle.getModelHandle();
        }
        return null;
    }

    static void setupPrivateStyle(ReportElementHandle handle, IStyle style) {
        style.setBackgroundColor(ContentUtil.getElementProperty(handle, "backgroundColor", true));
        style.setBackgroundImage(ContentUtil.getElementProperty(handle, "backgroundImage"));
        style.setBackgroundPositionX(ContentUtil.getElementProperty(handle, "backgroundPositionX"));
        style.setBackgroundPositionY(ContentUtil.getElementProperty(handle, "backgroundPositionY"));
        style.setBackgroundRepeat(ContentUtil.getElementProperty(handle, "backgroundRepeat"));
        style.setTextAlign(ContentUtil.getElementProperty(handle, "textAlign"));
        style.setTextIndent(ContentUtil.getElementProperty(handle, "textIndent"));
        style.setTextUnderline(ContentUtil.getElementProperty(handle, "textUnderline"));
        style.setTextLineThrough(ContentUtil.getElementProperty(handle, "textLineThrough"));
        style.setTextOverline(ContentUtil.getElementProperty(handle, "textOverline"));
        style.setLetterSpacing(ContentUtil.getElementProperty(handle, "letterSpacing"));
        style.setLineHeight(ContentUtil.getElementProperty(handle, "lineHeight"));
        style.setOrphans(ContentUtil.getElementProperty(handle, "orphans"));
        style.setTextTransform(ContentUtil.getElementProperty(handle, "textTransform"));
        style.setVerticalAlign(ContentUtil.getElementProperty(handle, "verticalAlign"));
        style.setWhiteSpace(ContentUtil.getElementProperty(handle, "whiteSpace"));
        style.setWidows(ContentUtil.getElementProperty(handle, "widows"));
        style.setWordSpacing(ContentUtil.getElementProperty(handle, "wordSpacing"));
        style.setDisplay(ContentUtil.getElementProperty(handle, "display"));
        style.setMasterPage(ContentUtil.getElementProperty(handle, "masterPage"));
        String pageBreakAfter = ContentUtil.getElementProperty(handle, "pageBreakAfter");
        style.setPageBreakAfter(ContentUtil.decodePageBreak(pageBreakAfter));
        String pageBreakBefore = ContentUtil.getElementProperty(handle, "pageBreakBefore");
        style.setPageBreakBefore(ContentUtil.decodePageBreak(pageBreakBefore));
        style.setPageBreakInside(ContentUtil.getElementProperty(handle, "pageBreakInside"));
        style.setFontFamily(ContentUtil.getElementProperty(handle, "fontFamily"));
        style.setColor(ContentUtil.getElementProperty(handle, "color", true));
        style.setFontSize(ContentUtil.getElementProperty(handle, "fontSize"));
        style.setFontStyle(ContentUtil.getElementProperty(handle, "fontStyle"));
        style.setFontWeight(ContentUtil.getElementProperty(handle, "fontWeight"));
        style.setFontVariant(ContentUtil.getElementProperty(handle, "fontVariant"));
        style.setBorderBottomColor(ContentUtil.getElementProperty(handle, "borderBottomColor", true));
        style.setBorderBottomStyle(ContentUtil.getElementProperty(handle, "borderBottomStyle"));
        style.setBorderBottomWidth(ContentUtil.getElementProperty(handle, "borderBottomWidth"));
        style.setBorderLeftColor(ContentUtil.getElementProperty(handle, "borderLeftColor", true));
        style.setBorderLeftStyle(ContentUtil.getElementProperty(handle, "borderLeftStyle"));
        style.setBorderLeftWidth(ContentUtil.getElementProperty(handle, "borderLeftWidth"));
        style.setBorderRightColor(ContentUtil.getElementProperty(handle, "borderRightColor", true));
        style.setBorderRightStyle(ContentUtil.getElementProperty(handle, "borderRightStyle"));
        style.setBorderRightWidth(ContentUtil.getElementProperty(handle, "borderRightWidth"));
        style.setBorderTopColor(ContentUtil.getElementProperty(handle, "borderTopColor", true));
        style.setBorderTopStyle(ContentUtil.getElementProperty(handle, "borderTopStyle"));
        style.setBorderTopWidth(ContentUtil.getElementProperty(handle, "borderTopWidth"));
        style.setMarginTop(ContentUtil.getElementProperty(handle, "marginTop"));
        style.setMarginLeft(ContentUtil.getElementProperty(handle, "marginLeft"));
        style.setMarginBottom(ContentUtil.getElementProperty(handle, "marginBottom"));
        style.setMarginRight(ContentUtil.getElementProperty(handle, "marginRight"));
        style.setPaddingTop(ContentUtil.getElementProperty(handle, "paddingTop"));
        style.setPaddingLeft(ContentUtil.getElementProperty(handle, "paddingLeft"));
        style.setPaddingBottom(ContentUtil.getElementProperty(handle, "paddingBottom"));
        style.setPaddingRight(ContentUtil.getElementProperty(handle, "paddingRight"));
        style.setNumberAlign(ContentUtil.getElementProperty(handle, "numberAlign"));
        style.setDateFormat(ContentUtil.getElementProperty(handle, "dateTimeFormat"));
        style.setNumberFormat(ContentUtil.getElementProperty(handle, "numberFormat"));
        style.setStringFormat(ContentUtil.getElementProperty(handle, "stringFormat"));
        style.setCanShrink(ContentUtil.getElementProperty(handle, "canShrink"));
        style.setShowIfBlank(ContentUtil.getElementProperty(handle, "showIfBlank"));
    }

    static IStyle setupRuleStyle(StructureHandle highlight, IStyle style) {
        String value = ContentUtil.getMemberProperty(highlight, "backgroundColor");
        if (value != null) {
            style.setBackgroundColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textAlign")) != null) {
            style.setTextAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textIndent")) != null) {
            style.setTextIndent(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textUnderline")) != null) {
            style.setTextUnderline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textLineThrough")) != null) {
            style.setTextLineThrough(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textOverline")) != null) {
            style.setTextOverline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textTransform")) != null) {
            style.setTextTransform(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontFamily")) != null) {
            style.setFontFamily(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "color")) != null) {
            style.setColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontSize")) != null) {
            style.setFontSize(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontStyle")) != null) {
            style.setFontStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontWeight")) != null) {
            style.setFontWeight(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontVariant")) != null) {
            style.setFontVariant(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomColor")) != null) {
            style.setBorderBottomColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomStyle")) != null) {
            style.setBorderBottomStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomWidth")) != null) {
            style.setBorderBottomWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftColor")) != null) {
            style.setBorderLeftColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftStyle")) != null) {
            style.setBorderLeftStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftWidth")) != null) {
            style.setBorderLeftWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightColor")) != null) {
            style.setBorderRightColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightStyle")) != null) {
            style.setBorderRightStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightWidth")) != null) {
            style.setBorderRightWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopColor")) != null) {
            style.setBorderTopColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopStyle")) != null) {
            style.setBorderTopStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopWidth")) != null) {
            style.setBorderTopWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberAlign")) != null) {
            style.setNumberAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "dateTimeFormat")) != null) {
            style.setDateFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberFormat")) != null) {
            style.setNumberFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "stringFormat")) != null) {
            style.setStringFormat(value);
        }
        return style;
    }

    static int toDteFilterOperator(String modelOpr) {
        if (modelOpr.equals("eq")) {
            return 1;
        }
        if (modelOpr.equals("ne")) {
            return 2;
        }
        if (modelOpr.equals("lt")) {
            return 3;
        }
        if (modelOpr.equals("le")) {
            return 4;
        }
        if (modelOpr.equals("ge")) {
            return 5;
        }
        if (modelOpr.equals("gt")) {
            return 6;
        }
        if (modelOpr.equals("between")) {
            return 7;
        }
        if (modelOpr.equals("not-between")) {
            return 8;
        }
        if (modelOpr.equals("is-null")) {
            return 9;
        }
        if (modelOpr.equals("is-not-null")) {
            return 10;
        }
        if (modelOpr.equals("is-true")) {
            return 11;
        }
        if (modelOpr.equals("is-false")) {
            return 12;
        }
        if (modelOpr.equals("like")) {
            return 13;
        }
        if (modelOpr.equals("top-n")) {
            return 14;
        }
        if (modelOpr.equals("bottom-n")) {
            return 15;
        }
        if (modelOpr.equals("top-percent")) {
            return 16;
        }
        if (modelOpr.equals("bottom-percent")) {
            return 17;
        }
        if (modelOpr.equals("not-like")) {
            return 20;
        }
        if (modelOpr.equals("not-match")) {
            return 21;
        }
        return 0;
    }

    static String decodePageBreak(String pageBreak) {
        if (pageBreak == null) {
            return null;
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-last".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-first".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        return "auto";
    }

    static String getElementProperty(ReportElementHandle handle, String name) {
        return ContentUtil.getElementProperty(handle, name, false);
    }

    static String getElementProperty(ReportElementHandle handle, String name, boolean isColorProperty) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            if (isColorProperty) {
                return prop.getColorValue();
            }
            return prop.getStringValue();
        }
        return null;
    }

    static String getMemberProperty(StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            return prop.getStringValue();
        }
        return null;
    }

    static DimensionType createDimension(DimensionHandle handle) {
        if (handle == null || !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        return new DimensionType(measure, unit);
    }
}

