/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabGrandTotalRowExecutor
extends BaseCrosstabExecutor {
    private static final Logger logger;
    private int rowIndex;
    private long currentEdgePosition;
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private int lastMeasureIndex;
    private int lastDimensionIndex;
    private int lastLevelIndex;
    private int totalMeasureCount;
    private int totalRowSpan;
    private boolean isFirstTotalRow;
    private boolean hasLast;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabGrandTotalRowExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public CrosstabGrandTotalRowExecutor(BaseCrosstabExecutor parent, int rowIndex) {
        super(parent);
        this.rowIndex = rowIndex;
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.processRowHeight(this.findGrandTotalRowCell(this.rowIndex));
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.currentEdgePosition = -1L;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.totalMeasureCount = this.crosstabItem.getMeasureCount();
        boolean isVerticalMeasure = "vertical".equals(this.crosstabItem.getMeasureDirection());
        this.isFirstTotalRow = this.rowIndex == GroupUtil.getFirstTotalRowIndex(this.crosstabItem, -1, -1, isVerticalMeasure);
        this.totalRowSpan = GroupUtil.getTotalRowSpan(this.crosstabItem, -1, -1, isVerticalMeasure);
        this.hasLast = false;
        this.walker.reload();
    }

    private AggregationCellHandle getRowGrandTotalCell(int dimensionIndex, int levelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount) {
            if (dimensionIndex < 0 || levelIndex < 0) {
                return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(null, null, null, null);
            }
            DimensionViewHandle dv = this.crosstabItem.getDimension(1, dimensionIndex);
            LevelViewHandle lv = dv.getLevel(levelIndex);
            return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(null, null, dv.getCubeDimensionName(), lv.getCubeLevelName());
        }
        return null;
    }

    public IReportItemExecutor getNextChild() {
        CrosstabCellExecutor nextExecutor = null;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (ev.type == 1 || !this.isFirstTotalRow) break;
                        nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getGrandTotal(0), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        nextExecutor.setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        nextExecutor.setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        int mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        nextExecutor = new CrosstabCellExecutor(this, this.getRowGrandTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        nextExecutor.setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                    }
                }
                if (ev.type == 6 || ev.type == 2) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    if (this.columnGroups != null && this.columnGroups.size() > 0) {
                        EdgeGroup gp = (EdgeGroup)this.columnGroups.get(this.columnGroups.size() - 1);
                        this.lastDimensionIndex = gp.dimensionIndex;
                        this.lastLevelIndex = gp.levelIndex;
                    } else {
                        this.lastDimensionIndex = ev.dimensionIndex;
                        this.lastLevelIndex = ev.levelIndex;
                    }
                    this.hasLast = true;
                } else if (ev.type == 3 || ev.type == 4) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 1 && this.isFirstTotalRow) {
                    this.rowSpan = this.totalRowSpan;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                this.currentEdgePosition = ev.dataPosition;
                ++this.colSpan;
                ++this.currentColIndex;
                if (nextExecutor == null) continue;
                return nextExecutor;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabGrandTotalRowExecutor.error.generate.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    if (!this.isFirstTotalRow) break;
                    nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getGrandTotal(0), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    nextExecutor.setPosition(this.currentEdgePosition);
                    break;
                }
                case 5: {
                    nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    nextExecutor.setPosition(this.currentEdgePosition);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    int mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                    nextExecutor = new CrosstabCellExecutor(this, this.getRowGrandTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    nextExecutor.setPosition(this.currentEdgePosition);
                }
            }
        }
        return nextExecutor;
    }

    public boolean hasNextChild() {
        try {
            return this.walker.hasNext() || this.hasLast;
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabGrandTotalRowExecutor.error.check.child.executor"), e);
            return false;
        }
    }
}

