/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabSubTotalRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger;
    private int rowIndex;
    private int dimensionIndex;
    private int levelIndex;
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private int lastMeasureIndex;
    private int lastDimensionIndex;
    private int lastLevelIndex;
    private int totalMeasureCount;
    private long currentEdgePosition;
    private boolean isLayoutDownThenOver;
    private int startTotalDimensionIndex;
    private int startTotalLevelIndex;
    private boolean rowEdgeStarted;
    private boolean rowSubTotalStarted;
    private boolean hasLast;
    private int totalRowSpan;
    private boolean isFirstTotalRow;
    private boolean isSubTotalBefore;
    private boolean isFirst;
    private IReportItemExecutor nextExecutor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabSubTotalRowExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public CrosstabSubTotalRowExecutor(BaseCrosstabExecutor parent, int rowIndex, int dimensionIndex, int levelIndex) {
        super(parent);
        this.rowIndex = rowIndex;
        this.dimensionIndex = dimensionIndex;
        this.levelIndex = levelIndex;
    }

    public void close() {
        super.close();
        this.nextExecutor = null;
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.processRowHeight(this.findSubTotalRowCell(this.dimensionIndex, this.levelIndex, this.rowIndex));
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.currentEdgePosition = -1L;
        this.isFirst = true;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.totalMeasureCount = this.crosstabItem.getMeasureCount();
        this.isLayoutDownThenOver = "down then over".equals(this.crosstabItem.getPageLayout());
        if (this.isLayoutDownThenOver) {
            this.startTotalDimensionIndex = this.dimensionIndex;
            this.startTotalLevelIndex = this.levelIndex;
        } else {
            EdgeGroup nextGroup = GroupUtil.getNextGroup(this.rowGroups, this.dimensionIndex, this.levelIndex);
            this.startTotalDimensionIndex = nextGroup.dimensionIndex;
            this.startTotalLevelIndex = nextGroup.levelIndex;
        }
        DimensionViewHandle dv = this.crosstabItem.getDimension(0, this.dimensionIndex);
        LevelViewHandle lv = dv.getLevel(this.levelIndex);
        this.isSubTotalBefore = lv.getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation());
        boolean isVerticalMeasure = "vertical".equals(this.crosstabItem.getMeasureDirection());
        this.isFirstTotalRow = this.rowIndex == GroupUtil.getFirstTotalRowIndex(this.crosstabItem, this.dimensionIndex, this.levelIndex, isVerticalMeasure);
        this.totalRowSpan = GroupUtil.getTotalRowSpan(this.crosstabItem, this.dimensionIndex, this.levelIndex, isVerticalMeasure);
        this.hasLast = false;
        this.walker.reload();
    }

    private AggregationCellHandle getRowSubTotalCell(int colDimensionIndex, int colLevelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount) {
            DimensionViewHandle rdv = this.crosstabItem.getDimension(0, this.dimensionIndex);
            LevelViewHandle rlv = rdv.getLevel(this.levelIndex);
            if (colDimensionIndex < 0 || colLevelIndex < 0) {
                return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(rdv.getCubeDimensionName(), rlv.getCubeLevelName(), null, null);
            }
            DimensionViewHandle cdv = this.crosstabItem.getDimension(1, colDimensionIndex);
            LevelViewHandle clv = cdv.getLevel(colLevelIndex);
            return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(rdv.getCubeDimensionName(), rlv.getCubeLevelName(), cdv.getCubeDimensionName(), clv.getCubeLevelName());
        }
        return null;
    }

    private boolean isRowEdgeNeedStart(ColumnEvent ev) {
        if (this.rowEdgeStarted || ev.type != 1 || !this.isSubTotalBefore) {
            return false;
        }
        if (ev.dimensionIndex > this.dimensionIndex || ev.dimensionIndex == this.dimensionIndex && (this.isLayoutDownThenOver ? ev.levelIndex >= this.levelIndex : ev.levelIndex > this.levelIndex)) {
            return false;
        }
        if (ev.dimensionIndex != this.dimensionIndex || ev.levelIndex != this.levelIndex) {
            DimensionViewHandle dv = this.crosstabItem.getDimension(0, ev.dimensionIndex);
            LevelViewHandle lv = dv.getLevel(ev.levelIndex);
            if (!this.isLayoutDownThenOver && lv.getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation())) {
                return false;
            }
            int gdx = GroupUtil.getGroupIndex(this.rowGroups, ev.dimensionIndex, ev.levelIndex);
            if (gdx != -1) {
                try {
                    EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
                    if (rowEdgeCursor != null) {
                        DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(gdx);
                        if (rowEdgeCursor.getPosition() != dc.getEdgeStart()) {
                            return false;
                        }
                    }
                }
                catch (OLAPException e) {
                    logger.log(Level.SEVERE, Messages.getString("CrosstabSubTotalRowExecutor.error.check.edge.start"), e);
                }
            }
        }
        return this.rowIndex == 0;
    }

    private void advance() {
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (this.rowEdgeStarted) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.rowEdgeStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.rowSubTotalStarted || ev.type == 1) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.dimensionIndex).getLevel(this.levelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.rowSubTotalStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        int mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                    }
                }
                if (this.isRowEdgeNeedStart(ev)) {
                    this.rowEdgeStarted = true;
                    this.rowSpan = GroupUtil.computeRowSpan(this.crosstabItem, this.rowGroups, ev.dimensionIndex, ev.levelIndex, this.getRowEdgeCursor(), this.isLayoutDownThenOver);
                    this.colSpan = 0;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (!this.rowSubTotalStarted && ev.type == 1 && ev.dimensionIndex == this.startTotalDimensionIndex && ev.levelIndex == this.startTotalLevelIndex && this.isFirstTotalRow) {
                    this.rowSubTotalStarted = true;
                    this.rowSpan = this.totalRowSpan;
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (ev.type == 6 || ev.type == 2) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    if (this.columnGroups != null && this.columnGroups.size() > 0) {
                        EdgeGroup gp = (EdgeGroup)this.columnGroups.get(this.columnGroups.size() - 1);
                        this.lastDimensionIndex = gp.dimensionIndex;
                        this.lastLevelIndex = gp.levelIndex;
                    } else {
                        this.lastDimensionIndex = ev.dimensionIndex;
                        this.lastLevelIndex = ev.levelIndex;
                    }
                    this.hasLast = true;
                } else if (ev.type == 3 || ev.type == 4) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                this.currentEdgePosition = ev.dataPosition;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabSubTotalRowExecutor.error.retrieve.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    if (this.rowEdgeStarted) {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.rowEdgeStarted = false;
                        break;
                    }
                    if (!this.rowSubTotalStarted) break;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.dimensionIndex).getLevel(this.levelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 5: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    int mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                }
            }
        }
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.nextExecutor;
        this.nextExecutor = null;
        this.advance();
        return childExecutor;
    }

    public boolean hasNextChild() {
        if (this.isFirst) {
            this.isFirst = false;
            this.advance();
        }
        return this.nextExecutor != null;
    }
}

