/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Rotation3D;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.impl.ChartImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChartWithAxesImpl
extends ChartImpl
implements ChartWithAxes {
    protected EList axes = null;
    protected Fill wallFill = null;
    protected Fill floorFill = null;
    protected static final Orientation ORIENTATION_EDEFAULT = Orientation.VERTICAL_LITERAL;
    protected Orientation orientation = ORIENTATION_EDEFAULT;
    protected boolean orientationESet = false;
    protected static final double UNIT_SPACING_EDEFAULT = 0.0;
    protected double unitSpacing = 0.0;
    protected boolean unitSpacingESet = false;
    protected Rotation3D rotation = null;
    static /* synthetic */ Class class$0;

    protected ChartWithAxesImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.CHART_WITH_AXES;
    }

    public EList getAxes() {
        if (this.axes == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.chart.model.component.Axis");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.axes = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 14);
        }
        return this.axes;
    }

    public Fill getWallFill() {
        return this.wallFill;
    }

    public NotificationChain basicSetWallFill(Fill newWallFill, NotificationChain msgs) {
        Fill oldWallFill = this.wallFill;
        this.wallFill = newWallFill;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldWallFill, (Object)newWallFill);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setWallFill(Fill newWallFill) {
        if (newWallFill != this.wallFill) {
            NotificationChain msgs = null;
            if (this.wallFill != null) {
                msgs = ((InternalEObject)this.wallFill).eInverseRemove((InternalEObject)this, -16, null, msgs);
            }
            if (newWallFill != null) {
                msgs = ((InternalEObject)newWallFill).eInverseAdd((InternalEObject)this, -16, null, msgs);
            }
            if ((msgs = this.basicSetWallFill(newWallFill, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newWallFill, (Object)newWallFill));
        }
    }

    public Fill getFloorFill() {
        return this.floorFill;
    }

    public NotificationChain basicSetFloorFill(Fill newFloorFill, NotificationChain msgs) {
        Fill oldFloorFill = this.floorFill;
        this.floorFill = newFloorFill;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldFloorFill, (Object)newFloorFill);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setFloorFill(Fill newFloorFill) {
        if (newFloorFill != this.floorFill) {
            NotificationChain msgs = null;
            if (this.floorFill != null) {
                msgs = ((InternalEObject)this.floorFill).eInverseRemove((InternalEObject)this, -17, null, msgs);
            }
            if (newFloorFill != null) {
                msgs = ((InternalEObject)newFloorFill).eInverseAdd((InternalEObject)this, -17, null, msgs);
            }
            if ((msgs = this.basicSetFloorFill(newFloorFill, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newFloorFill, (Object)newFloorFill));
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation newOrientation) {
        Orientation oldOrientation = this.orientation;
        this.orientation = newOrientation == null ? ORIENTATION_EDEFAULT : newOrientation;
        boolean oldOrientationESet = this.orientationESet;
        this.orientationESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldOrientation, (Object)this.orientation, !oldOrientationESet));
        }
    }

    public void unsetOrientation() {
        Orientation oldOrientation = this.orientation;
        boolean oldOrientationESet = this.orientationESet;
        this.orientation = ORIENTATION_EDEFAULT;
        this.orientationESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 17, (Object)oldOrientation, (Object)ORIENTATION_EDEFAULT, oldOrientationESet));
        }
    }

    public boolean isSetOrientation() {
        return this.orientationESet;
    }

    public double getUnitSpacing() {
        return this.unitSpacing;
    }

    public void setUnitSpacing(double newUnitSpacing) {
        double oldUnitSpacing = this.unitSpacing;
        this.unitSpacing = newUnitSpacing;
        boolean oldUnitSpacingESet = this.unitSpacingESet;
        this.unitSpacingESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldUnitSpacing, this.unitSpacing, !oldUnitSpacingESet));
        }
    }

    public void unsetUnitSpacing() {
        double oldUnitSpacing = this.unitSpacing;
        boolean oldUnitSpacingESet = this.unitSpacingESet;
        this.unitSpacing = 0.0;
        this.unitSpacingESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 18, oldUnitSpacing, 0.0, oldUnitSpacingESet));
        }
    }

    public boolean isSetUnitSpacing() {
        return this.unitSpacingESet;
    }

    public Rotation3D getRotation() {
        return this.rotation;
    }

    public NotificationChain basicSetRotation(Rotation3D newRotation, NotificationChain msgs) {
        Rotation3D oldRotation = this.rotation;
        this.rotation = newRotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldRotation, (Object)newRotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setRotation(Rotation3D newRotation) {
        if (newRotation != this.rotation) {
            NotificationChain msgs = null;
            if (this.rotation != null) {
                msgs = ((InternalEObject)this.rotation).eInverseRemove((InternalEObject)this, -20, null, msgs);
            }
            if (newRotation != null) {
                msgs = ((InternalEObject)newRotation).eInverseAdd((InternalEObject)this, -20, null, msgs);
            }
            if ((msgs = this.basicSetRotation(newRotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)newRotation, (Object)newRotation));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getAxes()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return this.basicSetWallFill(null, msgs);
            }
            case 16: {
                return this.basicSetFloorFill(null, msgs);
            }
            case 19: {
                return this.basicSetRotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getAxes();
            }
            case 15: {
                return this.getWallFill();
            }
            case 16: {
                return this.getFloorFill();
            }
            case 17: {
                return this.getOrientation();
            }
            case 18: {
                return new Double(this.getUnitSpacing());
            }
            case 19: {
                return this.getRotation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.getAxes().clear();
                this.getAxes().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setWallFill((Fill)newValue);
                return;
            }
            case 16: {
                this.setFloorFill((Fill)newValue);
                return;
            }
            case 17: {
                this.setOrientation((Orientation)((Object)newValue));
                return;
            }
            case 18: {
                this.setUnitSpacing((Double)newValue);
                return;
            }
            case 19: {
                this.setRotation((Rotation3D)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.getAxes().clear();
                return;
            }
            case 15: {
                this.setWallFill(null);
                return;
            }
            case 16: {
                this.setFloorFill(null);
                return;
            }
            case 17: {
                this.unsetOrientation();
                return;
            }
            case 18: {
                this.unsetUnitSpacing();
                return;
            }
            case 19: {
                this.setRotation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 14: {
                return this.axes != null && !this.axes.isEmpty();
            }
            case 15: {
                return this.wallFill != null;
            }
            case 16: {
                return this.floorFill != null;
            }
            case 17: {
                return this.isSetOrientation();
            }
            case 18: {
                return this.isSetUnitSpacing();
            }
            case 19: {
                return this.rotation != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (orientation: ");
        if (this.orientationESet) {
            result.append((Object)this.orientation);
        } else {
            result.append("<unset>");
        }
        result.append(", unitSpacing: ");
        if (this.unitSpacingESet) {
            result.append(this.unitSpacing);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public final Axis[] getBaseAxes() {
        EList elAxes = this.getAxes();
        int iAxisCount = elAxes.size();
        Axis[] axa = new Axis[iAxisCount];
        int i = 0;
        while (i < iAxisCount) {
            axa[i] = (Axis)elAxes.get(i);
            ++i;
        }
        return axa;
    }

    public final Axis[] getPrimaryBaseAxes() {
        EList elAxes = this.getAxes();
        int iAxisCount = elAxes.size();
        Axis[] axa = new Axis[iAxisCount];
        int i = 0;
        while (i < iAxisCount) {
            axa[i] = (Axis)elAxes.get(i);
            ++i;
        }
        return axa;
    }

    public final Axis[] getOrthogonalAxes(Axis axBase, boolean bIncludePrimary) {
        EList elAxes = axBase.getAssociatedAxes();
        int iAxisCount = elAxes.size();
        int iDecrease = bIncludePrimary ? 0 : 1;
        Axis[] axa = new Axis[iAxisCount - iDecrease];
        int i = 0;
        int j = 1 - iDecrease;
        while (i < iAxisCount) {
            Axis ax = (Axis)elAxes.get(i);
            if (!ax.isPrimaryAxis()) {
                axa[j++] = ax;
            } else if (bIncludePrimary) {
                axa[0] = ax;
            }
            ++i;
        }
        return axa;
    }

    public final Axis getPrimaryOrthogonalAxis(Axis axBase) {
        EList elAxes = axBase.getAssociatedAxes();
        int iAxisCount = elAxes.size();
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = (Axis)elAxes.get(i);
            if (ax.isPrimaryAxis()) {
                return ax;
            }
            ++i;
        }
        return null;
    }

    public Axis getAncillaryBaseAxis(Axis axBase) {
        EList elAxes = axBase.getAncillaryAxes();
        int iAxisCount = elAxes.size();
        if (iAxisCount > 0) {
            return (Axis)elAxes.get(0);
        }
        return null;
    }

    public static final ChartWithAxes create() {
        ChartWithAxes cwa = ModelFactory.eINSTANCE.createChartWithAxes();
        ((ChartWithAxesImpl)cwa).initialize();
        return cwa;
    }

    protected final void initialize() {
        super.initialize();
        Axis xAxisBase = AxisImpl.create(1);
        xAxisBase.setTitlePosition(Position.BELOW_LITERAL);
        xAxisBase.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.X_Axis.title"));
        xAxisBase.getTitle().setVisible(false);
        xAxisBase.setPrimaryAxis(true);
        xAxisBase.setLabelPosition(Position.BELOW_LITERAL);
        xAxisBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        xAxisBase.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxisBase.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        xAxisBase.setType(AxisType.TEXT_LITERAL);
        Axis yAxisOrthogonal = AxisImpl.create(2);
        yAxisOrthogonal.setTitlePosition(Position.LEFT_LITERAL);
        yAxisOrthogonal.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Y_Axis.title"));
        yAxisOrthogonal.getTitle().getCaption().getFont().setRotation(90.0);
        yAxisOrthogonal.getTitle().setVisible(false);
        yAxisOrthogonal.setPrimaryAxis(true);
        yAxisOrthogonal.setLabelPosition(Position.LEFT_LITERAL);
        yAxisOrthogonal.setOrientation(Orientation.VERTICAL_LITERAL);
        yAxisOrthogonal.getOrigin().setType(IntersectionType.MIN_LITERAL);
        yAxisOrthogonal.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        yAxisOrthogonal.setType(AxisType.LINEAR_LITERAL);
        xAxisBase.getAssociatedAxes().add((Object)yAxisOrthogonal);
        this.getAxes().add((Object)xAxisBase);
        this.setRotation(Rotation3DImpl.create());
    }

    public final Series[] getSeries(int iBaseOrOrthogonal) {
        ArrayList al = new ArrayList(8);
        Axis[] axaBase = this.getBaseAxes();
        int i = 0;
        while (i < axaBase.length) {
            SeriesDefinition sd;
            int j;
            EList el;
            if ((iBaseOrOrthogonal | 1) == 1) {
                el = axaBase[i].getSeriesDefinitions();
                j = 0;
                while (j < el.size()) {
                    sd = (SeriesDefinition)el.get(j);
                    al.addAll(sd.getRunTimeSeries());
                    ++j;
                }
            }
            Axis[] axaOrthogonal = this.getOrthogonalAxes(axaBase[i], true);
            j = 0;
            while (j < axaOrthogonal.length) {
                if ((iBaseOrOrthogonal | 2) == 2) {
                    el = axaOrthogonal[j].getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        al.addAll(sd.getRunTimeSeries());
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return al.toArray(new Series[al.size()]);
    }

    public final boolean isTransposed() {
        return this.getOrientation().getValue() == 0;
    }

    public void setTransposed(boolean bTransposed) {
        this.setOrientation(bTransposed ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL);
    }

    public final SeriesDefinition[] getSeriesForLegend() {
        ArrayList al = new ArrayList(8);
        Axis[] axaBase = this.getBaseAxes();
        int i = 0;
        while (i < axaBase.length) {
            Axis[] axaOrthogonal = this.getOrthogonalAxes(axaBase[i], true);
            int j = 0;
            while (j < axaOrthogonal.length) {
                EList el = axaOrthogonal[j].getSeriesDefinitions();
                al.addAll(el);
                ++j;
            }
            ++i;
        }
        return al.toArray(new SeriesDefinition[al.size()]);
    }

    public final void clearSections(int iSectionType) {
        if ((iSectionType & 3) == 3) {
            Axis[] axaBase = this.getBaseAxes();
            int i = 0;
            while (i < axaBase.length) {
                SeriesDefinition sd;
                EList el = axaBase[i].getSeriesDefinitions();
                int j = 0;
                while (j < el.size()) {
                    sd = (SeriesDefinition)el.get(j);
                    if (sd.getSeries().size() == sd.getRunTimeSeries().size()) {
                        Iterator it = sd.getRunTimeSeries().iterator();
                        while (it.hasNext()) {
                            Series se = (Series)it.next();
                            se.getDataSets().clear();
                        }
                    } else {
                        sd.getSeries().removeAll((Collection)sd.getRunTimeSeries());
                    }
                    ++j;
                }
                Axis[] axaOrthogonal = this.getOrthogonalAxes(axaBase[i], true);
                j = 0;
                while (j < axaOrthogonal.length) {
                    el = axaOrthogonal[j].getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        if (sd.getSeries().size() == sd.getRunTimeSeries().size()) {
                            Iterator it = sd.getRunTimeSeries().iterator();
                            while (it.hasNext()) {
                                Series se = (Series)it.next();
                                se.getDataSets().clear();
                            }
                        } else {
                            sd.getSeries().removeAll((Collection)sd.getRunTimeSeries());
                        }
                        ++k;
                    }
                    ++j;
                }
                Axis axaAncillary = this.getAncillaryBaseAxis(axaBase[i]);
                if (axaAncillary != null) {
                    el = axaAncillary.getSeriesDefinitions();
                    int k = 0;
                    while (k < el.size()) {
                        sd = (SeriesDefinition)el.get(k);
                        if (sd.getSeries().size() != sd.getRunTimeSeries().size()) {
                            sd.getSeries().removeAll((Collection)sd.getRunTimeSeries());
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }
}

