/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModelException;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class DesignFileException
extends ModelException {
    private static final long serialVersionUID = 8790341685615483274L;
    private List exceptionList = new ArrayList();
    protected String fileName = null;
    protected Exception e = null;
    public static final String DESIGN_EXCEPTION_SYNTAX_ERROR = "Error.DesignFileException.SYNTAX_ERROR";
    public static final String DESIGN_EXCEPTION_SEMANTIC_ERROR = "Error.DesignFileException.SEMANTIC_ERROR";
    public static final String DESIGN_EXCEPTION_SEMANTIC_WARNING = "Error.DesignFileException.SEMANTIC_WARNING";
    public static final String DESIGN_EXCEPTION_INVALID_XML = "Error.DesignFileException.INVALID_XML";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.DesignFileException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DesignFileException(String fileName, Exception e) {
        super(DESIGN_EXCEPTION_INVALID_XML, null, e);
        this.fileName = fileName;
        this.e = e;
        this.exceptionList.add(e);
    }

    public DesignFileException(String fileName, List errList) {
        super(DESIGN_EXCEPTION_SYNTAX_ERROR);
        this.fileName = fileName;
        this.exceptionList.addAll(errList);
    }

    public DesignFileException(String fileName, List errList, Exception ex) {
        super(DESIGN_EXCEPTION_INVALID_XML, null, ex);
        this.fileName = fileName;
        this.exceptionList.addAll(errList);
        this.exceptionList.add(ex);
    }

    public List getErrorList() {
        ArrayList<ErrorDetail> errorList = new ArrayList<ErrorDetail>();
        Iterator iter = this.exceptionList.iterator();
        while (iter.hasNext()) {
            Exception e = (Exception)iter.next();
            errorList.add(new ErrorDetail(e));
        }
        return errorList;
    }

    public List getExceptionList() {
        return this.exceptionList;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLocalizedMessage() {
        if (this.sResourceKey == null) {
            return "";
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }

    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sResourceKey);
        sb.append(" - ");
        if (this.sResourceKey == DESIGN_EXCEPTION_SYNTAX_ERROR || this.sResourceKey == DESIGN_EXCEPTION_INVALID_XML) {
            List errorList = this.getErrorList();
            if (errorList != null) {
                sb.append(errorList.size());
                sb.append(" errors found! \n");
                int i = 1;
                Iterator iter = errorList.iterator();
                while (iter.hasNext()) {
                    ErrorDetail e = (ErrorDetail)iter.next();
                    sb.append(i++);
                    sb.append(".) ");
                    sb.append(e);
                    sb.append("\n");
                }
            }
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return super.toString();
        }
        return sb.toString();
    }
}

