/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.impl.SimpleElementFactory;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.metadata.MetaDataReaderException;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.metadata.ExtensionManager;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.simpleapi.ReportDesign;

public class DesignEngineImpl
implements IDesignEngine {
    protected static Logger errorLogger;
    private static final String ROM_DEF_FILE_NAME = "rom.def";
    private static Boolean isInitialized;
    private DesignConfig designConfig;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.impl.DesignEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        errorLogger = Logger.getLogger(clazz.getName());
        isInitialized = Boolean.FALSE;
    }

    public DesignEngineImpl(DesignConfig config) {
        this.designConfig = config;
    }

    private static void initialize(InputStream is) throws MetaDataReaderException {
        try {
            MetaDataReader.read(is);
            ExtensionManager.initialize();
            org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory.setInstance(new SimpleElementFactory());
        }
        catch (MetaDataParserException e) {
            throw new MetaDataReaderException("Error.MetaDataReaderException.META_DATA_ERROR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionHandle newSessionHandle(ULocale locale) {
        IResourceLocator locator;
        if (isInitialized.booleanValue()) {
            return new SessionHandle(locale);
        }
        Boolean bl = isInitialized;
        synchronized (bl) {
            if (isInitialized.booleanValue()) {
                return new SessionHandle(locale);
            }
            MetaDataDictionary.reset();
            try {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.birt.report.model.elements.ReportDesign");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz2;
                    }
                    DesignEngineImpl.initialize(clazz.getResourceAsStream(ROM_DEF_FILE_NAME));
                }
                catch (MetaDataReaderException metaDataReaderException) {}
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                MetaLogManager.shutDown();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            MetaLogManager.shutDown();
            isInitialized = Boolean.TRUE;
        }
        SessionHandle session = new SessionHandle(locale);
        if (this.designConfig != null && (locator = this.designConfig.getResourceLocator()) != null) {
            session.setResourceLocator(locator);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetaDataDictionary getMetaData() {
        if (isInitialized.booleanValue()) {
            return MetaDataDictionary.getInstance();
        }
        Boolean bl = isInitialized;
        synchronized (bl) {
            if (isInitialized.booleanValue()) {
                return MetaDataDictionary.getInstance();
            }
            MetaDataDictionary.reset();
            try {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.birt.report.model.elements.ReportDesign");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz2;
                    }
                    DesignEngineImpl.initialize(clazz.getResourceAsStream(ROM_DEF_FILE_NAME));
                }
                catch (MetaDataReaderException metaDataReaderException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                MetaLogManager.shutDown();
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            MetaLogManager.shutDown();
            isInitialized = Boolean.TRUE;
            return MetaDataDictionary.getInstance();
        }
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        MetaLogManager.registerLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return MetaLogManager.removeLogger(logger);
    }

    public IReportDesign openDesign(String fileName, InputStream ins, IModuleOption options) throws DesignFileException {
        SessionHandle tmpSession = this.newSessionHandle(null);
        return new ReportDesign(tmpSession.openDesign(fileName, ins, (ModuleOption)options));
    }
}

