/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class StyleReferenceValidator
extends AbstractElementValidator {
    public static final String NAME = "StyleReferenceValidator";
    private static final StyleReferenceValidator instance = new StyleReferenceValidator();

    public static StyleReferenceValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof StyledElement)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (StyledElement)element);
    }

    private List doValidate(Module module, StyledElement toValidate) {
        ArrayList<StyleException> list = new ArrayList<StyleException>();
        String styleName = toValidate.getStyleName();
        StyleElement style = toValidate.getStyle();
        if (styleName != null && style == null) {
            DesignElement resolvedElement = module.resolveElement(styleName, (PropertyDefn)toValidate.getPropertyDefn("style"), null);
            if (resolvedElement == null) {
                list.add(new StyleException((DesignElement)toValidate, styleName, "Error.StyleException.NOT_FOUND"));
            } else {
                toValidate.setStyle((StyleElement)resolvedElement);
            }
        }
        return list;
    }
}

