/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ThemeEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ThemeRecord
extends SimpleRecord {
    private ElementRefValue newTheme;
    private ElementRefValue oldTheme;
    protected Module module;

    ThemeRecord(Module module, ElementRefValue newTheme) {
        this.module = module;
        this.newTheme = newTheme;
        this.oldTheme = (ElementRefValue)module.getLocalProperty(module, "theme");
        this.label = ModelMessages.getMessage("Message.SetTheme");
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.module.setProperty("theme", (Object)this.oldTheme);
            this.updateStyles(this.newTheme);
        } else {
            this.module.setProperty("theme", (Object)this.newTheme);
            this.updateStyles(this.oldTheme);
        }
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public NotificationEvent getEvent() {
        return new ThemeEvent(this.module);
    }

    private void updateStyles(ElementRefValue theme) {
        if (theme == null) {
            return;
        }
        if (!theme.isResolved()) {
            return;
        }
        Theme t = (Theme)theme.getElement();
        List styles = t.getAllStyles();
        Iterator iter = styles.iterator();
        while (iter.hasNext()) {
            Style style = (Style)iter.next();
            style.updateClientReferences();
        }
    }
}

