/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ViewerAttributeBean
extends BaseAttributeBean {
    private int maxRows;
    private Map parametersAsString = null;
    private Collection parameterDefList = null;
    private Map displayTexts = null;
    private Map moduleOptions = null;
    private String requestType;
    private Map defaultValues;
    private List locParams;

    public ViewerAttributeBean(HttpServletRequest httpServletRequest) {
        try {
            this.init(httpServletRequest);
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    protected void __init(HttpServletRequest httpServletRequest) throws Exception {
        if (ParameterAccessor.isGetImageOperator(httpServletRequest) && ("/frameset".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/output".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/run".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/preview".equalsIgnoreCase(httpServletRequest.getServletPath()))) {
            return;
        }
        this.category = "BIRT";
        this.masterPageContent = ParameterAccessor.isMasterPageContent(httpServletRequest);
        this.isDesigner = ParameterAccessor.isDesigner(httpServletRequest);
        this.bookmark = ParameterAccessor.getBookmark(httpServletRequest);
        this.isToc = ParameterAccessor.isToc(httpServletRequest);
        this.reportPage = ParameterAccessor.getPage(httpServletRequest);
        this.reportPageRange = ParameterAccessor.getPageRange(httpServletRequest);
        this.action = ParameterAccessor.getAction(httpServletRequest);
        this.reportDocumentName = "/frameset".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/output".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/download".equalsIgnoreCase(httpServletRequest.getServletPath()) ? ParameterAccessor.getReportDocument(httpServletRequest, null, true) : ParameterAccessor.getReportDocument(httpServletRequest, null, false);
        this.reportDesignName = ParameterAccessor.getReport(httpServletRequest, null);
        this.format = ParameterAccessor.getFormat(httpServletRequest);
        if ("print".equalsIgnoreCase(this.action)) {
            if (ParameterAccessor.isSupportedPrintOnServer) {
                this.format = "postscript";
            } else {
                this.action = null;
            }
        }
        this.maxRows = ParameterAccessor.getMaxRows(httpServletRequest);
        BirtResources.setLocale(ParameterAccessor.getLocale(httpServletRequest));
        ReportEngineService.getInstance().setMaxRows(this.maxRows);
        this.requestType = httpServletRequest.getHeader("request-type");
        this.processReport(httpServletRequest);
        this.reportTitle = ParameterAccessor.getTitle(httpServletRequest);
        this.isShowTitle = ParameterAccessor.isShowTitle(httpServletRequest);
        this.isShowToolbar = ParameterAccessor.isShowToolbar(httpServletRequest);
        this.isShowNavigationbar = ParameterAccessor.isShowNavigationbar(httpServletRequest);
        this.moduleOptions = BirtUtility.getModuleOptions(httpServletRequest);
        this.reportDesignHandle = this.getDesignHandle(httpServletRequest);
        if (this.reportDesignHandle == null) {
            throw new ViewerException("birt.viewer.generalException.NO_REPORT_DESIGN");
        }
        ParameterAccessor.setClean(httpServletRequest);
        this.__initParameters(httpServletRequest);
    }

    protected void __initParameters(HttpServletRequest httpServletRequest) throws Exception {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        inputOptions.setOption("locale", this.locale);
        inputOptions.setOption("rtl", new Boolean(this.rtl));
        this.parameterDefList = this.getReportService().getParameterDefinitions(this.reportDesignHandle, inputOptions, false);
        if (this.isDesigner && ("/run".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/parameter".equalsIgnoreCase(httpServletRequest.getServletPath())) && !"soap".equalsIgnoreCase(this.requestType)) {
            this.parseConfigVars(httpServletRequest, this.parameterDefList);
        }
        this.parametersAsString = this.getParsedParametersAsString(this.parameterDefList, httpServletRequest, inputOptions);
        this.missingParameter = this.documentInUrl ? false : BirtUtility.validateParameters(this.parameterDefList, this.parametersAsString);
        this.isShowParameterPage = this.checkShowParameterPage(httpServletRequest);
        this.defaultValues = this.getDefaultValues(this.reportDesignHandle, this.parameterDefList, httpServletRequest, inputOptions);
        this.displayTexts = BirtUtility.getDisplayTexts(this.parameterDefList, this.displayTexts, httpServletRequest);
        this.locParams = BirtUtility.getLocParams(this.locParams, httpServletRequest);
        this.parameters = (HashMap)this.getParsedParameters(this.reportDesignHandle, this.parameterDefList, httpServletRequest, inputOptions);
        this.parametersAsString = this.getParsedParametersAsStringWithDefaultValue(this.parametersAsString, this.parameterDefList, httpServletRequest, inputOptions);
    }

    private boolean checkShowParameterPage(HttpServletRequest httpServletRequest) {
        if (!"soap".equalsIgnoreCase(this.requestType) && !"/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            String string = ParameterAccessor.getShowParameterPage(httpServletRequest);
            if ("false".equalsIgnoreCase(string)) {
                return false;
            }
            if ("true".equalsIgnoreCase(string)) {
                return true;
            }
        }
        return this.missingParameter;
    }

    protected void parseConfigVars(HttpServletRequest httpServletRequest, Collection collection) {
        String string;
        this.configMap = new HashMap();
        if (this.displayTexts == null) {
            this.displayTexts = new HashMap();
        }
        if ((string = ParameterAccessor.getConfigFileName(this.reportDesignName)) == null) {
            return;
        }
        SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
        ReportDesignHandle reportDesignHandle = null;
        try {
            reportDesignHandle = sessionHandle.openDesign(string);
            if (reportDesignHandle != null) {
                String string2 = null;
                Iterator iterator = reportDesignHandle.configVariablesIterator();
                while (iterator != null && iterator.hasNext()) {
                    String string3;
                    ParameterDefinition parameterDefinition;
                    ConfigVariableHandle configVariableHandle = (ConfigVariableHandle)iterator.next();
                    if (configVariableHandle == null) continue;
                    String string4 = this.prepareConfigVarName(configVariableHandle.getName());
                    String string5 = configVariableHandle.getValue();
                    if (string4 == null || string5 == null) continue;
                    String string6 = string4;
                    String string7 = null;
                    if (string4.toLowerCase().startsWith("__isnull")) {
                        string6 = string5;
                    } else {
                        string2 = ParameterAccessor.isDisplayText(string4);
                        if (string2 != null) {
                            string6 = string2;
                        }
                    }
                    if ((parameterDefinition = BirtUtility.findParameterDefinition(collection, string7 = this.getParameterName(string6, collection))) == null) continue;
                    String string8 = string6 + "_" + "type" + "_";
                    ConfigVariable configVariable = reportDesignHandle.findConfigVariable(string8);
                    String string9 = ParameterDataTypeConverter.ConvertDataType(parameterDefinition.getDataType());
                    String string10 = null;
                    if (configVariable != null) {
                        string10 = configVariable.getValue();
                    }
                    if (string10 == null || !string10.equalsIgnoreCase(string9)) continue;
                    String string11 = string6 + "_" + "expr" + "_";
                    ConfigVariable configVariable2 = reportDesignHandle.findConfigVariable(string11);
                    String string12 = null;
                    if (configVariable2 != null) {
                        string12 = configVariable2.getValue();
                    }
                    if (string12 == null) {
                        string12 = "";
                    }
                    if ((string3 = parameterDefinition.getValueExpr()) == null) {
                        string3 = "";
                    }
                    if (!string12.equals(string3)) continue;
                    ArrayList<Object> arrayList = null;
                    if (parameterDefinition.isMultiValue() && (arrayList = (ArrayList<Object>)this.configMap.get(string7)) == null) {
                        arrayList = new ArrayList<Object>();
                        this.configMap.put(string7, arrayList);
                    }
                    if (string4.toLowerCase().startsWith("__isnull")) {
                        if (parameterDefinition.isMultiValue()) {
                            arrayList.add(null);
                            continue;
                        }
                        this.configMap.put(string7, null);
                        continue;
                    }
                    string2 = ParameterAccessor.isDisplayText(string4);
                    if (string2 != null) {
                        this.displayTexts.put(string7, string5);
                        continue;
                    }
                    if (parameterDefinition.isMultiValue()) {
                        arrayList.add(string5);
                        continue;
                    }
                    this.configMap.put(string7, string5);
                }
                reportDesignHandle.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String prepareConfigVarName(String string) {
        int n = string.lastIndexOf("_");
        return string.substring(0, n);
    }

    private String getParameterName(String string, Collection collection) throws ReportServiceException {
        String string2 = null;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
                String string3 = null;
                if (parameterDefinition != null && parameterDefinition.getName() != null) {
                    string3 = parameterDefinition.getName() + "_" + parameterDefinition.getId();
                }
                if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
                string2 = parameterDefinition.getName();
                break;
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IViewerReportDesignHandle getDesignHandle(HttpServletRequest httpServletRequest) throws Exception {
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = null;
        IReportRunnable iReportRunnable = null;
        IReportDocument iReportDocument = null;
        boolean bl = ParameterAccessor.isReportParameterExist(httpServletRequest, "__document");
        boolean bl2 = ParameterAccessor.isReportParameterExist(httpServletRequest, "__report");
        if (bl && !bl2) {
            boolean bl3 = ParameterAccessor.isValidFilePath(ParameterAccessor.getParameter(httpServletRequest, "__document"));
            if (!bl3) throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
            iReportDocument = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.moduleOptions);
            if (iReportDocument == null) throw new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{this.reportDocumentName});
            iReportRunnable = iReportDocument.getReportRunnable();
        } else if (bl2) {
            if (bl && !ParameterAccessor.isValidFilePath(ParameterAccessor.getParameter(httpServletRequest, "__document"))) {
                throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
            }
            iReportDocument = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.moduleOptions);
            if (iReportDocument != null) {
                iReportRunnable = iReportDocument.getReportRunnable();
            }
            if (iReportRunnable == null) {
                if (!ParameterAccessor.isValidFilePath(ParameterAccessor.getParameter(httpServletRequest, "__report"))) {
                    throw new ViewerException("birt.viewer.generalException.REPORT_ACCESS_ERROR", new String[]{this.reportDesignName});
                }
                try {
                    iReportRunnable = BirtUtility.getRunnableFromDesignFile(httpServletRequest, this.reportDesignName, this.moduleOptions);
                    if (iReportRunnable == null) {
                        throw new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{this.reportDesignName});
                    }
                }
                catch (EngineException engineException) {
                    this.exception = engineException;
                }
            }
        }
        if (iReportDocument != null) {
            this.documentInUrl = true;
            this.parameterMap = iReportDocument.getParameterValues();
            if (!iReportDocument.isComplete() && bl2) {
                this.isDocumentProcessing = true;
            }
            iReportDocument.close();
        }
        if (iReportRunnable == null) return birtViewerReportDesignHandle;
        return new BirtViewerReportDesignHandle("rptRunnableObject", iReportRunnable);
    }

    protected void processReport(HttpServletRequest httpServletRequest) throws Exception {
        if ("soap".equalsIgnoreCase(this.requestType) || "/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            return;
        }
        if (this.reportDocumentName == null) {
            return;
        }
        File file = new File(this.reportDocumentName);
        long l = this.getLastModifiedOfDesign(httpServletRequest);
        if (l != -1L && file != null && file.exists() && file.isFile() && (l > file.lastModified() || ParameterAccessor.isOverwrite(httpServletRequest))) {
            file.delete();
        }
    }

    protected long getLastModifiedOfDesign(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, "__report");
        if (string == null) {
            return -1L;
        }
        File file = new File(this.reportDesignName);
        if (file != null && file.exists()) {
            if (file.isFile()) {
                return file.lastModified();
            }
        } else {
            try {
                URL uRL;
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                if ((uRL = httpServletRequest.getSession().getServletContext().getResource(string)) != null) {
                    return uRL.openConnection().getLastModified();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    protected void __finalize() throws Throwable {
    }

    protected Map getParsedParameters(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (collection == null || this.parametersAsString == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null) continue;
            String string2 = parameterDefinition.getName();
            Object v = this.parametersAsString.get(string2);
            if (v != null) {
                string = ParameterAccessor.getFormat(httpServletRequest, string2);
                if (string == null || string.length() <= 0) {
                    string = parameterDefinition.getPattern();
                }
                String string3 = ParameterDataTypeConverter.ConvertDataType(parameterDefinition.getDataType());
                boolean bl = this.locParams.contains(string2);
                ArrayList<Object> arrayList = null;
                if (v instanceof List) {
                    arrayList = (ArrayList<Object>)v;
                } else {
                    arrayList = new ArrayList<Object>();
                    arrayList.add(v);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        Object object = DataUtil.validate(string3, string, (String)arrayList.get(i), this.locale, bl);
                        arrayList.set(i, object);
                        continue;
                    }
                    catch (ValidationValueException validationValueException) {
                        if (!"/preview".equalsIgnoreCase(httpServletRequest.getServletPath())) continue;
                        this.exception = validationValueException;
                        break;
                    }
                }
                if (v instanceof List) {
                    List list = (List)v;
                    if (list.size() == 0 || list.size() == 1 && list.get(0) == null) {
                        hashMap.put(string2, null);
                        continue;
                    }
                    hashMap.put(string2, arrayList.toArray());
                    continue;
                }
                hashMap.put(string2, arrayList.get(0));
                continue;
            }
            string = null;
            if (!this.parametersAsString.containsKey(string2)) {
                string = this.defaultValues.get(string2);
            }
            if (parameterDefinition.isMultiValue()) {
                if (string == null) {
                    hashMap.put(string2, null);
                    continue;
                }
                hashMap.put(string2, new Object[]{string});
                continue;
            }
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    protected Map getDefaultValues(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null) continue;
            Object object = this.getReportService().getParameterDefaultValue(iViewerReportDesignHandle, string, inputOptions);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    protected Map getParsedParametersAsString(Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (collection == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List<Object> list;
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null) continue;
            String string2 = null;
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, string)) {
                if (parameterDefinition.isMultiValue()) {
                    list = ParameterAccessor.getReportParameters(httpServletRequest, string);
                    hashMap.put(string, list);
                    continue;
                }
                string2 = ParameterAccessor.getReportParameter(httpServletRequest, string, null);
                hashMap.put(string, string2);
                continue;
            }
            list = null;
            if (this.isDesigner && ("/run".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/parameter".equalsIgnoreCase(httpServletRequest.getServletPath())) && this.configMap != null && this.configMap.containsKey(string)) {
                list = this.configMap.get(string);
            } else {
                if (this.parameterMap == null || !this.parameterMap.containsKey(string)) continue;
                list = this.parameterMap.get(string);
            }
            if (list instanceof List) {
                List<Object> list2 = list;
                for (int i = 0; i < list2.size(); ++i) {
                    string2 = DataUtil.getDisplayValue(list2.get(i));
                    list2.set(i, string2);
                }
                hashMap.put(string, list2);
                continue;
            }
            string2 = DataUtil.getDisplayValue(list);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected Map getParsedParametersAsStringWithDefaultValue(Map hashMap, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null || hashMap.containsKey(string)) continue;
            String string2 = DataUtil.getDisplayValue(this.defaultValues.get(string));
            if (parameterDefinition.isMultiValue()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                hashMap.put(string, arrayList);
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public ParameterHandle findParameter(String string) throws ReportServiceException {
        return BirtUtility.findParameter(this.reportDesignHandle, string);
    }

    public ParameterDefinition findParameterDefinition(String string) {
        return BirtUtility.findParameterDefinition(this.parameterDefList, string);
    }

    public String getReportTitle() throws ReportServiceException {
        String string = BirtUtility.getTitleFromDesign(this.reportDesignHandle);
        if (string == null || string.trim().length() <= 0) {
            string = this.reportTitle;
        }
        return string;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Map getParametersAsString() {
        return this.parametersAsString;
    }

    public Collection getParameterDefList() {
        return this.parameterDefList;
    }

    public Map getDisplayTexts() {
        return this.displayTexts;
    }

    public Map getModuleOptions() {
        return this.moduleOptions;
    }

    public Map getDefaultValues() {
        return this.defaultValues;
    }
}

