/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.resource;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.resource.ViewerResourceHandle;

public class BirtResources {
    private static Map resourceMap = new HashMap();
    private static ThreadLocal threadLocal = new ThreadLocal();

    public static void setLocale(Locale locale) {
        if (locale == null) {
            threadLocal.set(Locale.getDefault());
        } else {
            threadLocal.set(locale);
        }
    }

    public static Locale getLocale() {
        Locale locale = (Locale)threadLocal.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMessage(String string) {
        ViewerResourceHandle viewerResourceHandle = BirtResources.getResourceHandle();
        if (viewerResourceHandle != null) {
            return viewerResourceHandle.getMessage(string);
        }
        return string;
    }

    public static String getMessage(String string, Object[] objectArray) {
        ViewerResourceHandle viewerResourceHandle = BirtResources.getResourceHandle();
        if (viewerResourceHandle != null) {
            return viewerResourceHandle.getMessage(string, objectArray);
        }
        return string;
    }

    public static String getString(String string) {
        return BirtResources.getMessage(string);
    }

    public static String getFormattedString(String string, Object[] objectArray) {
        return MessageFormat.format((String)BirtResources.getString(string), (Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewerResourceHandle getResourceHandle() {
        Locale locale = BirtResources.getLocale();
        ViewerResourceHandle viewerResourceHandle = (ViewerResourceHandle)((Object)resourceMap.get(locale));
        if (viewerResourceHandle != null) {
            return viewerResourceHandle;
        }
        Map map = resourceMap;
        synchronized (map) {
            if (resourceMap.get(locale) != null) {
                return (ViewerResourceHandle)((Object)resourceMap.get(locale));
            }
            viewerResourceHandle = new ViewerResourceHandle(locale);
            resourceMap.put(locale, viewerResourceHandle);
        }
        return viewerResourceHandle;
    }
}

