/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.CascadeParameter;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.SelectItemChoice;
import org.eclipse.birt.report.soapengine.api.SelectionList;

public abstract class AbstractGetCascadeParameterActionHandler
extends AbstractBaseActionHandler {
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractGetCascadeParameterActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        super(iContext, operation, getUpdatedObjectsResponse);
    }

    protected void __execute() throws Exception {
        Object object;
        BaseAttributeBean baseAttributeBean = this.context.getBean();
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        Oprand[] oprandArray = this.operation.getOprand();
        String string = baseAttributeBean.getReportDesignName();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < oprandArray.length; ++i) {
            object = oprandArray[i];
            linkedHashMap.put(((Oprand)object).getName(), ((Oprand)object).getValue());
        }
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", this.context.getRequest());
        object = new BirtViewerReportDesignHandle(null, string);
        Map map = this.getParameterSelectionLists((IViewerReportDesignHandle)object, linkedHashMap, inputOptions);
        CascadeParameter cascadeParameter = new CascadeParameter();
        if (map != null && map.size() > 0) {
            SelectionList[] selectionListArray = new SelectionList[map.size()];
            int n = 0;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                selectionListArray[n] = new SelectionList();
                String string2 = (String)iterator.next();
                selectionListArray[n].setName(string2);
                List list = (List)map.get(string2);
                SelectItemChoice[] selectItemChoiceArray = this.getVectorFromList(list);
                selectionListArray[n].setSelections(selectItemChoiceArray);
                ++n;
            }
            cascadeParameter.setSelectionList(selectionListArray);
        }
        this.handleUpdate(cascadeParameter);
    }

    private SelectItemChoice[] getVectorFromList(List list) {
        SelectItemChoice[] selectItemChoiceArray = new SelectItemChoice[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SelectItemChoice selectItemChoice = (SelectItemChoice)list.get(i);
            String string = selectItemChoice.getLabel();
            String string2 = selectItemChoice.getValue();
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
            }
            selectItemChoiceArray[i] = new SelectItemChoice(string2, string);
        }
        return selectItemChoiceArray;
    }

    protected abstract void handleUpdate(CascadeParameter var1);

    private Map getParameterSelectionLists(IViewerReportDesignHandle iViewerReportDesignHandle, Map map, InputOptions inputOptions) throws ReportServiceException {
        Object object;
        if (map == null || map.size() == 0) {
            return new HashMap();
        }
        List[] listArray = null;
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)map.keySet().iterator().next();
        Collection collection = this.getReportService().getParameterDefinitions(iViewerReportDesignHandle, inputOptions, false);
        ParameterDefinition parameterDefinition = null;
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            ParameterDefinition parameterDefinition2 = (ParameterDefinition)object2.next();
            if (!parameterDefinition2.getName().equals(string)) continue;
            parameterDefinition = parameterDefinition2;
            break;
        }
        if (parameterDefinition == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_PARAMETER", new String[]{string}));
        }
        object2 = parameterDefinition.getGroup();
        if (object2 != null && ((ParameterGroupDefinition)object2).getParameterCount() > map.size()) {
            int n = ((ParameterGroupDefinition)object2).getParameterCount() - map.size();
            for (int i = 0; i < n; ++i) {
                object = (ParameterDefinition)((ParameterGroupDefinition)object2).getParameters().get(map.size() + i);
                arrayList.add(((ParameterDefinition)object).getName());
            }
        }
        try {
            if (arrayList.size() > 0) {
                listArray = new List[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object[] objectArray = new Object[map.size() + i];
                    object = map.keySet();
                    int n = 0;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        objectArray[n] = map.get(iterator.next());
                        ++n;
                    }
                    for (n = 0; n < i; ++n) {
                        objectArray[map.size() + n] = listArray[n].isEmpty() ? null : listArray[n].get(0);
                    }
                    listArray[i] = this.doQueryCascadeParameterSelectionList(iViewerReportDesignHandle, ((ParameterGroupDefinition)object2).getName(), objectArray, inputOptions);
                    hashMap.put(arrayList.get(i), listArray[i]);
                }
            }
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
        return hashMap;
    }

    private List doQueryCascadeParameterSelectionList(IViewerReportDesignHandle iViewerReportDesignHandle, String string, Object[] objectArray, InputOptions inputOptions) throws RemoteException, ReportServiceException {
        ArrayList<SelectItemChoice> arrayList = new ArrayList<SelectItemChoice>();
        Collection collection = this.getReportService().getSelectionListForCascadingGroup(iViewerReportDesignHandle, string, objectArray, inputOptions);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator != null && iterator.hasNext()) {
                ParameterSelectionChoice parameterSelectionChoice = (ParameterSelectionChoice)iterator.next();
                if (parameterSelectionChoice == null || parameterSelectionChoice.getValue() == null) continue;
                try {
                    SelectItemChoice selectItemChoice = new SelectItemChoice();
                    selectItemChoice.setLabel(parameterSelectionChoice.getLabel());
                    selectItemChoice.setValue((String)DataTypeUtil.convert((Object)parameterSelectionChoice.getValue(), (int)5));
                    arrayList.add(n++, selectItemChoice);
                }
                catch (BirtException birtException) {
                    throw new ReportServiceException(birtException.getLocalizedMessage());
                }
            }
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !AbstractGetCascadeParameterActionHandler.class.desiredAssertionStatus();
    }
}

