/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.File;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;

public class BirtGetReportletActionHandler
extends AbstractBaseActionHandler {
    protected BaseAttributeBean __bean;
    protected String __docName;
    protected String __reportletId;
    OutputStream os = null;

    public BirtGetReportletActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse, OutputStream outputStream) {
        super(iContext, operation, getUpdatedObjectsResponse);
        this.os = outputStream;
    }

    protected void __execute() throws Exception {
        this.prepareParameters();
        this.doExecution();
        this.prepareResponse();
    }

    protected void prepareParameters() throws Exception, RemoteException {
        this.__bean = this.context.getBean();
        this.__docName = this.__bean.getReportDocumentName();
        this.__reportletId = this.__bean.getReportletId();
        this.__checkDocumentExists();
    }

    protected void doExecution() throws ReportServiceException, RemoteException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("locale", this.__bean.getLocale());
        inputOptions.setOption("format", this.__bean.getFormat());
        inputOptions.setOption("rtl", new Boolean(this.__bean.isRtl()));
        inputOptions.setOption("request", this.context.getRequest());
        inputOptions.setOption("svgFlag", new Boolean(false));
        inputOptions.setOption("isMasterPageContent", new Boolean(this.__bean.isMasterPageContent()));
        ArrayList arrayList = new ArrayList();
        this.getReportService().renderReportlet(this.__docName, this.__reportletId, inputOptions, arrayList, this.os);
    }

    protected void __checkDocumentExists() throws Exception {
        BirtRunReportActionHandler birtRunReportActionHandler;
        File file = new File(this.__docName);
        if (!file.exists()) {
            birtRunReportActionHandler = new BirtRunReportActionHandler(this.context, this.operation, this.response);
            birtRunReportActionHandler.__execute();
        }
        if (!(file = new File(this.__docName)).exists()) {
            birtRunReportActionHandler = new AxisFault();
            birtRunReportActionHandler.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
            throw birtRunReportActionHandler;
        }
    }

    protected void prepareResponse() throws ReportServiceException, RemoteException {
    }

    public IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

