/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.taglib.AbstractBaseTag;
import org.eclipse.birt.report.taglib.component.ParameterField;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractViewerTag
extends AbstractBaseTag {
    protected Locale locale;
    protected Map parameters;

    public void __init() {
        super.__init();
        this.parameters = new HashMap();
    }

    public boolean __validate() throws Exception {
        String string = (String)this.pageContext.getAttribute("hasHostPage");
        if (string != null && "true".equalsIgnoreCase(string)) {
            return false;
        }
        this.locale = BirtTagUtil.getLocale((HttpServletRequest)this.pageContext.getRequest(), this.viewer.getLocale());
        BirtResources.setLocale(this.locale);
        if (this.viewer.getId() == null || this.viewer.getId().length() <= 0) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_ATTR_ID"));
        }
        if (!this.__validateViewerId()) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.INVALID_ATTR_ID"));
        }
        if (this.pageContext.findAttribute(this.viewer.getId()) != null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.ATTR_ID_DUPLICATE"));
        }
        if (this.viewer.getReportDesign() == null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_SOURCE"));
        }
        if (this.viewer.getReportletId() != null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_DOCUMENT"));
        }
        return true;
    }

    protected boolean __validateViewerId() {
        Pattern pattern = Pattern.compile("^\\w+$");
        Matcher matcher = pattern.matcher(this.viewer.getId());
        return matcher.find();
    }

    protected void __beforeEndTag() {
        super.__beforeEndTag();
        this.viewer.setParameters(this.parameters);
        this.pageContext.setAttribute(this.viewer.getId(), (Object)this.viewer.getId());
        if (this.viewer.isHostPage()) {
            this.pageContext.setAttribute("hasHostPage", (Object)"true");
        }
    }

    protected void __handleIFrame(String string, String string2) throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String string3 = "params_" + this.viewer.getId();
        jspWriter.write("<div id=\"" + string3 + "\" style='display:none'>\n");
        Iterator iterator = this.viewer.getParameters().values().iterator();
        while (iterator.hasNext()) {
            ParameterField parameterField = (ParameterField)iterator.next();
            String string4 = ParameterAccessor.htmlEncode(parameterField.getName());
            Object object = parameterField.getValue();
            Object[] objectArray = object != null && object instanceof Object[] ? (Object[])object : new Object[]{object};
            for (int i = 0; i < objectArray.length; ++i) {
                String string5 = DataUtil.getDisplayValue(objectArray[i]);
                if (string5 == null) {
                    jspWriter.write("<input type = 'hidden' name=\"__isnull\" \n");
                    jspWriter.write(" value=\"" + string4 + "\">\n");
                    continue;
                }
                jspWriter.write("<input type = 'hidden' name=\"" + string4 + "\" \n");
                jspWriter.write(" value=\"" + string5 + "\">\n");
            }
            if (object != null && parameterField.isLocale() && (object instanceof String || object instanceof String[])) {
                jspWriter.write("<input type = 'hidden' name=\"__islocale\" \n");
                jspWriter.write(" value=\"" + string4 + "\">\n");
            }
            if (parameterField.getPattern() != null) {
                jspWriter.write("<input type = 'hidden' name=\"" + string4 + "_format\" \n");
                jspWriter.write(" value=\"" + parameterField.getPattern() + "\">\n");
            }
            if (parameterField.getDisplayText() == null) continue;
            jspWriter.write("<input type = 'hidden' name=\"__isdisplay__" + string4 + "\" \n");
            jspWriter.write(" value=\"" + parameterField.getDisplayText() + "\">\n");
        }
        jspWriter.write("</div>\n");
        jspWriter.write("<script type=\"text/javascript\">\n");
        jspWriter.write("function loadViewer" + this.viewer.getId() + "(){\n");
        jspWriter.write("var divObj = document.createElement( \"DIV\" );\n");
        jspWriter.write("var bodyObj = document.body;\n");
        jspWriter.write("if( !bodyObj )\n");
        jspWriter.write("  bodyObj = document.createElement(\"BODY\");\n");
        jspWriter.write("bodyObj.appendChild( divObj );\n");
        jspWriter.write("divObj.style.display = \"none\";\n");
        jspWriter.write("var formObj = document.createElement( \"FORM\" );\n");
        jspWriter.write("divObj.appendChild( formObj );\n");
        jspWriter.write("var paramContainer = document.getElementById(\"" + string3 + "\");\n");
        jspWriter.write("var oParams = paramContainer.getElementsByTagName('input');\n");
        jspWriter.write("if( oParams )\n");
        jspWriter.write("{\n");
        jspWriter.write("  for( var i=0;i<oParams.length;i++ )  \n");
        jspWriter.write("  {\n");
        jspWriter.write("    var param = document.createElement( \"INPUT\" );\n");
        jspWriter.write("    formObj.appendChild( param );\n");
        jspWriter.write("    param.TYPE = \"HIDDEN\";\n");
        jspWriter.write("    param.name= oParams[i].name;\n");
        jspWriter.write("    param.value= oParams[i].value;\n");
        jspWriter.write("  }\n");
        jspWriter.write("}\n");
        jspWriter.write("formObj.action = \"" + string + "\";\n");
        jspWriter.write("formObj.method = \"post\";\n");
        if (string2 != null) {
            jspWriter.write("formObj.target = \"" + string2 + "\";\n");
        }
        jspWriter.write("formObj.submit( );\n");
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
        jspWriter.write(this.__handleIFrameDefinition());
        jspWriter.write("<script type=\"text/javascript\">");
        jspWriter.write("loadViewer" + this.viewer.getId() + "();");
        jspWriter.write("</script>\n");
    }

    protected String __handleIFrameDefinition() {
        String string = "<iframe name=\"" + this.viewer.getId() + "\" frameborder=\"" + this.viewer.getFrameborder() + "\" ";
        if (this.viewer.getScrolling() != null) {
            string = string + " scrolling = \"" + this.viewer.getScrolling() + "\" ";
        }
        string = string + this.__handleAppearance() + "></iframe>\r\n";
        return string;
    }

    protected String __handleAppearance() {
        String string = " style='";
        if (this.viewer.getPosition() != null) {
            string = string + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            string = string + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            string = string + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            string = string + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            string = string + "left:" + this.viewer.getLeft() + "px;";
        }
        if (this.viewer.getStyle() != null) {
            string = string + this.viewer.getStyle() + ";";
        }
        string = string + "' ";
        return string;
    }

    public void addParameter(ParameterField parameterField) {
        if (parameterField != null) {
            this.parameters.put(parameterField.getName(), parameterField);
        }
    }

    public void setId(String string) {
        this.viewer.setId(string);
    }

    public void setBaseURL(String string) {
        this.viewer.setBaseURL(string);
    }

    public void setIsHostPage(String string) {
        this.viewer.setHostPage(Boolean.valueOf(string));
    }

    public void setScrolling(String string) {
        this.viewer.setScrolling(string);
    }

    public void setPosition(String string) {
        this.viewer.setPosition(string);
    }

    public void setStyle(String string) {
        this.viewer.setStyle(string);
    }

    public void setHeight(String string) {
        this.viewer.setHeight(Integer.parseInt(string));
    }

    public void setWidth(String string) {
        this.viewer.setWidth(Integer.parseInt(string));
    }

    public void setLeft(String string) {
        this.viewer.setLeft("" + Integer.parseInt(string));
    }

    public void setTop(String string) {
        this.viewer.setTop("" + Integer.parseInt(string));
    }

    public void setFrameborder(String string) {
        this.viewer.setFrameborder(string);
    }

    public void setReportDesign(String string) {
        this.viewer.setReportDesign(string);
    }

    public void setReportDocument(String string) {
        this.viewer.setReportDocument(string);
    }

    public void setBookmark(String string) {
        this.viewer.setBookmark(string);
    }

    public void setReportletId(String string) {
        this.viewer.setReportletId(string);
    }

    public void setLocale(String string) {
        this.viewer.setLocale(string);
    }

    public void setFormat(String string) {
        this.viewer.setFormat(string);
    }

    public void setSvg(String string) {
        this.viewer.setSvg(BirtTagUtil.convertBooleanValue(string));
    }

    public void setRtl(String string) {
        this.viewer.setRtl(BirtTagUtil.convertBooleanValue(string));
    }

    public void setPageNum(String string) {
        this.viewer.setPageNum(Long.parseLong(string));
    }

    public void setPageRange(String string) {
        this.viewer.setPageRange(string);
    }

    public void setShowParameterPage(String string) {
        this.viewer.setShowParameterPage(string);
    }

    public void setResourceFolder(String string) {
        this.viewer.setResourceFolder(string);
    }
}

