/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis.AxisFault;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BaseTaskBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.PrintUtility;
import org.eclipse.birt.report.utility.Printer;

public class BirtUtility {
    public static final String NONE = "none";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTask(HttpServletRequest httpServletRequest, IEngineTask iEngineTask) {
        if (httpServletRequest == null || iEngineTask == null) {
            return;
        }
        try {
            BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
            if (baseAttributeBean == null) {
                return;
            }
            String string = baseAttributeBean.getTaskId();
            if (string == null) {
                return;
            }
            HttpSession httpSession = httpServletRequest.getSession(true);
            HashMap<String, BaseTaskBean> hashMap = (HashMap<String, BaseTaskBean>)httpSession.getAttribute("tasks");
            if (hashMap == null) {
                hashMap = new HashMap<String, BaseTaskBean>();
                httpSession.setAttribute("tasks", hashMap);
            }
            HashMap<String, BaseTaskBean> hashMap2 = hashMap;
            synchronized (hashMap2) {
                BaseTaskBean baseTaskBean = new BaseTaskBean(string, iEngineTask);
                hashMap.put(string, baseTaskBean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return;
        }
        try {
            BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
            if (baseAttributeBean == null) {
                return;
            }
            String string = baseAttributeBean.getTaskId();
            if (string == null) {
                return;
            }
            HttpSession httpSession = httpServletRequest.getSession(true);
            Map map = (Map)httpSession.getAttribute("tasks");
            if (map == null) {
                return;
            }
            Map map2 = map;
            synchronized (map2) {
                map.remove(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelTask(HttpServletRequest httpServletRequest, String string) throws Exception {
        if (string == null) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            return;
        }
        Map map = (Map)httpSession.getAttribute("tasks");
        if (map != null && map.containsKey(string)) {
            BaseTaskBean baseTaskBean = (BaseTaskBean)map.get(string);
            if (baseTaskBean == null) {
                return;
            }
            IEngineTask iEngineTask = baseTaskBean.getTask();
            if (iEngineTask != null) {
                iEngineTask.cancel();
            }
            Map map2 = map;
            synchronized (map2) {
                map.remove(string);
            }
        }
    }

    public static List getParameterList(IViewerReportDesignHandle iViewerReportDesignHandle) throws ReportServiceException {
        IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        if (iReportRunnable == null) {
            return null;
        }
        ModuleHandle moduleHandle = iReportRunnable.getDesignHandle().getModuleHandle();
        if (moduleHandle == null) {
            return null;
        }
        return moduleHandle.getFlattenParameters();
    }

    public static ParameterDefinition findParameterDefinition(Collection collection, String string) {
        if (collection == null || string == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || !string.equals(string2 = parameterDefinition.getName())) continue;
            return parameterDefinition;
        }
        return null;
    }

    public static ParameterHandle findParameter(IViewerReportDesignHandle iViewerReportDesignHandle, String string) throws ReportServiceException {
        if (string == null) {
            return null;
        }
        IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        if (iReportRunnable == null) {
            return null;
        }
        ModuleHandle moduleHandle = iReportRunnable.getDesignHandle().getModuleHandle();
        if (moduleHandle == null) {
            return null;
        }
        return moduleHandle.findParameter(string);
    }

    public static Map getModuleOptions(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resourceFolder", ParameterAccessor.getResourceFolder(httpServletRequest));
        hashMap.put("semanticCheck", Boolean.FALSE);
        return hashMap;
    }

    public static Map getDisplayTexts(Collection collection, Map hashMap, HttpServletRequest httpServletRequest) {
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            ParameterDefinition parameterDefinition;
            String string = DataUtil.getString(enumeration.nextElement());
            String string2 = ParameterAccessor.isDisplayText(string);
            if (string2 == null || (parameterDefinition = BirtUtility.findParameterDefinition(collection, string2)) == null || parameterDefinition.isMultiValue()) continue;
            hashMap.put(string2, ParameterAccessor.getParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    public static List getLocParams(List arrayList, HttpServletRequest httpServletRequest) {
        String[] stringArray;
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        if ((stringArray = httpServletRequest.getParameterValues("__islocale")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    public static boolean validateParameters(Collection collection, Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            String string = parameterDefinition.getName();
            Object v = map.get(string);
            if (parameterDefinition.isHidden() || !parameterDefinition.isRequired()) continue;
            if (v == null) {
                bl = true;
                break;
            }
            if (v instanceof List) {
                List list = (List)v;
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e == null) {
                        bl = true;
                        break;
                    }
                    if (!(e instanceof String) || ((String)e).length() > 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (!(v instanceof String) || ((String)v).length() > 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void handleOperation(Operation operation, ViewerAttributeBean viewerAttributeBean, Map map, Map map2) throws Exception {
        Object object;
        Object object2;
        String string;
        if (operation == null || viewerAttributeBean == null || map == null || map2 == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        String string2 = null;
        Oprand[] oprandArray = operation.getOprand();
        for (int i = 0; i < oprandArray.length; ++i) {
            string = oprandArray[i].getName();
            object2 = oprandArray[i].getValue();
            if (string == null || object2 == null) continue;
            if (string.equalsIgnoreCase("__islocale")) {
                arrayList.add(object2);
                continue;
            }
            string2 = ParameterAccessor.isDisplayText(string);
            if (string2 != null) {
                object = viewerAttributeBean.findParameterDefinition(string2);
                if (object == null || ((ParameterDefinition)object).isMultiValue()) continue;
                map2.put(string2, object2);
                continue;
            }
            if ("__isnull".equalsIgnoreCase(string)) {
                string = (String)object2;
                object2 = null;
            }
            if ((object = (List)hashMap.get(string)) == null) {
                object = new ArrayList<Object>();
                hashMap.put(string, (ArrayList<Object>)object);
            }
            object.add(object2);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object3;
            string = (String)iterator.next();
            object2 = (List)hashMap.get(string);
            object = viewerAttributeBean.findParameterDefinition(string);
            if (object == null) continue;
            String string3 = ((ParameterDefinition)object).getPattern();
            String string4 = ParameterDataTypeConverter.ConvertDataType(((ParameterDefinition)object).getDataType());
            boolean bl = arrayList.contains(string);
            if (((ParameterDefinition)object).isMultiValue()) {
                object3 = new ArrayList();
                for (int i = 0; i < object2.size(); ++i) {
                    Object object4 = DataUtil.validate(string4, string3, (String)object2.get(i), viewerAttributeBean.getLocale(), bl);
                    object3.add(object4);
                }
                if (object3.size() == 0 || object3.size() == 1 && object3.get(0) == null) {
                    map.put(string, null);
                    continue;
                }
                map.put(string, object3.toArray());
                continue;
            }
            object3 = DataUtil.validate(string4, string3, (String)object2.get(0), viewerAttributeBean.getLocale(), bl);
            map.put(string, object3);
        }
    }

    public static IReportRunnable getRunnableFromDesignFile(HttpServletRequest httpServletRequest, String string, Map map) throws EngineException {
        IReportRunnable iReportRunnable = null;
        File file = new File(string);
        if (file.exists()) {
            iReportRunnable = ReportEngineService.getInstance().openReportDesign(string, map);
        } else {
            InputStream inputStream = null;
            URL uRL = null;
            try {
                string = ParameterAccessor.workingFolder + "/" + ParameterAccessor.getParameter(httpServletRequest, "__report");
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                if ((uRL = httpServletRequest.getSession().getServletContext().getResource(string)) != null) {
                    inputStream = uRL.openStream();
                }
                if (inputStream != null) {
                    iReportRunnable = ReportEngineService.getInstance().openReportDesign(uRL.toString(), inputStream, map);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iReportRunnable;
    }

    public static String getTitleFromDesign(IViewerReportDesignHandle iViewerReportDesignHandle) throws ReportServiceException {
        Object object;
        String string = null;
        if (iViewerReportDesignHandle != null && (object = iViewerReportDesignHandle.getDesignObject()) instanceof IReportRunnable) {
            IReportRunnable iReportRunnable = (IReportRunnable)object;
            string = (String)iReportRunnable.getProperty("title");
        }
        return string;
    }

    public static void appendErrorMessage(OutputStream outputStream, Exception exception) throws IOException {
        String string = "<html>\n<head>\n<title>" + BirtResources.getMessage("birt.viewer.title.error") + "</title>\n";
        string = string + "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n</head>\n";
        string = string + "<body>\n";
        String string2 = "document.getElementById('error_detail')";
        String string3 = "document.getElementById('error_icon')";
        String string4 = "if (" + string2 + ".style.display == 'none') { " + string3 + ".innerHTML = '- '; " + string2 + ".style.display = 'block'; }" + "else { " + string3 + ".innerHTML = '+ '; " + string2 + ".style.display = 'none'; }";
        string = string + "<div id=\"birt_errorPage\" style=\"color:red\">\n";
        string = string + "<span id=\"error_icon\"  style=\"cursor:pointer\" onclick=\"" + string4 + "\" > + </span>\n";
        String string5 = null;
        string5 = exception instanceof AxisFault ? ((AxisFault)((Object)exception)).getFaultString() : exception.getLocalizedMessage();
        string = string5 != null ? string + ParameterAccessor.htmlEncode(new String(string5.getBytes("ISO-8859-1"), "UTF-8")) : string + "Unknown error!";
        string = string + "<br>\n";
        string = string + "<pre id=\"error_detail\" style=\"display:none;\" >\n";
        string = string + BirtUtility.getDetailMessage(exception);
        string = string + "</pre>\n";
        string = string + "</div>\n";
        string = string + "</body>\n</html>";
        outputStream.write(string.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    public static String getDetailMessage(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace(printWriter);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        printWriter.flush();
        printWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public static void writeMessage(OutputStream outputStream, String string, String string2) throws IOException {
        String string3 = "black";
        if ("error".equalsIgnoreCase(string2)) {
            string3 = "red";
        }
        String string4 = "<html><head><title>" + BirtResources.getMessage("birt.viewer.title." + string2) + "</title>";
        string4 = string4 + "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\"></head>";
        string4 = string4 + "<body style=\"background-color: #ECE9D8;\"><div style=\"font-size:10pt;\"><font color=\"" + string3 + "\">" + string + "</font></div></body></html>";
        outputStream.write(string4.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    public static void doPrintAction(InputStream inputStream, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, RemoteException {
        Printer printer = PrintUtility.getPrinter(httpServletRequest);
        httpServletResponse.setContentType("text/html; charset=utf-8");
        if (printer != null) {
            PrintUtility.execPrint(inputStream, printer);
            BirtUtility.writeMessage((OutputStream)httpServletResponse.getOutputStream(), BirtResources.getMessage("birt.viewer.dialog.printserver.complete"), "complete");
        } else {
            BirtUtility.writeMessage((OutputStream)httpServletResponse.getOutputStream(), BirtResources.getMessage("birt.viewer.dialog.printserver.error.noprinter"), "error");
        }
    }

    public static String getTOCStyle(TOCNode tOCNode) {
        String string;
        String string2;
        if (tOCNode == null) {
            return null;
        }
        IScriptStyle iScriptStyle = tOCNode.getTOCStyle();
        if (iScriptStyle == null) {
            return null;
        }
        String string3 = BirtUtility.getStyle(iScriptStyle, "getBackgroundAttachment", "background-attachment");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBackgroundColor", "background-color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBackgroundImage", "background-image");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBackgroundPositionX", "background-position-x");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBackgroundPositionY", "background-position-y");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBackgroundRepeat", "background-repeat");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderBottomColor", "border-bottom-color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderBottomStyle", "border-bottom-style");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderBottomWidth", "border-bottom-width");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderLeftColor", "border-left-color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderLeftStyle", "border-left-style");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderLeftWidth", "border-left-width");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderRightColor", "border-right-color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderRightStyle", "border-right-style");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderRightWidth", "border-right-width");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderTopColor", "border-top-color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderTopStyle", "border-top-style");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getBorderTopWidth", "border-top-width");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getColor", "color");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getFontFamily", "font-family");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getFontSize", "font-size");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getFontStyle", "font-style");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getFontVariant", "font-variant");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getFontWeight", "font-weight");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getLetterSpacing", "letter-spacing");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getLineHeight", "line-height");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getPaddingBottom", "padding-bottom");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getPaddingLeft", "padding-left");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getPaddingRight", "padding-right");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getPaddingTop", "padding-top");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getTextAlign", "text-align");
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getTextTransform", "text-transform");
        String string4 = "";
        String string5 = iScriptStyle.getTextOverline();
        if (string5 != null && !NONE.equalsIgnoreCase(string5)) {
            string4 = string4 + string5 + " ";
        }
        if ((string2 = iScriptStyle.getTextLineThrough()) != null && !NONE.equalsIgnoreCase(string2)) {
            string4 = string4 + string2 + " ";
        }
        if ((string = iScriptStyle.getTextUnderline()) != null && !NONE.equalsIgnoreCase(string)) {
            string4 = string4 + string + " ";
        }
        if (string4.length() > 0) {
            string3 = string3 + "text-decoration:" + string4 + ";";
        }
        string3 = string3 + BirtUtility.getStyle(iScriptStyle, "getWordSpacing", "word-spacing");
        return string3;
    }

    private static String getStyle(Object object, String string, String string2) {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        String string3 = BirtUtility.invokeGetStyle(object, string);
        if (string3 == null || NONE.equalsIgnoreCase(string3)) {
            return "";
        }
        return string2 + ":" + string3 + ";";
    }

    private static String invokeGetStyle(Object object, String string) {
        String string2 = null;
        try {
            Method method = IScriptStyle.class.getMethod(string, new Class[0]);
            if (method == null) {
                return null;
            }
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 != null) {
                string2 = (String)object2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static Map getAppContext(HttpServletRequest httpServletRequest, ClassLoader classLoader) {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Boolean bl = ParameterAccessor.isDesigner(httpServletRequest);
        hashMap.put("org.eclipse.birt.data.engine.dataset.cache.option", bl);
        hashMap.put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        hashMap.put("PARENT_CLASSLOADER", classLoader);
        hashMap.put("CHART_RESOLUTION", ParameterAccessor.getDpi(httpServletRequest));
        int n2 = ParameterAccessor.getMaxCubeLevels(httpServletRequest);
        if (n2 >= 0) {
            hashMap.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_LEVEL, new Integer(n2));
        }
        if ((n = ParameterAccessor.getCubeMemorySize(httpServletRequest)) >= 0) {
            hashMap.put(DataEngine.IN_MEMORY_CUBE_SIZE, new Integer(n));
        }
        ParameterAccessor.pushAppContext(hashMap, httpServletRequest);
        return hashMap;
    }

    public static String findTocByName(IReportDocument iReportDocument, String string, InputOptions inputOptions) {
        ITOCTree iTOCTree;
        if (iReportDocument == null || string == null) {
            return null;
        }
        String string2 = null;
        Locale locale = null;
        if (inputOptions != null) {
            locale = (Locale)inputOptions.getOption("locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((iTOCTree = iReportDocument.getTOCTree("viewer", ULocale.forLocale((Locale)locale))) == null) {
            return null;
        }
        List list = iTOCTree.findTOCByValue((Object)string);
        if (list != null && list.size() > 0) {
            string2 = ((TOCNode)list.get(0)).getBookmark();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputFile(String string, OutputStream outputStream, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = new byte[512];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fileInputStream.close();
            try {
                if (bl) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        fileInputStream.close();
        try {
            if (bl) {
                file.delete();
            }
        }
        catch (Exception exception) {}
    }

    static {
        $assertionsDisabled = !BirtUtility.class.desiredAssertionStatus();
    }
}

