/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.Printer;

public class PrintUtility {
    public static final String PARAM_PRINTER = "__printer";
    public static final String PARAM_PRINTER_COPIES = "__printer_copies";
    public static final String PARAM_PRINTER_COLLATE = "__printer_collate";
    public static final String PARAM_PRINTER_DUPLEX = "__printer_duplex";
    public static final String PARAM_PRINTER_MODE = "__printer_mode";
    public static final String PARAM_PRINTER_MEDIASIZE = "__printer_pagesize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execPrint(InputStream inputStream, Printer printer) throws RemoteException {
        Object object;
        if (inputStream == null || printer == null) {
            return;
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (printer.isCopiesSupported()) {
            hashPrintRequestAttributeSet.add(new Copies(printer.getCopies()));
        }
        if (printer.isCollateSupported()) {
            hashPrintRequestAttributeSet.add(printer.isCollate() ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED);
        }
        if (printer.isDuplexSupported()) {
            switch (printer.getDuplex()) {
                case 0: {
                    hashPrintRequestAttributeSet.add(Sides.ONE_SIDED);
                    break;
                }
                case 1: {
                    hashPrintRequestAttributeSet.add(Sides.DUPLEX);
                    break;
                }
                case 2: {
                    hashPrintRequestAttributeSet.add(Sides.TUMBLE);
                    break;
                }
                default: {
                    hashPrintRequestAttributeSet.add(Sides.ONE_SIDED);
                }
            }
        }
        if (printer.isModeSupported()) {
            switch (printer.getMode()) {
                case 0: {
                    hashPrintRequestAttributeSet.add(Chromaticity.MONOCHROME);
                    break;
                }
                case 1: {
                    hashPrintRequestAttributeSet.add(Chromaticity.COLOR);
                    break;
                }
                default: {
                    hashPrintRequestAttributeSet.add(Chromaticity.MONOCHROME);
                }
            }
        }
        if (printer.isMediaSupported() && printer.getMediaSize() != null && (object = (MediaSizeName)printer.getMediaSizeNames().get(printer.getMediaSize())) != null) {
            hashPrintRequestAttributeSet.add((Attribute)object);
        }
        try {
            object = printer.getService();
            PrintService printService = object;
            synchronized (printService) {
                DocPrintJob docPrintJob = object.createPrintJob();
                SimpleDoc simpleDoc = new SimpleDoc(inputStream, DocFlavor.INPUT_STREAM.POSTSCRIPT, null);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
        }
        catch (PrintException printException) {
            AxisFault axisFault = new AxisFault(printException.getLocalizedMessage(), (Throwable)printException);
            axisFault.setFaultCode(new QName("PrintUtility.execPrint( )"));
            axisFault.setFaultString(printException.getLocalizedMessage());
            throw axisFault;
        }
    }

    public static Printer getPrinter(HttpServletRequest httpServletRequest) {
        Object object;
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER);
        Printer printer = null;
        if (string != null) {
            object = PrintUtility.findPrinters();
            for (int i = 0; i < object.size(); ++i) {
                if (!string.equalsIgnoreCase(((Printer)object.get(i)).getName())) continue;
                printer = (Printer)object.get(i);
                break;
            }
        }
        if (printer == null) {
            object = PrintServiceLookup.lookupDefaultPrintService();
            printer = PrintUtility.createPrinter((PrintService)object);
        }
        if (printer != null) {
            String string2;
            String string3;
            String string4;
            object = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER_COPIES);
            if (object != null) {
                printer.setCopies(Integer.parseInt((String)object));
            }
            if ((string4 = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER_COLLATE)) != null) {
                printer.setCollate(Boolean.valueOf(string4));
            }
            if ((string3 = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER_DUPLEX)) != null) {
                printer.setDuplex(Integer.parseInt(string3));
            }
            if ((string2 = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER_MODE)) != null) {
                printer.setMode(Integer.parseInt(string2));
            }
            String string5 = ParameterAccessor.getParameter(httpServletRequest, PARAM_PRINTER_MEDIASIZE);
            if ((string5 = ParameterAccessor.htmlDecode(string5)) != null) {
                printer.setMediaSize(string5);
            }
        }
        return printer;
    }

    public static List findPrinters() {
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.POSTSCRIPT;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(iNPUT_STREAM, hashPrintRequestAttributeSet);
        if (printServiceArray != null) {
            for (int i = 0; i < printServiceArray.length; ++i) {
                PrintService printService = printServiceArray[i];
                arrayList.add(PrintUtility.createPrinter(printService));
            }
        }
        return arrayList;
    }

    public static Printer createPrinter(PrintService printService) {
        if (printService == null) {
            return null;
        }
        Printer printer = new Printer();
        printer.setName(printService.getName());
        Object t = printService.getAttribute(PrinterMakeAndModel.class);
        if (t != null) {
            printer.setModel(t.toString());
        }
        if ((t = printService.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
            printer.setStatus(t.toString());
        }
        if ((t = printService.getAttribute(PrinterInfo.class)) != null) {
            printer.setInfo(t.toString());
        }
        printer.setCopiesSupported(printService.isAttributeCategorySupported(Copies.class));
        int n = 0;
        Copies copies = (Copies)printService.getDefaultAttributeValue(Copies.class);
        if (copies != null) {
            n = Integer.parseInt(copies.toString());
        }
        if (n <= 0) {
            n = 1;
        }
        printer.setCopies(n);
        boolean bl = printService.isAttributeCategorySupported(SheetCollate.class);
        printer.setCollateSupported(bl);
        if (bl) {
            SheetCollate sheetCollate = (SheetCollate)printService.getDefaultAttributeValue(SheetCollate.class);
            if (sheetCollate == null) {
                sheetCollate = SheetCollate.UNCOLLATED;
            }
            if (sheetCollate == SheetCollate.COLLATED) {
                printer.setCollate(true);
            } else {
                printer.setCollate(false);
            }
        }
        boolean bl2 = printService.isAttributeCategorySupported(Chromaticity.class);
        printer.setModeSupported(bl2);
        if (bl2) {
            Chromaticity chromaticity = (Chromaticity)printService.getDefaultAttributeValue(Chromaticity.class);
            if (chromaticity == null) {
                chromaticity = Chromaticity.MONOCHROME;
            }
            if (chromaticity == Chromaticity.MONOCHROME) {
                printer.setMode(0);
            } else {
                printer.setMode(1);
            }
        }
        boolean bl3 = printService.isAttributeCategorySupported(Sides.class);
        printer.setDuplexSupported(bl3);
        if (bl3) {
            Sides sides = (Sides)printService.getDefaultAttributeValue(Sides.class);
            if (sides == null) {
                sides = Sides.ONE_SIDED;
            }
            if (sides == Sides.ONE_SIDED) {
                printer.setDuplex(0);
            } else if (sides == Sides.TUMBLE) {
                printer.setDuplex(2);
            } else {
                printer.setDuplex(1);
            }
        }
        boolean bl4 = printService.isAttributeCategorySupported(Media.class);
        printer.setMediaSupported(bl4);
        if (bl4) {
            Object object;
            Object object2 = printService.getSupportedAttributeValues(Media.class, null, null);
            if (object2 != null && object2 instanceof Media[]) {
                object = (Media[])object2;
                for (int i = 0; i < ((Media[])object).length; ++i) {
                    if (!(object[i] instanceof MediaSizeName)) continue;
                    printer.addMediaSizeName(((EnumSyntax)object[i]).toString(), (Media)object[i]);
                }
            }
            if ((object = (Media)printService.getDefaultAttributeValue(Media.class)) != null && object instanceof MediaSizeName) {
                printer.setMediaSize(((EnumSyntax)object).toString());
            }
        }
        printer.setService(printService);
        return printer;
    }

    public static String handleSlash(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

