/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.models;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.models.MySafeRunnable;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class OverrideTemplateDescriptor
implements Comparable {
    public static final String TEMPLATE_TAG = "driverExtension";
    public static final String PLUGIN_LOC = "\\[\\%PLUGIN_LOC\\%\\]";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String OVERRIDE_DRIVERTEMPLATE_ELEMENT_TAG = "driverTemplateOverride";
    private static final String OVERRIDE_PROPERTIES_ELEMENT_TAG = "propertyOverrides";
    private static final String OVERRIDE_PROPERTY_ELEMENT_TAG = "propertyOverride";
    private static final String CREATEDEFAULT_TAG = "createDefault";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static final String JARLIST_ATTRIBUTE = "jarList";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String EMPTYJARLISTOK_TAG = "emptyJarListIsOK";
    private static final String VISIBLE_ATTRIBUTE = "visible";
    private static final String REMOVE_ATTRIBUTE = "remove";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String REQUIRED_ATTRIBUTE = "required";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String CUSTOM_PROP_DESCRIPTOR_ATTRIBUTE = "customPropertyDescriptor";
    private static final OverrideTemplateDescriptor[] EMPTY = new OverrideTemplateDescriptor[0];
    private static Map fgDriverTemplateDescriptors;
    private IConfigurationElement fElement;

    protected OverrideTemplateDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getTargetId(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.id_missing"));
        Assert.isNotNull((Object)this.getName(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.name_missing"));
    }

    public static OverrideTemplateDescriptor[] getByDriverTemplate(String driverTemplateId) {
        List descriptors;
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            OverrideTemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        return (descriptors = (List)fgDriverTemplateDescriptors.get(driverTemplateId)) != null ? descriptors.toArray(new OverrideTemplateDescriptor[descriptors.size()]) : EMPTY;
    }

    public static OverrideTemplateDescriptor[] getOverrideDriverTemplateDescriptors() {
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            OverrideTemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        return fgDriverTemplateDescriptors.values().toArray(new OverrideTemplateDescriptor[fgDriverTemplateDescriptors.size()]);
    }

    public String getTargetId() {
        return this.fElement.getAttribute(TARGET_ID_ATTRIBUTE);
    }

    public String getParentCategory() {
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public String getJarList() {
        String jarList = this.fElement.getAttribute(JARLIST_ATTRIBUTE);
        if (jarList == null) {
            jarList = new String();
        }
        if (!jarList.matches(".*\\[\\%PLUGIN_LOC\\%\\].*")) {
            return jarList;
        }
        try {
            String pluginID = this.fElement.getContributor().getName();
            String pluginLoc = FileLocator.resolve((URL)Platform.getBundle((String)pluginID).getEntry("")).getFile();
            if (pluginLoc.charAt(0) == '/') {
                pluginLoc = pluginLoc.substring(1);
            }
            if (pluginLoc.charAt(pluginLoc.length() - 1) == '/') {
                pluginLoc = pluginLoc.substring(0, pluginLoc.length() - 1);
            }
            jarList = jarList.replaceAll(PLUGIN_LOC, pluginLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jarList;
    }

    public String getCreateDefaultFlag() {
        if (this.fElement.getAttribute(CREATEDEFAULT_TAG) != null) {
            return this.fElement.getAttribute(CREATEDEFAULT_TAG);
        }
        return null;
    }

    public String getEmptyJarListIsOKFlag() {
        if (this.fElement.getAttribute(EMPTYJARLISTOK_TAG) != null) {
            return this.fElement.getAttribute(EMPTYJARLISTOK_TAG);
        }
        return null;
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        return name;
    }

    public IConfigurationElement[] getOverrideProperties() {
        IConfigurationElement[] propertyRoot = this.fElement.getChildren(OVERRIDE_PROPERTIES_ELEMENT_TAG);
        if (propertyRoot != null && propertyRoot.length == 1) {
            IConfigurationElement[] childElements = propertyRoot[0].getChildren(OVERRIDE_PROPERTY_ELEMENT_TAG);
            return childElements;
        }
        return new IConfigurationElement[0];
    }

    public String getPropertyValueFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, VALUE_ATTRIBUTE);
    }

    public String getPropertyNameFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, NAME_ATTRIBUTE);
    }

    public String getPropertyIDFromName(String propName) {
        return this.getPropertyAttributeValueByName(propName, TARGET_ID_ATTRIBUTE);
    }

    public String getPropertyDescriptionFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, DESCRIPTION_ATTRIBUTE);
    }

    public String getPropertyVisibleFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, VISIBLE_ATTRIBUTE);
    }

    public String getPropertyExampleFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, EXAMPLE_ATTRIBUTE);
    }

    public String getPropertyRequiredFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, REQUIRED_ATTRIBUTE);
    }

    public String getPropertyCustomPropDescriptorFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, CUSTOM_PROP_DESCRIPTOR_ATTRIBUTE);
    }

    public String getPropertyCategoryFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, CATEGORY_ATTRIBUTE);
    }

    public boolean getPropertyRemoveFlagFromID(String propId) {
        String removeStr = this.getPropertyAttributeValueByID(propId, REMOVE_ATTRIBUTE);
        if (removeStr != null) {
            Boolean flag = Boolean.valueOf(removeStr);
            return flag;
        }
        return false;
    }

    public String getPropertyNameFromConfigElement(IConfigurationElement element) {
        if (element.getAttribute(NAME_ATTRIBUTE) != null) {
            return element.getAttribute(NAME_ATTRIBUTE);
        }
        return "";
    }

    private String getPropertyAttributeValueByName(String propName, String attribute) {
        String attr_value = new String();
        IConfigurationElement[] props = this.getOverrideProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getAttribute(NAME_ATTRIBUTE) == null || !propName.equals(props[i].getAttribute(NAME_ATTRIBUTE))) continue;
            attr_value = props[i].getAttribute(attribute);
            break;
        }
        return attr_value;
    }

    private String getPropertyAttributeValueByID(String propId, String attribute) {
        String attr_value = new String();
        IConfigurationElement[] props = this.getOverrideProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getAttribute(TARGET_ID_ATTRIBUTE) == null || !propId.equals(props[i].getAttribute(TARGET_ID_ATTRIBUTE))) continue;
            attr_value = props[i].getAttribute(attribute);
            break;
        }
        return attr_value;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof OverrideTemplateDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((OverrideTemplateDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static void createDriverTemplateDescriptors(IConfigurationElement[] elements) {
        fgDriverTemplateDescriptors = new HashMap();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!OVERRIDE_DRIVERTEMPLATE_ELEMENT_TAG.equals(element.getName())) continue;
            OverrideTemplateDescriptor[] desc = new OverrideTemplateDescriptor[1];
            SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
            if (desc[0] == null) continue;
            ArrayList<OverrideTemplateDescriptor> descriptors = (ArrayList<OverrideTemplateDescriptor>)fgDriverTemplateDescriptors.get(desc[0].getTargetId());
            if (descriptors == null) {
                descriptors = new ArrayList<OverrideTemplateDescriptor>(1);
                fgDriverTemplateDescriptors.put(desc[0].getTargetId(), descriptors);
            }
            descriptors.add(desc[0]);
        }
    }

    public boolean hasVisibleProperties() {
        IConfigurationElement[] templateprops = this.getOverrideProperties();
        if (templateprops != null && templateprops.length > 0) {
            for (int i = 0; i < templateprops.length; ++i) {
                IConfigurationElement prop = templateprops[i];
                String visible = prop.getAttribute(VISIBLE_ATTRIBUTE);
                if (visible != null && !visible.equals(Boolean.toString(true))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OverrideTemplateDescriptor) {
            OverrideTemplateDescriptor compare = (OverrideTemplateDescriptor)obj;
            return this.getTargetId().equals(compare.getTargetId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getTargetId() != null) {
            return this.getTargetId().hashCode();
        }
        return super.hashCode();
    }
}

