/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ManagedConnection;

public class CreateConnectionJob
extends Job {
    private ManagedConnection mManagedConnection;
    private Object mFamily;

    public CreateConnectionJob(ManagedConnection managedConnection, Object family) {
        super(ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.name", new Object[]{managedConnection.getConnectionFactoryProvider().getName(), managedConnection.getConnectionProfile().getName()}));
        this.setUser(true);
        this.mManagedConnection = managedConnection;
        this.mFamily = family;
    }

    public ManagedConnection getManagedConnection() {
        return this.mManagedConnection;
    }

    private IConnectionFactoryProvider getConnectionFactoryProvider() {
        return this.mManagedConnection.getConnectionFactoryProvider();
    }

    private IConnectionProfile getConnectionProfile() {
        return this.mManagedConnection.getConnectionProfile();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(this.getName(), -1);
        try {
            this.mManagedConnection.createConnection(monitor);
            IConnection connection = this.mManagedConnection.getConnection();
            if (connection.getConnectException() != null) {
                status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{this.getConnectionFactoryProvider().getName(), this.getConnectionProfile().getName(), connection.getConnectException().getMessage()}), connection.getConnectException());
            }
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        catch (Exception e) {
            status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{this.getConnectionFactoryProvider().getName(), this.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e);
        }
        monitor.done();
        return status;
    }

    public boolean belongsTo(Object family) {
        return this.mFamily != null && family == this.mFamily;
    }
}

