/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;

public class DefaultCipherProvider
implements ICipherProvider {
    public Cipher createEncryptionCipher() throws GeneralSecurityException {
        Key k = this.loadKey();
        Cipher c = Cipher.getInstance(k.getAlgorithm());
        c.init(1, k);
        return c;
    }

    public Cipher createDecryptionCipher() throws GeneralSecurityException {
        Key k = this.loadKey();
        Cipher c = Cipher.getInstance(k.getAlgorithm());
        c.init(2, k);
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key loadKey() throws GeneralSecurityException {
        SecretKey secretKey;
        ObjectInputStream ois = null;
        try {
            try {
                URL url = ConnectivityPlugin.getDefault().getBundle().getResource("org/eclipse/datatools/connectivity/internal/security/cpkey");
                ois = new ObjectInputStream(url.openStream());
                SecretKeySpec spec = (SecretKeySpec)ois.readObject();
                SecretKeyFactory factory = SecretKeyFactory.getInstance(spec.getAlgorithm());
                secretKey = factory.generateSecret(new DESedeKeySpec(spec.getEncoded()));
                Object var7_8 = null;
                if (ois == null) return secretKey;
            }
            catch (IOException e) {
                throw new InvalidKeySpecException();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidKeySpecException();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return secretKey;
        }
        ois.close();
        return secretKey;
    }
}

