/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;

public class WpmlWriter {
    private int IMAGE_ID = 75;
    private int BOOKMARK_ID = 0;
    public static int TOTALPAGE = 0;
    private XMLWriter writer = new XMLWriter();
    public static int PAGE = 1;
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.wpml.WpmlWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public WpmlWriter(OutputStream out) {
        this(out, "UTF-8");
    }

    public WpmlWriter(OutputStream out, String encoding) {
        this.writer.open(out, encoding);
    }

    public void start() {
        this.writer.startWriter();
        this.writer.literal("\n");
        this.writer.literal("<?mso-application progid=\"Word.Document\"?>");
        this.writer.literal("\n");
        this.writer.openTag("w:wordDocument");
        this.writer.attribute("xmlns:w", "http://schemas.microsoft.com/office/word/2003/wordml");
        this.writer.attribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        this.writer.attribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:dt", "uuid:C2F41010-65B3-11d1-A29F-00AA00C14882");
        this.writer.attribute("xmlns:wx", "http://schemas.microsoft.com/office/word/2003/auxHint");
        this.writer.attribute("xmlns:aml", "http://schemas.microsoft.com/aml/2001/core");
        this.writer.attribute("xml:space", "preserve");
        this.writer.openTag("w:styles");
        this.writer.openTag("w:style");
        this.writer.attribute("w:type", "paragraph");
        this.writer.attribute(" w:styleId", 4);
        this.writer.openTag("w:name");
        this.writer.attribute("w:val", "toc 4");
        this.writer.closeTag("w:name");
        this.writer.openTag("wx:uiName");
        this.writer.attribute("wx:val", "catalog 4");
        this.writer.closeTag("wx:uiName");
        this.writer.openTag("w:autoRedefine");
        this.writer.closeTag("w:autoRedefine");
        this.writer.openTag("w:semiHidden");
        this.writer.closeTag("w:semiHidden");
        this.writer.openTag("w:rsid");
        this.writer.attribute("w:val", "009B3C8F");
        this.writer.closeTag("w:rsid");
        this.writer.openTag("w:pPr");
        this.writer.openTag("w:pStyle");
        this.writer.attribute("w:val", 4);
        this.writer.closeTag("w:pStyle");
        this.writer.closeTag("w:pPr");
        this.writer.openTag("w:rPr");
        this.writer.openTag("wx:font");
        this.writer.attribute("wx:val", "Times New Roman");
        this.writer.closeTag("wx:font");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:style");
        this.writer.closeTag("w:styles");
        this.writer.openTag("w:displayBackgroundShape");
        this.writer.closeTag("w:displayBackgroundShape");
        this.writer.openTag("w:docPr");
        this.writer.openTag("w:view");
        this.writer.attribute("w:val", "print");
        this.writer.closeTag("w:view");
        this.writer.openTag("w:zoom");
        this.writer.attribute("w:percent", "100");
        this.writer.closeTag("w:zoom");
        this.writer.closeTag("w:docPr");
        this.writer.openTag("w:body");
    }

    public void startPageBreak() {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
    }

    public void endPageBreak() {
        this.writer.closeTag("w:pPr");
        this.writer.closeTag("w:p");
    }

    public void startSection() {
        this.writer.openTag("w:sectPr");
    }

    public void endSection() {
        this.writer.closeTag("w:sectPr");
    }

    public void writeTocs(List tocs) {
        this.writer.openTag("wx:sub-section");
        int count = tocs.size();
        int i = 0;
        while (i < count) {
            String toc = (String)tocs.get(i);
            this.writeTOC(toc, toc);
            ++i;
        }
        this.writer.closeTag("wx:sub-section");
    }

    private void writeTOC(String head, String target) {
        head = this.ridquote(head);
        target = WordUtil.validBookmarkName(this.ridquote(target));
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.writer.openTag("w:pStyle");
        this.writer.attribute("w:val", 4);
        this.writer.closeTag("w:pStyle");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:pPr");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "begin");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:instrText");
        this.writer.text("TOC \\o \"1-3\" \\h \\z \\t");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:instrText");
        this.writer.text("content");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:instrText");
        this.writer.text("\ufffd\ufffd4\"");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "separate");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:hlink");
        this.writer.attribute("w:bookmark", target);
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:rStyle");
        this.writer.attribute("w:val", "a4");
        this.writer.closeTag("w:rStyle");
        this.writer.openTag("w:rFonts");
        this.writer.attribute("w:hint", "fareast");
        this.writer.closeTag("w:rFonts");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:t");
        this.writer.text(head);
        this.writer.closeTag("w:t");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:tab");
        this.writer.attribute("wx:wTab", 5);
        this.writer.attribute("wx:tlc", "dot");
        this.writer.attribute("wx:cTlc", 0);
        this.writer.closeTag("w:tab");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "begin");
        this.writer.openTag("w:fldData");
        this.writer.text("CNDJ6nn5us4RjIIAqgBLqQsCAAAACAAAAA4AAABfAFQAbwBjADEANAA1ADMAOAA3ADcANAA3AAAA");
        this.writer.closeTag("w:fldData");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:instrText");
        this.writer.text("PAGEREF  " + target + "\\h");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "separate");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:t");
        this.writer.text("1");
        this.writer.closeTag("w:t");
        this.writer.closeTag("w:r");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "end");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:hlink");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.openTag("w:webHidden");
        this.writer.closeTag("w:webHidden");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", "end");
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
    }

    public void startTable(IStyle style, int tablewidth) {
        this.writer.openTag("w:tbl");
        this.writer.openTag("w:tblPr");
        this.writer.openTag("w:tblInd");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblInd");
        this.writeAttrTag("w:tblStyle", "TableGrid");
        this.writeAttrTag("w:tblOverlap", "Never");
        this.writer.openTag("w:tblW");
        this.writer.attribute("w:w", tablewidth);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblW");
        this.writeAttrTag("w:tblLook", "01E0");
        this.writer.openTag("w:tblLayout");
        this.writer.attribute("w:type", "Fixed");
        this.writer.closeTag("w:tblLayout");
        this.writer.openTag("w:tblBorders");
        this.writeBorders(style);
        this.writer.closeTag("w:tblBorders");
        String color = this.parseColor(style.getBackgroundColor());
        this.writeBackgroundColor(color);
        this.writeAlign(style.getTextAlign());
        this.writer.closeTag("w:tblPr");
    }

    private void writeSpacing(String height) {
        this.writer.openTag("w:spacing");
        this.writer.attribute("w:before", String.valueOf(Math.round(Float.parseFloat(height) / 1000.0f) * 20 / 2));
        this.writer.attribute("w:after", String.valueOf(Math.round(Float.parseFloat(height) / 1000.0f) * 20 / 2));
        this.writer.closeTag("w:spacing");
    }

    private void writeSpacing(String top, String bottom) {
        this.writer.openTag("w:spacing");
        this.writer.attribute("w:before", String.valueOf(Math.round(Float.parseFloat(top) / 1000.0f) * 20 / 2));
        this.writer.attribute("w:after", String.valueOf(Math.round(Float.parseFloat(bottom) / 1000.0f) * 20 / 2));
        this.writer.closeTag("w:spacing");
    }

    private void writeAlign(String align) {
        if ("justify".equalsIgnoreCase(align)) {
            align = "both";
        }
        this.writeAttrTag("w:jc", align);
    }

    private void writeBorders(IStyle style) {
        String color = style.getBorderBottomColor();
        String bstyle = style.getBorderBottomStyle();
        String width = style.getBorderBottomWidth();
        this.writeSingleBorder("bottom", color, bstyle, width);
        color = style.getBorderTopColor();
        bstyle = style.getBorderTopStyle();
        width = style.getBorderTopWidth();
        this.writeSingleBorder("top", color, bstyle, width);
        color = style.getBorderLeftColor();
        bstyle = style.getBorderLeftStyle();
        width = style.getBorderLeftWidth();
        this.writeSingleBorder("left", color, bstyle, width);
        color = style.getBorderRightColor();
        bstyle = style.getBorderRightStyle();
        width = style.getBorderRightWidth();
        this.writeSingleBorder("right", color, bstyle, width);
    }

    private void writeSingleBorder(String type, String color, String style, String width) {
        if (style == null || "none".equalsIgnoreCase(style)) {
            return;
        }
        this.writer.openTag("w:" + type);
        this.writeBorderProperty(color, style, width);
        this.writer.closeTag("w:" + type);
    }

    private void writeBorderProperty(String color, String style, String width) {
        style = this.getBorderStyle(style);
        int sz = this.getBorderSize(width);
        this.writer.attribute("w:val", style);
        this.writer.attribute("w:sz", sz);
        this.writer.attribute("wx:bdrwidth", this.getBorderWidth(sz, style));
        this.writer.attribute("w:space", 0);
        this.writer.attribute("w:color", this.parseColor(color));
    }

    private String getBorderStyle(String style) {
        if ("solid".equalsIgnoreCase(style)) {
            style = "single";
        }
        return style;
    }

    private int getBorderWidth(int sz, String style) {
        if (sz == 0) {
            return 0;
        }
        int ratio = 1;
        if ("double".equalsIgnoreCase(style)) {
            ratio = 3;
        }
        return sz / 2 * 5 * ratio;
    }

    private int getBorderSize(String width) {
        int sz = 0;
        try {
            int w = Math.round(Float.parseFloat(width));
            sz = 8;
            if (w == 750) {
                sz = 4;
            } else if (w > 3000) {
                sz = 12;
            }
            return sz;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return sz;
        }
    }

    private int getImageID() {
        return this.IMAGE_ID++;
    }

    public void drawImage(String data, double height, double width, HyperlinkInfo hyper, IStyle style) {
        int imageId = this.getImageID();
        this.writer.openTag("w:p");
        this.openHyperlink(hyper);
        this.writer.openTag("w:r");
        this.writer.openTag("w:pict");
        this.writer.openTag("v:shapetype");
        this.writer.attribute("id", "_x0000_t" + imageId);
        this.writer.attribute("coordsize", "21600,21600");
        this.writer.attribute("o:spt", "75");
        this.writer.attribute("o:preferrelative", "t");
        this.writer.attribute("path", "m@4@5l@4@11@9@11@9@5xe");
        this.writer.attribute("filled", "f");
        this.writer.attribute("stroked", "f");
        this.writer.openTag("v:stoke");
        this.writer.attribute("joinstyle", "miter");
        this.writer.closeTag("v:stoke");
        this.writer.openTag("v:formulas");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "if lineDrawn pixelLineWidth 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 1 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum 0 0 @1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @2 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 0 1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @6 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @8 21600 0 ");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @10 21600 0");
        this.writer.closeTag("v:f");
        this.writer.closeTag("v:formulas");
        this.writer.openTag("v:path");
        this.writer.attribute("o:extrusionok", "f");
        this.writer.attribute("gradientshapeok", "t");
        this.writer.attribute("o:connecttype", "rect");
        this.writer.closeTag("v:path");
        this.writer.openTag("o:lock");
        this.writer.attribute("v:ext", "edit");
        this.writer.attribute("aspectratio", "t");
        this.writer.closeTag("o:lock");
        this.writer.closeTag("v:shapetype");
        this.writer.openTag("w:binData");
        this.writer.attribute("w:name", "wordml://" + imageId + ".png");
        this.writer.text(data);
        this.writer.closeTag("w:binData");
        this.writer.openTag("v:shape");
        this.writer.attribute("id", "_x0000_i10" + imageId);
        this.writer.attribute("type", "#_x0000_t" + imageId);
        this.writer.attribute("style", "width:" + width + "pt;height:" + height + "pt");
        this.writeImageBordersColor(style);
        this.writer.openTag("v:imagedata");
        this.writer.attribute("src", "wordml://" + imageId + ".png");
        this.writer.attribute("otitle", "");
        this.writer.closeTag("v:imagedata");
        this.writeImageBorderStyle(style);
        this.writer.closeTag("v:shape");
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.closeHyperlink(hyper);
        this.writer.closeTag("w:p");
    }

    private void writeImageBordersColor(IStyle style) {
        String color = style.getBorderBottomColor();
        this.writeImageBorderColor("bottom", color);
        color = style.getBorderTopColor();
        this.writeImageBorderColor("top", color);
        color = style.getBorderLeftColor();
        this.writeImageBorderColor("left", color);
        color = style.getBorderRightColor();
        this.writeImageBorderColor("right", color);
    }

    private void writeImageBorderColor(String pos, String color) {
        String direct = "o:border" + pos + "color";
        this.writer.attribute(direct, color);
    }

    private void writeImageBorderStyle(IStyle style) {
        String bstyle = style.getBorderBottomStyle();
        String width = style.getBorderBottomWidth();
        this.writeImgBorderStyle("bottom", bstyle, width);
        bstyle = style.getBorderTopStyle();
        width = style.getBorderTopWidth();
        this.writeImgBorderStyle("top", bstyle, width);
        bstyle = style.getBorderLeftStyle();
        width = style.getBorderLeftWidth();
        this.writeImgBorderStyle("left", bstyle, width);
        bstyle = style.getBorderRightStyle();
        width = style.getBorderRightWidth();
        this.writeImgBorderStyle("right", bstyle, width);
    }

    private void writeImgBorderStyle(String pos, String style, String width) {
        String direct = "w10:border" + pos;
        this.writer.openTag(direct);
        this.writer.attribute("type", this.getBorderStyle(style));
        int sz = this.getBorderSize(width);
        this.writer.attribute("width", this.getBorderWidth(sz, width));
        this.writer.closeTag(direct);
    }

    public void writeCol(int[] cols) {
        this.writer.openTag("w:tblGrid");
        int i = 0;
        while (i < cols.length) {
            this.writeAttrTag("w:gridCol", String.valueOf(cols[i]));
            ++i;
        }
        this.writer.closeTag("w:tblGrid");
    }

    public void endTable() {
        this.writer.closeTag("w:tbl");
    }

    public void insertHiddenP() {
        this.writer.openTag("w:p");
        this.writer.openTag("w:rPr");
        this.writeAttrTag("w:vanish", "on");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:p");
    }

    public void writeText(String txt, IStyle style, int w) {
        this.writeContent(-1, txt, style, null, false, false);
    }

    public void writeContent(int type, String txt, IStyle style, HyperlinkInfo info, boolean inline, boolean first) {
        if (inline) {
            if (first) {
                this.writer.openTag("w:p");
                this.writer.openTag("w:pPr");
                this.writeSpacing(style.getProperty(53).getCssText(), style.getProperty(52).getCssText());
                this.writeAlign(style.getTextAlign());
                String val = this.parseColor(style.getBackgroundColor());
                this.writeBackgroundColor(val);
                this.writer.closeTag("w:pPr");
            }
            this.writeTextInR(type, txt, style, info, true);
        } else {
            this.writeTextInP(type, txt, style, info);
        }
    }

    private void writeTextInR(int type, String txt, IStyle style, HyperlinkInfo info, boolean prop) {
        this.openHyperlink(info);
        boolean reserved = this.isReserved(type);
        if (reserved) {
            this.writer.openTag("w:r");
            this.writer.openTag("w:fldChar");
            this.writer.attribute("w:fldCharType", "begin");
            this.writer.closeTag("w:fldChar");
            this.writer.closeTag("w:r");
        }
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writeRunProperties(style, info != null);
        if (prop) {
            this.writeAlign(style.getTextAlign());
            String val = this.parseColor(style.getBackgroundColor());
            this.writeBackgroundColor(val);
            this.writeRunBorders(style);
        }
        this.writer.closeTag("w:rPr");
        if (reserved) {
            this.writeAutoText(type);
        } else {
            this.writeString(txt);
        }
        this.writer.closeTag("w:r");
        if (reserved) {
            this.writer.openTag("w:r");
            this.writer.openTag("w:fldChar");
            this.writer.attribute("w:fldCharType", "end");
            this.writer.closeTag("w:fldChar");
            this.writer.closeTag("w:r");
        }
        this.closeHyperlink(info);
    }

    private boolean isReserved(int type) {
        return type == 1 || type == 0;
    }

    private void writeRunBorders(IStyle style) {
        String val = style.getBorderTopStyle();
        if (val != null && !"none".equalsIgnoreCase(val)) {
            this.writer.openTag("w:bdr");
            this.writeBorderProperty(style.getBorderTopColor(), val, style.getBorderTopWidth());
            this.writer.closeTag("w:bdr");
            return;
        }
        val = style.getBorderBottomStyle();
        if (val != null && !"none".equalsIgnoreCase(val)) {
            this.writer.openTag("w:bdr");
            this.writeBorderProperty(style.getBorderBottomColor(), val, style.getBorderBottomWidth());
            this.writer.closeTag("w:bdr");
            return;
        }
        val = style.getBorderLeftStyle();
        if (val != null && !"none".equalsIgnoreCase(val)) {
            this.writer.openTag("w:bdr");
            this.writeBorderProperty(style.getBorderLeftColor(), val, style.getBorderLeftWidth());
            this.writer.closeTag("w:bdr");
            return;
        }
        val = style.getBorderRightStyle();
        if (val != null && !"none".equalsIgnoreCase(val)) {
            this.writer.openTag("w:bdr");
            this.writeBorderProperty(style.getBorderRightColor(), val, style.getBorderRightWidth());
            this.writer.closeTag("w:bdr");
            return;
        }
    }

    private void writeTextInP(int type, String txt, IStyle style, HyperlinkInfo info) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        if (!style.getLineHeight().equalsIgnoreCase("normal")) {
            this.writeSpacing(style.getLineHeight());
        }
        this.writeAlign(style.getTextAlign());
        String val = this.parseColor(style.getBackgroundColor());
        this.writeBackgroundColor(val);
        this.writer.openTag("w:pBdr");
        this.writeBorders(style);
        this.writer.closeTag("w:pBdr");
        this.writer.closeTag("w:pPr");
        this.writeTextInR(type, txt, style, info, false);
        this.writer.closeTag("w:p");
    }

    private void writeBackgroundColor(String color) {
        if (color == null) {
            return;
        }
        this.writer.openTag("w:shd");
        this.writer.attribute("w:val", "clear");
        this.writer.attribute("w:color", "auto");
        this.writer.attribute("w:fill", color);
        this.writer.closeTag("w:shd");
    }

    public void openHyperlink(HyperlinkInfo info) {
        if (info == null) {
            return;
        }
        this.writer.openTag("w:hlink");
        if (HyperlinkInfo.BOOKMARK == info.type) {
            this.writer.attribute("w:bookmark", info.url);
        } else if (HyperlinkInfo.HYPERLINK == info.type) {
            this.writer.attribute("w:dest", info.url);
            if (info.mark != null) {
                this.writer.attribute("w:bookmark", info.mark);
            }
        }
    }

    public void closeHyperlink(HyperlinkInfo info) {
        if (info == null || info.type == HyperlinkInfo.DRILL) {
            return;
        }
        this.writer.closeTag("w:hlink");
    }

    public void writeBookmark(String bm) {
        bm = WordUtil.validBookmarkName(bm);
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.BOOKMARK_ID);
        this.writer.attribute("w:type", "Word.Bookmark.Start");
        this.writer.attribute("w:name", bm);
        this.writer.closeTag("aml:annotation");
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.BOOKMARK_ID);
        this.writer.attribute("w:type", "Word.Bookmark.End");
        this.writer.closeTag("aml:annotation");
        ++this.BOOKMARK_ID;
    }

    public void close() {
        this.writer.close();
    }

    public void writeRunProperties(IStyle style, boolean hyper) {
        String val = this.parseFont(style.getFontFamily());
        this.writer.openTag("w:rFonts");
        this.writer.attribute("w:ascii", val);
        this.writer.attribute("w:fareast", val);
        this.writer.attribute("w:h-ansi", val);
        this.writer.attribute("w:cs", val);
        this.writer.closeTag("w:rFonts");
        val = this.ridquote(style.getFontSize());
        this.writeAttrTag("w:sz", String.valueOf(Math.round(Float.parseFloat(val) / 1000.0f) * 2));
        val = this.ridquote(style.getLetterSpacing());
        this.writeAttrTag("w:spacing", String.valueOf(Math.round(Float.parseFloat(val) / 1000.0f) * 20));
        val = this.ridquote(style.getTextUnderline());
        if (!"none".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:u", "single");
        }
        if (!"none".equalsIgnoreCase(val = this.ridquote(style.getTextLineThrough()))) {
            this.writeAttrTag("w:strike", "on");
        }
        if (!"normal".equalsIgnoreCase(val = this.ridquote(style.getFontStyle()))) {
            this.writeAttrTag("w:i", "on");
        }
        if (!"normal".equalsIgnoreCase(val = this.ridquote(style.getFontWeight()))) {
            this.writeAttrTag("w:b", "on");
        }
        if ((val = this.parseColor(style.getColor())) != null) {
            this.writeAttrTag("w:color", val);
        }
        if (hyper) {
            this.writeAttrTag("w:u", "single");
            this.writeAttrTag("w:color", "0000ff");
        }
    }

    protected void writeAttrTag(String name, String val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    public void writePageBackground(String type, String data) {
        String color = null;
        if ("color".equalsIgnoreCase(type) && (color = this.parseColor(data)) == null) {
            return;
        }
        this.writer.openTag("w:bgPict");
        if ("image".equalsIgnoreCase(type)) {
            int imgId = this.getImageID();
            this.writer.openTag("w:binData");
            this.writer.attribute("w:name", "wordml://" + imgId + ".png");
            this.writer.text(data);
            this.writer.closeTag("w:binData");
            this.writer.openTag("w:background");
            this.writer.attribute("w:bgcolor", "white");
            this.writer.attribute("w:background", "wordml://" + imgId + ".png");
            this.writer.closeTag("w:background");
        } else {
            this.writer.openTag("w:background");
            this.writer.attribute("w:bgcolor", color);
            this.writer.closeTag("w:background");
        }
        this.writer.closeTag("w:bgPict");
    }

    protected void writeString(String txt) {
        if (txt == null) {
            return;
        }
        this.writer.openTag("w:t");
        StringTokenizer st = new StringTokenizer(txt, "\n");
        boolean nbreak = false;
        while (st.hasMoreTokens()) {
            String row = "<![CDATA[" + st.nextToken().trim() + "]]>";
            if (nbreak) {
                row = "<w:br/>" + row;
            } else {
                nbreak = true;
            }
            this.writer.text(row, true, false);
        }
        this.writer.closeTag("w:t");
    }

    private String ridquote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    private String parseFont(String fontFamily) {
        String val = this.ridquote(fontFamily);
        if ("serif".equalsIgnoreCase(val)) {
            return "Times New Roman";
        }
        if ("sans-serif".equalsIgnoreCase(val)) {
            return "Arial";
        }
        if ("monospace".equalsIgnoreCase(val)) {
            return "Courier New";
        }
        if ("fantasy".equalsIgnoreCase(val)) {
            return "Times New Roman";
        }
        if ("cursive".equalsIgnoreCase(val)) {
            return "Times New Roman";
        }
        return val;
    }

    private String parseColor(String color) {
        if ("transparent".equalsIgnoreCase(color) || color == null) {
            return null;
        }
        String[] values = color.substring(color.indexOf("(") + 1, color.length() - 1).split(",");
        String value = "";
        int i = 0;
        while (i < values.length) {
            try {
                String s = Integer.toHexString(Integer.parseInt(values[i].trim()));
                if (s.length() == 1) {
                    s = "0" + s;
                }
                value = String.valueOf(value) + s;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                value = null;
            }
            ++i;
        }
        return value;
    }

    public void startTblRow(double height, String type) {
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        if (height != -1.0) {
            this.writeAttrTag("w:trHeight", String.valueOf(height));
        }
        if ("header".equalsIgnoreCase(type)) {
            this.writeAttrTag("w:tblHeader", "on");
        }
        this.writer.closeTag("w:trPr");
    }

    public void endTblRow() {
        this.writer.closeTag("w:tr");
    }

    public void startTblCell(int w, IStyle style, SpanInfo info) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", w);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
        if (info != null) {
            if (info.cs > 1) {
                this.writeAttrTag("w:gridSpan", String.valueOf(info.cs));
            }
            if (info.start) {
                this.writeAttrTag("w:vmerge", "restart");
            } else {
                this.writer.openTag("w:vmerge");
                this.writer.closeTag("w:vmerge");
            }
        }
        this.writeCellProp(style);
        this.writer.closeTag("w:tcPr");
        this.writer.openTag("w:pPr");
        this.writeAlign(style.getTextAlign());
        this.writer.closeTag("w:pPr");
    }

    public void writeSpanCell(SpanInfo info) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", info.width);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
        if (info.cs > 1) {
            this.writeAttrTag("w:gridSpan", String.valueOf(info.cs));
        }
        if (info.start) {
            this.writeAttrTag("w:vmerge", "restart");
        } else {
            this.writer.openTag("w:vmerge");
            this.writer.closeTag("w:vmerge");
        }
        this.writeCellProp(info.style);
        this.writer.closeTag("w:tcPr");
        this.insertHiddenP();
        this.writer.closeTag("w:tc");
    }

    private void writeCellProp(IStyle style) {
        String bgColor = this.parseColor(style.getBackgroundColor());
        if (bgColor != null) {
            this.writer.openTag("w:shd");
            this.writer.attribute("w:val", "clear");
            this.writer.attribute("w:color", "auto");
            this.writer.attribute("w:fill", bgColor);
            this.writer.closeTag("w:shd");
        }
        this.writer.openTag("w:tcBorders");
        this.writeBorders(style);
        this.writer.closeTag("w:tcBorders");
    }

    public void endTblCell(boolean empty) {
        if (empty) {
            this.insertHiddenP();
        }
        this.writer.closeTag("w:tc");
    }

    public void startPg() {
        this.writer.openTag("wx:sect");
    }

    public void endPg() {
        this.writer.closeTag("wx:sect");
    }

    public void end() {
        this.writer.closeTag("w:body");
        this.writer.closeTag("w:wordDocument");
        this.writer.close();
    }

    public void startHeader(boolean showHeaderOnFirst) {
        this.writer.openTag("w:hdr");
        if (showHeaderOnFirst) {
            this.writer.attribute("w:type", "first");
            this.writer.openTag("w:p");
            this.writer.openTag("w:r");
            this.writer.closeTag("w:r");
            this.writer.closeTag("w:p");
        }
        this.writer.attribute("w:type", "odd");
    }

    public void endHeader() {
        this.writer.closeTag("w:hdr");
    }

    public void startFooter() {
        this.writer.openTag("w:ftr");
        this.writer.attribute("w:type", "odd");
    }

    public void endFooter() {
        this.writer.closeTag("w:ftr");
    }

    public void writePgProp(int ph, int pw, int hh, int fh, int tm, int bm, int lm, int rm, String orient) {
        this.writer.openTag("w:pgSz");
        this.writer.attribute("w:w", pw);
        this.writer.attribute("w:h", ph);
        this.writer.closeTag("w:pgSz");
        this.writer.openTag("w:pgMar");
        this.writer.attribute("w:top", tm);
        this.writer.attribute("w:bottom", bm);
        this.writer.attribute("w:left", lm);
        this.writer.attribute("w:right", rm);
        this.writer.closeTag("w:pgMar");
    }

    public void writeAutoText(int type) {
        this.writer.openTag("w:instrText");
        if (type == 1) {
            this.writer.text("PAGE");
        } else if (type == 0) {
            this.writer.text("NUMPAGES");
        }
        this.writer.closeTag("w:instrText");
    }

    public void endParagraph() {
        this.writer.closeTag("w:p");
    }
}

