/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.service.api.IViewerReportService;

public abstract class AbstractBaseFragment
implements IFragment {
    protected String JSPRootPath = null;
    protected ArrayList children = new ArrayList();

    protected abstract String doPostService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected abstract IViewerReportService getReportService();

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, BirtException {
        this.doPreService(httpServletRequest, httpServletResponse);
        this.doService(httpServletRequest, httpServletResponse);
        String string = this.doPostService(httpServletRequest, httpServletResponse);
        if (string != null && string.length() > 0) {
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string);
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    public void callBack(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, BirtException {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                IFragment iFragment = (IFragment)this.children.get(i);
                if (iFragment == null) continue;
                iFragment.service(httpServletRequest, httpServletResponse);
            }
        }
    }

    protected void doPreService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html;charset=utf-8");
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, BirtException {
        httpServletRequest.setAttribute("fragment", (Object)this);
    }

    public String getClientId() {
        return null;
    }

    public String getClientName() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public Collection getChildren() {
        return this.children;
    }

    public void addChild(IFragment iFragment) {
        this.children.add(iFragment);
    }

    public void buildComposite() {
        this.build();
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((IFragment)iterator.next()).buildComposite();
            }
        }
    }

    protected void build() {
    }

    public void setJSPRootPath(String string) {
        this.JSPRootPath = string;
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((IFragment)iterator.next()).setJSPRootPath(string);
            }
        }
    }

    public String getJSPRootPath() {
        return this.JSPRootPath;
    }
}

