/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

class ViewerHTMLActionHandler
extends HTMLActionHandler {
    protected Logger log = Logger.getLogger(ViewerHTMLActionHandler.class.getName());
    protected IReportDocument document = null;
    protected Locale locale = null;
    protected long page = -1L;
    protected boolean isEmbeddable = false;
    protected boolean isRtl = false;
    protected boolean isMasterPageContent = true;
    protected String hostFormat = null;
    protected String resourceFolder = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ViewerHTMLActionHandler() {
    }

    public ViewerHTMLActionHandler(IReportDocument iReportDocument, long l, Locale locale, boolean bl, boolean bl2, boolean bl3, String string) {
        this.document = iReportDocument;
        this.page = l;
        this.locale = locale;
        this.isEmbeddable = bl;
        this.isRtl = bl2;
        this.isMasterPageContent = bl3;
        this.hostFormat = string;
    }

    public ViewerHTMLActionHandler(Locale locale, boolean bl, boolean bl2, String string) {
        this.locale = locale;
        this.isRtl = bl;
        this.isMasterPageContent = bl2;
        this.hostFormat = string;
    }

    public String getURL(IAction iAction, IReportContext iReportContext) {
        if (iAction == null) {
            return null;
        }
        switch (iAction.getType()) {
            case 2: {
                return this.buildBookmarkAction(iAction, iReportContext);
            }
            case 1: {
                return iAction.getActionString();
            }
            case 3: {
                return this.buildDrillAction(iAction, iReportContext);
            }
        }
        return null;
    }

    public String getURL(IAction iAction, Object object) {
        if (iAction == null) {
            return null;
        }
        if (object instanceof IReportContext) {
            return this.getURL(iAction, (IReportContext)object);
        }
        throw new IllegalArgumentException("The context is of wrong type.");
    }

    protected String buildBookmarkAction(IAction iAction, IReportContext iReportContext) {
        String string;
        if (iAction == null || iReportContext == null) {
            return null;
        }
        String string2 = null;
        Object object = this.getRenderContext(iReportContext);
        if (object instanceof HTMLRenderContext) {
            string2 = ((HTMLRenderContext)object).getBaseURL();
        }
        if (object instanceof PDFRenderContext) {
            string2 = ((PDFRenderContext)object).getBaseURL();
        }
        if (string2 == null) {
            return null;
        }
        String string3 = iAction.getBookmark();
        if (string2.lastIndexOf("/frameset") > 0) {
            String string4 = "catchBookmark('" + ParameterAccessor.htmlEncode(string3) + "');";
            return "javascript:try{" + string4 + "}catch(e){parent." + string4 + "};";
        }
        if (string2.lastIndexOf("/run") > 0) {
            String string5 = "catchBookmark('" + string3 + "');";
            return "javascript:try{" + string5 + "}catch(e){parent." + string5 + "};";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.document != null) {
            long l = this.document.getPageNumber(iAction.getBookmark());
            bl = l == this.page && !this.isEmbeddable;
        }
        try {
            string3 = URLEncoder.encode(string3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer.append(string2);
        stringBuffer.append("?");
        if (this.document != null) {
            stringBuffer.append("__document");
            stringBuffer.append("=");
            string = this.document.getName();
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string);
        } else if (iAction.getReportName() != null && iAction.getReportName().length() > 0) {
            stringBuffer.append("__report");
            stringBuffer.append("=");
            string = this.getReportName(iReportContext, iAction);
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string);
        } else {
            return "#" + iAction.getActionString();
        }
        if (this.locale != null) {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
        }
        if (this.isRtl) {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
        }
        stringBuffer.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
        try {
            if (this.resourceFolder != null) {
                string = URLEncoder.encode(this.resourceFolder, "UTF-8");
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__resourceFolder", string));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (bl) {
            stringBuffer.append("#");
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__bookmark", string3));
            if (!iAction.isBookmark()) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
            }
        }
        return stringBuffer.toString();
    }

    protected String buildDrillAction(IAction iAction, IReportContext iReportContext) {
        if (iAction == null || iReportContext == null) {
            return null;
        }
        String string = null;
        Object object = this.getRenderContext(iReportContext);
        if (object instanceof HTMLRenderContext) {
            string = ((HTMLRenderContext)object).getBaseURL();
        }
        if (object instanceof PDFRenderContext) {
            string = ((PDFRenderContext)object).getBaseURL();
        }
        if (string == null) {
            string = "preview";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getReportName(iReportContext, iAction);
        if (string2 != null && !string2.equals("")) {
            Object object2;
            Object object3;
            stringBuffer.append(string);
            stringBuffer.append(string2.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String string3 = iAction.getFormat();
            if (string3 == null || string3.length() == 0) {
                string3 = this.hostFormat;
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__format", string3));
            }
            if (iAction.getParameterBindings() != null) {
                object3 = iAction.getParameterBindings().entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    try {
                        String string4 = (String)object2.getKey();
                        Object v = object2.getValue();
                        if (v == null) continue;
                        String string5 = DataUtil.getDisplayValue(v);
                        stringBuffer.append(ParameterAccessor.getQueryParameterString(URLEncoder.encode(string4, "UTF-8"), URLEncoder.encode(string5, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                if (!string2.toLowerCase().endsWith(".rptdocument") && string.lastIndexOf("/frameset") > 0) {
                    stringBuffer.append(ParameterAccessor.getQueryParameterString("__overwrite", String.valueOf(true)));
                }
            }
            if (this.locale != null) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
            }
            if (this.isRtl) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
            }
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
            try {
                if (this.resourceFolder != null) {
                    object3 = URLEncoder.encode(this.resourceFolder, "UTF-8");
                    stringBuffer.append(ParameterAccessor.getQueryParameterString("__resourceFolder", (String)object3));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            object3 = iAction.getBookmark();
            if (object3 != null) {
                try {
                    if (string.lastIndexOf("/preview") > 0 || "pdf".equalsIgnoreCase(string3)) {
                        stringBuffer.append("#");
                        if (!iAction.isBookmark() && string2.toLowerCase().endsWith(".rptdocument")) {
                            object2 = new InputOptions();
                            ((InputOptions)object2).setOption("locale", this.locale);
                            object3 = BirtReportServiceFactory.getReportService().findTocByName(string2, (String)object3, (InputOptions)object2);
                        }
                        stringBuffer.append(URLEncoder.encode((String)object3, "UTF-8"));
                    } else {
                        object3 = URLEncoder.encode((String)object3, "UTF-8");
                        stringBuffer.append(ParameterAccessor.getQueryParameterString("__bookmark", (String)object3));
                        if (!iAction.isBookmark()) {
                            stringBuffer.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getReportName(IReportContext iReportContext, IAction iAction) {
        ModuleHandle moduleHandle;
        URL uRL;
        if (!$assertionsDisabled && iReportContext == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iAction == null) {
            throw new AssertionError();
        }
        String string = iAction.getReportName();
        IReportRunnable iReportRunnable = iReportContext.getReportRunnable();
        if (iReportRunnable != null && !ParameterAccessor.isWorkingFolderAccessOnly() && (uRL = (moduleHandle = iReportRunnable.getDesignHandle().getModuleHandle()).findResource(string, -1)) != null) {
            string = "file".equals(uRL.getProtocol()) ? uRL.getFile() : uRL.toExternalForm();
        }
        return string;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String string) {
        this.resourceFolder = string;
    }

    static {
        $assertionsDisabled = !ViewerHTMLActionHandler.class.desiredAssertionStatus();
    }
}

