/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.layout.EngineFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.RequesterFragment;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportService;
import org.eclipse.birt.report.servlet.BaseReportEngineServlet;
import org.eclipse.birt.report.utility.BirtUtility;

public class BirtEngineServlet
extends BaseReportEngineServlet {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void __init(ServletConfig servletConfig) {
        BirtReportServiceFactory.init(new BirtViewerReportService(servletConfig.getServletContext()));
        this.engine = new EngineFragment();
        this.requester = new RequesterFragment();
        this.requester.buildComposite();
        this.requester.setJSPRootPath("/webcontent/birt");
    }

    protected IContext __getContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws BirtException {
        BirtReportServiceFactory.getReportService().setContext(this.getServletContext(), null);
        return new BirtContext(httpServletRequest, httpServletResponse);
    }

    protected boolean __authenticate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    protected void __doGet(IContext iContext) throws ServletException, IOException, BirtException {
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)iContext.getBean();
        if (!$assertionsDisabled && viewerAttributeBean == null) {
            throw new AssertionError();
        }
        if (("/preview".equalsIgnoreCase(iContext.getRequest().getServletPath()) || "/document".equalsIgnoreCase(iContext.getRequest().getServletPath()) || "/output".equalsIgnoreCase(iContext.getRequest().getServletPath())) && viewerAttributeBean.isShowParameterPage()) {
            this.requester.service(iContext.getRequest(), iContext.getResponse());
        } else if ("/parameter".equalsIgnoreCase(iContext.getRequest().getServletPath())) {
            this.requester.service(iContext.getRequest(), iContext.getResponse());
        } else {
            this.engine.service(iContext.getRequest(), iContext.getResponse());
        }
    }

    protected void __handleNonSoapException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws ServletException, IOException {
        exception.printStackTrace();
        BirtUtility.appendErrorMessage((OutputStream)httpServletResponse.getOutputStream(), exception);
    }

    static {
        $assertionsDisabled = !BirtEngineServlet.class.desiredAssertionStatus();
    }
}

