/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.NativeDataTypeUtil;
import org.eclipse.birt.report.model.adapter.oda.util.IdentifierUtility;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;
import org.eclipse.emf.common.util.EList;

class ResultSetsAdapter {
    private final OdaDataSetHandle setHandle;
    private final DataSetDesign setDesign;
    private List setDefinedResults = null;
    private List setDefinedColumnHints = null;
    private List columnHintsForComputedColumns = null;
    private final IODADesignFactory designFactory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    ResultSetsAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        this.setHandle = setHandle;
        this.setDesign = setDesign;
        Iterator tmpIterator = setHandle.resultSetIterator();
        this.setDefinedResults = new ArrayList();
        while (tmpIterator.hasNext()) {
            this.setDefinedResults.add(tmpIterator.next());
        }
        tmpIterator = setHandle.columnHintsIterator();
        this.setDefinedColumnHints = new ArrayList();
        while (tmpIterator.hasNext()) {
            this.setDefinedColumnHints.add(tmpIterator.next());
        }
        this.designFactory = ODADesignFactory.getFactory();
    }

    private ColumnHint newROMColumnHintFromColumnDefinition(ColumnDefinition columnDefn, ColumnDefinition cachedColumnDefn, ColumnHint oldHint, String columnName) {
        if (columnDefn == null) {
            return null;
        }
        DataElementAttributes dataAttrs = columnDefn.getAttributes();
        if (dataAttrs == null) {
            return null;
        }
        ColumnHint newHint = null;
        ColumnDefinition tmpCachedColumnDefn = cachedColumnDefn;
        if (oldHint == null) {
            newHint = StructureFactory.createColumnHint();
            tmpCachedColumnDefn = null;
        } else {
            newHint = (ColumnHint)oldHint.copy();
        }
        DataElementUIHints dataUIHints = dataAttrs.getUiHints();
        OutputElementAttributes outputAttrs = columnDefn.getUsageHints();
        boolean hasValue = this.hasColumnHintValue(dataUIHints, outputAttrs);
        if (!hasValue) {
            if (oldHint == null) {
                return null;
            }
            return newHint;
        }
        DataElementAttributes cachedDataAttrs = tmpCachedColumnDefn == null ? null : tmpCachedColumnDefn.getAttributes();
        this.updateColumnHintFromDataAttrs(columnDefn.getAttributes(), cachedDataAttrs, newHint);
        this.updateColumnHintFromUsageHints(columnDefn.getUsageHints(), tmpCachedColumnDefn == null ? null : tmpCachedColumnDefn.getUsageHints(), newHint);
        if (StringUtil.isBlank((String)((String)newHint.getProperty(null, "columnName")))) {
            newHint.setProperty("columnName", (Object)columnName);
        }
        return newHint;
    }

    private boolean hasColumnHintValue(DataElementUIHints dataUIHints, OutputElementAttributes outputAttrs) {
        if (dataUIHints == null && outputAttrs == null) {
            return false;
        }
        boolean isValueSet = false;
        if (dataUIHints != null && dataUIHints.getDisplayName() != null) {
            isValueSet = true;
        }
        if (!isValueSet && outputAttrs != null) {
            ValueFormatHints formatHints;
            if (outputAttrs.getHelpText() != null) {
                isValueSet = true;
            }
            if (!isValueSet && (formatHints = outputAttrs.getFormattingHints()) != null && formatHints.getDisplayFormat() != null) {
                isValueSet = true;
            }
        }
        return isValueSet;
    }

    private void updateColumnHintFromDataAttrs(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, ColumnHint newHint) {
        DataElementUIHints dataUIHints;
        if (dataAttrs == null) {
            return;
        }
        String oldValue = cachedDataAttrs == null ? null : cachedDataAttrs.getName();
        String newValue = dataAttrs.getName();
        if (oldValue == null || !oldValue.equals(newValue)) {
            newHint.setProperty("columnName", (Object)newValue);
        }
        if ((dataUIHints = dataAttrs.getUiHints()) == null) {
            return;
        }
        DataElementUIHints cachedDataUIHints = cachedDataAttrs == null ? null : cachedDataAttrs.getUiHints();
        oldValue = cachedDataUIHints == null ? null : cachedDataUIHints.getDisplayName();
        newValue = dataUIHints.getDisplayName();
        if (oldValue == null || !oldValue.equals(newValue)) {
            newHint.setProperty("displayName", (Object)newValue);
        }
    }

    private void updateColumnHintFromUsageHints(OutputElementAttributes outputAttrs, OutputElementAttributes cachedOutputAttrs, ColumnHint newHint) {
        ValueFormatHints formatHints;
        if (outputAttrs == null) {
            return;
        }
        String oldValue = cachedOutputAttrs == null ? null : cachedOutputAttrs.getHelpText();
        String newValue = outputAttrs.getHelpText();
        if (oldValue == null || !oldValue.equals(newValue)) {
            newHint.setProperty("helpText", (Object)newValue);
        }
        if ((formatHints = outputAttrs.getFormattingHints()) == null) {
            return;
        }
        ValueFormatHints cachedFormatHints = cachedOutputAttrs == null ? null : cachedOutputAttrs.getFormattingHints();
        oldValue = cachedFormatHints == null ? null : cachedFormatHints.getDisplayFormat();
        newValue = formatHints.getDisplayFormat();
        if (oldValue == null || !oldValue.equals(newValue)) {
            newHint.setProperty("format", (Object)newValue);
        }
    }

    private void updateROMOdaResultSetColumnFromColumnDefinition(ColumnDefinition columnDefn, ColumnDefinition cachedColumnDefn, OdaResultSetColumn setColumn, String dataSourceId, String dataSetId) {
        if (columnDefn == null) {
            return;
        }
        this.updateResultSetColumnFromDataAttrs(columnDefn.getAttributes(), cachedColumnDefn == null ? null : cachedColumnDefn.getAttributes(), setColumn, dataSourceId, dataSetId);
    }

    private void updateResultSetColumnFromDataAttrs(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, OdaResultSetColumn newColumn, String dataSourceId, String dataSetId) {
        if (dataAttrs == null) {
            return;
        }
        Object oldValue = cachedDataAttrs == null ? null : cachedDataAttrs.getName();
        Object newValue = StringUtil.trimString((String)dataAttrs.getName());
        if (oldValue == null || !oldValue.equals(newValue)) {
            newColumn.setNativeName((String)newValue);
        }
        oldValue = cachedDataAttrs == null ? null : new Integer(cachedDataAttrs.getPosition());
        newValue = new Integer(dataAttrs.getPosition());
        if (oldValue == null || !oldValue.equals(newValue)) {
            newColumn.setPosition((Integer)newValue);
        }
        oldValue = cachedDataAttrs == null ? null : new Integer(cachedDataAttrs.getNativeDataTypeCode());
        newValue = new Integer(dataAttrs.getNativeDataTypeCode());
        if (oldValue == null || !oldValue.equals(newValue) || newColumn.getNativeDataType() == null) {
            newColumn.setNativeDataType((Integer)newValue);
        }
        newColumn.setDataType(this.getROMDataType(dataSourceId, dataSetId, newColumn));
    }

    private String getROMDataType(String dataSourceId, String dataSetId, OdaResultSetColumn column) {
        String name = column.getNativeName();
        Integer position = column.getPosition();
        Integer nativeDataType = column.getNativeDataType();
        OdaResultSetColumnHandle tmpParam = ResultSetsAdapter.findOdaResultSetColumn(this.setDefinedResults.iterator(), name, position, nativeDataType);
        if (tmpParam == null) {
            return this.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), null);
        }
        Integer tmpPosition = tmpParam.getPosition();
        if (tmpPosition == null) {
            return this.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), null);
        }
        if (!tmpPosition.equals(column.getPosition())) {
            return this.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), null);
        }
        Integer tmpNativeCodeType = tmpParam.getNativeDataType();
        if (tmpNativeCodeType == null || tmpNativeCodeType.equals(column.getNativeDataType())) {
            return tmpParam.getDataType();
        }
        String oldDataType = tmpParam.getDataType();
        return this.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), oldDataType);
    }

    private String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode, String romDataType) {
        String newRomDataType = null;
        try {
            newRomDataType = NativeDataTypeUtil.getUpdatedDataType(dataSourceId, dataSetId, nativeDataTypeCode, romDataType, "columnDataType");
        }
        catch (BirtException birtException) {}
        return newRomDataType;
    }

    /*
     * Unable to fully structure code
     */
    private static OdaResultSetColumnHandle findOdaResultSetColumn(Iterator columns, String paramName, Integer position, Integer nativeDataType) {
        if (position != null && nativeDataType != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            column = (OdaResultSetColumnHandle)columns.next();
            tmpNativeDataType = column.getNativeDataType();
            nativeName = column.getNativeName();
            if (!StringUtil.isBlank((String)nativeName) && !nativeName.equalsIgnoreCase(paramName) || !position.equals(column.getPosition()) || tmpNativeDataType != null && !nativeDataType.equals(tmpNativeDataType)) continue;
            return column;
lbl8:
            // 2 sources

            ** while (columns.hasNext())
        }
lbl9:
        // 1 sources

        return null;
    }

    private static ColumnDefinition findColumnDefinition(ResultSetColumns columns, String columnName, Integer position) {
        if (columns == null || columnName == null) {
            return null;
        }
        EList odaColumns = columns.getResultColumnDefinitions();
        if (odaColumns == null || odaColumns.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < odaColumns.size()) {
            ColumnDefinition columnDefn = (ColumnDefinition)odaColumns.get(i);
            DataElementAttributes dataAttrs = columnDefn.getAttributes();
            if (dataAttrs != null && columnName.equals(dataAttrs.getName()) && (position == null || position.intValue() == dataAttrs.getPosition())) {
                return columnDefn;
            }
            ++i;
        }
        return null;
    }

    List newROMResultSets(ResultSetDefinition cachedSetDefn) throws SemanticException {
        ResultSets resultSets;
        ResultSetColumns cachedSetColumns = cachedSetDefn == null ? null : cachedSetDefn.getResultSetColumns();
        ResultSetDefinition resultDefn = this.setDesign.getPrimaryResultSet();
        if (resultDefn == null && (resultSets = this.setDesign.getResultSets()) != null && !resultSets.getResultSetDefinitions().isEmpty()) {
            resultDefn = (ResultSetDefinition)resultSets.getResultSetDefinitions().get(0);
        }
        if (resultDefn == null) {
            return null;
        }
        ResultSetColumns setColumns = resultDefn.getResultSetColumns();
        if (setColumns == null) {
            return null;
        }
        EList odaSetColumns = setColumns.getResultColumnDefinitions();
        if (odaSetColumns.isEmpty()) {
            return null;
        }
        ArrayList<ResultSetColumnInfo> retList = new ArrayList<ResultSetColumnInfo>();
        ResultSetColumnInfo setInfo = null;
        int i = 0;
        while (i < odaSetColumns.size()) {
            ColumnDefinition columnDefn = (ColumnDefinition)odaSetColumns.get(i);
            DataElementAttributes dataAttrs = columnDefn.getAttributes();
            ColumnDefinition cachedColumnDefn = null;
            OdaResultSetColumnHandle oldColumn = null;
            if (dataAttrs != null) {
                String nativeName = dataAttrs.getName();
                Integer position = new Integer(dataAttrs.getPosition());
                cachedColumnDefn = ResultSetsAdapter.findColumnDefinition(cachedSetColumns, nativeName, position);
                oldColumn = ResultSetsAdapter.findOdaResultSetColumn(this.setDefinedResults.iterator(), nativeName, position, new Integer(dataAttrs.getNativeDataTypeCode()));
            }
            OdaResultSetColumn newColumn = null;
            if (oldColumn == null) {
                newColumn = StructureFactory.createOdaResultSetColumn();
                cachedColumnDefn = null;
            } else {
                newColumn = (OdaResultSetColumn)oldColumn.getStructure().copy();
            }
            this.updateROMOdaResultSetColumnFromColumnDefinition(columnDefn, cachedColumnDefn, newColumn, this.setDesign.getOdaExtensionDataSourceId(), this.setDesign.getOdaExtensionDataSetId());
            ColumnHint oldHint = null;
            ColumnHintHandle oldHintHandle = ResultSetsAdapter.findColumnHint(newColumn, this.setDefinedColumnHints.iterator());
            if (oldHintHandle != null) {
                oldHint = (ColumnHint)oldHintHandle.getStructure();
            }
            ColumnHint newHint = this.newROMColumnHintFromColumnDefinition(columnDefn, cachedColumnDefn, oldHint, newColumn.getColumnName());
            setInfo = new ResultSetColumnInfo(newColumn, newHint);
            retList.add(setInfo);
            ++i;
        }
        ArrayList columns = new ArrayList();
        ResultSetColumnInfo.updateResultSetColumnList(retList, columns, null);
        ResultSetsAdapter.createUniqueResultSetColumnNames(retList);
        this.updateHintsForComputedColumn();
        return retList;
    }

    private static ColumnHintHandle findColumnHint(OdaResultSetColumn setColumn, Iterator columnHints) {
        if (!$assertionsDisabled && setColumn == null) {
            throw new AssertionError();
        }
        return ResultSetsAdapter.findColumnHint(setColumn.getColumnName(), columnHints);
    }

    /*
     * Unable to fully structure code
     */
    static ColumnHintHandle findColumnHint(String name, Iterator columnHints) {
        if (name != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            hint = (ColumnHintHandle)columnHints.next();
            if (!name.equals(hint.getColumnName())) continue;
            return hint;
lbl6:
            // 2 sources

            ** while (columnHints.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    static ResultSetColumnHandle findColumn(String name, Iterator columns) {
        if (name != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            column = (ResultSetColumnHandle)columns.next();
            if (!name.equals(column.getColumnName())) continue;
            return column;
lbl6:
            // 2 sources

            ** while (columns.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    ResultSetDefinition newOdaResultSetDefinition() {
        Iterator romSets = this.setDefinedResults.iterator();
        String name = this.setHandle.getResultSetName();
        if (!romSets.hasNext()) {
            return null;
        }
        ResultSetDefinition odaSetDefn = null;
        ResultSetColumns odaSetColumns = null;
        if (!StringUtil.isBlank((String)name)) {
            odaSetDefn = this.designFactory.createResultSetDefinition();
            odaSetDefn.setName(name);
        }
        while (romSets.hasNext()) {
            Integer nativeDataType;
            if (odaSetDefn == null) {
                odaSetDefn = this.designFactory.createResultSetDefinition();
            }
            if (odaSetColumns == null) {
                odaSetColumns = this.designFactory.createResultSetColumns();
            }
            OdaResultSetColumnHandle setColumn = (OdaResultSetColumnHandle)romSets.next();
            ColumnHintHandle hint = ResultSetsAdapter.findColumnHint((OdaResultSetColumn)setColumn.getStructure(), this.setDefinedColumnHints.iterator());
            ColumnDefinition columnDefn = this.designFactory.createColumnDefinition();
            DataElementAttributes dataAttrs = this.designFactory.createDataElementAttributes();
            String newName = setColumn.getNativeName();
            dataAttrs.setName(newName);
            Integer position = setColumn.getPosition();
            if (position != null) {
                dataAttrs.setPosition(setColumn.getPosition().intValue());
            }
            if ((nativeDataType = setColumn.getNativeDataType()) != null) {
                dataAttrs.setNativeDataTypeCode(nativeDataType.intValue());
            }
            columnDefn.setAttributes(dataAttrs);
            odaSetColumns.getResultColumnDefinitions().add((Object)columnDefn);
            if (hint == null) continue;
            this.updateOdaColumnHint(columnDefn, hint);
        }
        if (odaSetDefn != null) {
            odaSetDefn.setResultSetColumns(odaSetColumns);
        }
        return odaSetDefn;
    }

    private static void createUniqueResultSetColumnNames(List columnInfo) {
        if (columnInfo == null || columnInfo.isEmpty()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < columnInfo.size()) {
            ResultSetColumnInfo tmpInfo = (ResultSetColumnInfo)columnInfo.get(i);
            OdaResultSetColumn column = tmpInfo.column;
            String nativeName = column.getNativeName();
            if (nativeName != null) {
                names.add(nativeName);
            }
            ++i;
        }
        HashSet newNames = new HashSet();
        int i2 = 0;
        while (i2 < columnInfo.size()) {
            ResultSetColumnInfo tmpInfo = (ResultSetColumnInfo)columnInfo.get(i2);
            OdaResultSetColumn column = tmpInfo.column;
            String nativeName = column.getNativeName();
            String name = column.getColumnName();
            if (StringUtil.isBlank((String)name)) {
                String newName = IdentifierUtility.getUniqueColumnName(names, newNames, nativeName, i2);
                column.setColumnName(newName);
                if (tmpInfo.hint != null) {
                    tmpInfo.hint.setProperty("columnName", (Object)newName);
                }
            }
            ++i2;
        }
        names.clear();
        newNames.clear();
    }

    private void updateHintsForComputedColumn() {
        Iterator columns = this.setHandle.computedColumnsIterator();
        ArrayList<String> columnNames = new ArrayList<String>();
        while (columns.hasNext()) {
            ComputedColumnHandle tmpColumn = (ComputedColumnHandle)columns.next();
            columnNames.add(tmpColumn.getName());
        }
        int i = 0;
        while (i < columnNames.size()) {
            String columnName = (String)columnNames.get(i);
            ColumnHintHandle hintHandle = ResultSetsAdapter.findColumnHint(columnName, this.setDefinedColumnHints.iterator());
            if (hintHandle != null) {
                if (this.columnHintsForComputedColumns == null) {
                    this.columnHintsForComputedColumns = new ArrayList();
                }
                this.columnHintsForComputedColumns.add(hintHandle.getStructure().copy());
            }
            ++i;
        }
    }

    List getHintsForComputedColumn() {
        if (this.columnHintsForComputedColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.columnHintsForComputedColumns;
    }

    void updateOdaColumnHints() {
        ResultSetDefinition columnDefns = this.setDesign.getPrimaryResultSet();
        if (columnDefns == null) {
            return;
        }
        int i = 0;
        while (i < this.setDefinedColumnHints.size()) {
            ColumnDefinition odaColumn;
            ColumnHintHandle hint = (ColumnHintHandle)this.setDefinedColumnHints.get(i);
            OdaResultSetColumnHandle column = (OdaResultSetColumnHandle)ResultSetsAdapter.findColumn(hint.getColumnName(), this.setDefinedResults.iterator());
            if (column != null && (odaColumn = ResultSetsAdapter.findColumnDefinition(columnDefns.getResultSetColumns(), column.getNativeName(), column.getPosition())) != null) {
                this.updateOdaColumnHint(odaColumn, hint);
            }
            ++i;
        }
    }

    private void updateOdaColumnHint(ColumnDefinition columnDefn, ColumnHintHandle hint) {
        DataElementAttributes dataAttrs = columnDefn.getAttributes();
        String displayName = hint.getDisplayName();
        if (displayName != null) {
            DataElementUIHints uiHints = this.designFactory.createDataElementUIHints();
            uiHints.setDisplayName(displayName);
            dataAttrs.setUiHints(uiHints);
        } else {
            dataAttrs.setUiHints(null);
        }
        OutputElementAttributes outputAttrs = null;
        String helpText = hint.getHelpText();
        String format = hint.getFormat();
        if (helpText != null || format != null) {
            outputAttrs = this.designFactory.createOutputElementAttributes();
            outputAttrs.setHelpText(helpText);
            if (format != null) {
                ValueFormatHints formatHint = this.designFactory.createValueFormatHints();
                formatHint.setDisplayFormat(format);
                outputAttrs.setFormattingHints(formatHint);
            }
        }
        columnDefn.setUsageHints(outputAttrs);
    }

    static class ResultSetColumnInfo {
        private OdaResultSetColumn column;
        private ColumnHint hint;

        ResultSetColumnInfo(OdaResultSetColumn column, ColumnHint hint) {
            this.column = column;
            this.hint = hint;
        }

        static void updateResultSetColumnList(List infos, List columns, List hints) {
            if (infos == null || infos.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < infos.size()) {
                ResultSetColumnInfo info = (ResultSetColumnInfo)infos.get(i);
                if (columns != null) {
                    columns.add(info.column);
                }
                if (info.hint != null && hints != null) {
                    hints.add(info.hint);
                }
                ++i;
            }
        }
    }
}

