/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabCellConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class CrosstabCellHandle
extends AbstractCrosstabItemHandle
implements ICrosstabCellConstants,
ICrosstabConstants {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected CrosstabCellHandle(DesignElementHandle handle) {
        super(handle);
    }

    PropertyHandle getContentProperty() {
        return this.handle.getPropertyHandle("content");
    }

    public List getContents() {
        return Collections.unmodifiableList(this.getContentProperty().getContents());
    }

    public void addContent(DesignElementHandle content) throws SemanticException {
        PropertyHandle ph = this.getContentProperty();
        if (ph != null) {
            ph.add(content);
        }
    }

    public void addContent(DesignElementHandle content, int newPos) throws SemanticException {
        PropertyHandle ph = this.getContentProperty();
        if (ph != null) {
            ph.add(content, newPos);
        }
    }

    public DimensionHandle getWidth() {
        return this.handle.getDimensionProperty("width");
    }

    public DimensionHandle getHeight() {
        return this.handle.getDimensionProperty("height");
    }

    public List getPredefinedStyles() {
        AbstractCrosstabItemHandle container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> styles = new ArrayList<String>();
        if (container instanceof MeasureViewHandle) {
            String propName = this.handle.getContainerPropertyHandle().getDefn().getName();
            if ("detail".equals(propName) || "aggregations".equals(propName)) {
                styles.add("crosstab-detail");
            } else {
                styles.add("crosstab-header");
            }
        } else {
            styles.add("crosstab-header");
        }
        return styles;
    }

    public Object getProperty(String propName) {
        Object value;
        IElementPropertyDefn defn = this.handle.getPropertyDefn(propName);
        if (defn == null) {
            return null;
        }
        if (!$assertionsDisabled && !((ElementPropertyDefn)defn).isStyleProperty()) {
            throw new AssertionError();
        }
        FactoryPropertyHandle factoryHandle = this.handle.getFactoryPropertyHandle(propName);
        Object object = value = factoryHandle == null ? null : factoryHandle.getValue();
        if (value != null) {
            return value;
        }
        DesignElementHandle crosstab = this.getCrosstabHandle();
        return crosstab == null ? null : crosstab.getProperty(propName);
    }

    public void setProperty(String propName, Object value) {
        ElementPropertyDefn defn = (ElementPropertyDefn)this.handle.getPropertyDefn(propName);
        if (defn != null && defn.isStyleProperty() && defn.canInherit()) {
            PropertyRecord record = new PropertyRecord(this.handle.getElement(), defn, value);
            record.setEventTarget(null);
            this.getCommandStack().execute((IActivityRecord)record);
        }
    }
}

