/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class AbstractCrosstabModelTask
implements ICrosstabConstants {
    protected CrosstabReportItemHandle crosstab = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AbstractCrosstabModelTask(AbstractCrosstabItemHandle focus) {
        if (focus == null) {
            throw new IllegalArgumentException("The focus for the task can not be null");
        }
        this.crosstab = focus.getCrosstab();
    }

    protected AggregationInfo getAggregationInfo(LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) {
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (leftLevelView == null) {
            if (rightLevelView != null) {
                if (rightLevelView.getCrosstab() != this.crosstab || rightLevelView.getCubeLevelName() == null || rightLevelView.getCubeLevelName().length() == 0) {
                    return null;
                }
                int axisType = rightLevelView.getAxisType();
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    colLevel = rightLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = rightLevelView.getCubeLevelName();
                }
            }
        } else {
            if (leftLevelView.getCrosstab() != this.crosstab || leftLevelView.getCubeLevelName() == null || leftLevelView.getCubeLevelName().length() == 0) {
                return null;
            }
            if (rightLevelView == null) {
                int axisType = leftLevelView.getAxisType();
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    colLevel = leftLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = leftLevelView.getCubeLevelName();
                }
            } else {
                if (rightLevelView.getCrosstab() != this.crosstab || rightLevelView.getCubeLevelName() == null || rightLevelView.getCubeLevelName().length() == 0) {
                    return null;
                }
                int axisType = leftLevelView.getAxisType();
                if (rightLevelView.getAxisType() != CrosstabModelUtil.getOppositeAxisType(axisType)) {
                    return null;
                }
                if (axisType == 1) {
                    colDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    colLevel = leftLevelView.getCubeLevelName();
                    rowDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = rightLevelView.getCubeLevelName();
                } else {
                    rowDimension = ((DimensionViewHandle)leftLevelView.getContainer()).getCubeDimensionName();
                    rowLevel = leftLevelView.getCubeLevelName();
                    colDimension = ((DimensionViewHandle)rightLevelView.getContainer()).getCubeDimensionName();
                    colLevel = rightLevelView.getCubeLevelName();
                }
            }
        }
        return new AggregationInfo(rowDimension, rowLevel, colDimension, colLevel);
    }

    protected boolean isValidParameters(List functions, List measures) {
        if (functions == null || measures == null) {
            return false;
        }
        if (measures.size() == 0 || functions.size() == 0) {
            return false;
        }
        return measures.size() == functions.size();
    }

    protected void verifyTotalMeasureFunctions(int axisType, List functions, List measures) {
        if (functions == null || measures == null || functions.size() == 0 || measures.size() == 0) {
            return;
        }
        boolean isVerticalMeasure = "vertical".equals(this.crosstab.getMeasureDirection());
        if (isVerticalMeasure && axisType == 1 || !isVerticalMeasure && axisType == 0) {
            String defaultFunction = (String)functions.get(0);
            int i = 0;
            while (i < this.crosstab.getMeasureCount()) {
                MeasureViewHandle mv = this.crosstab.getMeasure(i);
                if (!measures.contains(mv)) {
                    measures.add(mv);
                    functions.add(defaultFunction);
                }
                ++i;
            }
        }
    }

    protected void addMeasureAggregations(LevelViewHandle theLevelView, List measureList, List functionList, boolean checkCounterAxis) throws SemanticException {
        if (this.crosstab == null || theLevelView.getCrosstab() != this.crosstab) {
            return;
        }
        if (measureList == null || measureList.isEmpty()) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(theLevelView.getAxisType());
        String dimensionName = ((DimensionViewHandle)theLevelView.getContainer()).getCubeDimensionName();
        String levelName = theLevelView.getCubeLevelName();
        if (levelName == null || dimensionName == null) {
            return;
        }
        boolean isInnerMost = theLevelView.isInnerMost();
        boolean isCounterAxisEmpty = true;
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                isCounterAxisEmpty = false;
                LevelViewHandle levelView = dimensionView.getLevel(level);
                String rowDimension = null;
                String rowLevel = null;
                String colDimension = null;
                String colLevel = null;
                if (counterAxisType == 0) {
                    rowDimension = dimensionView.getCubeDimensionName();
                    rowLevel = levelView.getCubeLevelName();
                    colDimension = dimensionName;
                    colLevel = levelName;
                } else if (counterAxisType == 1) {
                    rowDimension = dimensionName;
                    rowLevel = levelName;
                    colDimension = dimensionView.getCubeDimensionName();
                    colLevel = levelView.getCubeLevelName();
                }
                if (isInnerMost && !levelView.isInnerMost() && levelView.getAggregationHeader() != null || !isInnerMost && theLevelView.getAggregationHeader() != null && (levelView.isInnerMost() || levelView.getAggregationHeader() != null)) {
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                        if (measureView.getCrosstab() == this.crosstab) {
                            String function;
                            String string = function = functionList == null ? "sum" : (String)functionList.get(i);
                            if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, levelView.getCubeLevelName(), counterAxisType)) {
                                CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                            }
                        }
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || isCounterAxisEmpty && theLevelView.getAggregationHeader() != null) {
            String rowDimension = null;
            String rowLevel = null;
            String colDimension = null;
            String colLevel = null;
            if (counterAxisType == 0) {
                colDimension = dimensionName;
                colLevel = levelName;
            } else if (counterAxisType == 1) {
                rowDimension = dimensionName;
                rowLevel = levelName;
            }
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                if (measureView.getCrosstab() == this.crosstab) {
                    String function;
                    String string = function = functionList == null ? "sum" : (String)functionList.get(i);
                    if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, null, counterAxisType)) {
                        CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                    }
                }
                ++i;
            }
        }
    }

    protected void addMeasureAggregations(int axisType, List measureList, List functionList, boolean checkCounterAxis) throws SemanticException {
        if (this.crosstab == null || measureList == null || measureList.isEmpty() || this.crosstab.getGrandTotal(axisType) == null) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        String dimensionName = null;
        String levelName = null;
        boolean isCounterAxisEmpty = true;
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle dimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < dimensionView.getLevelCount()) {
                isCounterAxisEmpty = false;
                LevelViewHandle levelView = dimensionView.getLevel(level);
                String rowDimension = null;
                String rowLevel = null;
                String colDimension = null;
                String colLevel = null;
                if (counterAxisType == 0) {
                    rowDimension = dimensionView.getCubeDimensionName();
                    rowLevel = levelView.getCubeLevelName();
                    colDimension = dimensionName;
                    colLevel = levelName;
                } else if (counterAxisType == 1) {
                    rowDimension = dimensionName;
                    rowLevel = levelName;
                    colDimension = dimensionView.getCubeDimensionName();
                    colLevel = levelView.getCubeLevelName();
                }
                if (levelView.isInnerMost() || levelView.getAggregationHeader() != null) {
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                        if (measureView.getCrosstab() == this.crosstab) {
                            String function;
                            String string = function = functionList == null ? "sum" : (String)functionList.get(i);
                            if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, levelView.getCubeLevelName(), counterAxisType)) {
                                CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                            }
                        }
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || isCounterAxisEmpty) {
            String rowDimension = null;
            String rowLevel = null;
            String colDimension = null;
            String colLevel = null;
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                if (measureView.getCrosstab() == this.crosstab) {
                    String function;
                    String string = function = functionList == null ? "sum" : (String)functionList.get(i);
                    if (!checkCounterAxis || CrosstabModelUtil.isAggregationOn(measureView, null, counterAxisType)) {
                        CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
                    }
                }
                ++i;
            }
        }
    }

    protected void removeMeasureAggregations(LevelViewHandle levelView) throws SemanticException {
        if (levelView == null || levelView.getCrosstab() != this.crosstab) {
            return;
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (dimensionName == null || levelName == null) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(dimensionName, levelName, levelView.getAxisType(), i);
            ++i;
        }
    }

    protected void removeMeasureAggregations(LevelViewHandle levelView, int measureIndex) throws SemanticException {
        if (levelView == null || levelView.getCrosstab() != this.crosstab) {
            return;
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (dimensionName == null || levelName == null) {
            return;
        }
        if (measureIndex >= 0 && measureIndex < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(dimensionName, levelName, levelView.getAxisType(), measureIndex);
        }
    }

    protected void removeMeasureAggregations(int axisType) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return;
        }
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(null, null, axisType, i);
            ++i;
        }
    }

    protected void removeMeasureAggregations(int axisType, int measureIndex) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return;
        }
        if (measureIndex >= 0 && measureIndex < this.crosstab.getMeasureCount()) {
            this.removeMeasureAggregations(null, null, axisType, measureIndex);
        }
    }

    private void removeMeasureAggregations(String dimensionName, String levelName, int axisType, int measureIndex) throws SemanticException {
        ArrayList<AggregationCellHandle> dropList = new ArrayList<AggregationCellHandle>();
        MeasureViewHandle measureView = this.crosstab.getMeasure(measureIndex);
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            AggregationCellHandle aggregationCell = measureView.getAggregationCell(j);
            String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
            String value = aggregationCell.getModelHandle().getStringProperty(propName);
            if (value == null && levelName == null || value != null && value.equals(levelName)) {
                dropList.add(aggregationCell);
            }
            ++j;
        }
        int i = 0;
        while (i < dropList.size()) {
            ((AggregationCellHandle)dropList.get(i)).getModelHandle().drop();
            ++i;
        }
    }

    protected boolean isAggregationDefined(MeasureViewHandle measureView, LevelViewHandle levelView, int axisType, List counterAggregationLevels) {
        if (measureView != null) {
            int totalDimensions;
            boolean isInnerMost;
            String checkDimensionName = null;
            String checkLevelName = null;
            if (levelView != null) {
                checkDimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
                checkLevelName = levelView.getCubeLevelName();
            }
            int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
            boolean bl = isInnerMost = levelView != null ? levelView.isInnerMost() : false;
            if (isInnerMost) {
                if (counterAggregationLevels.size() > 0) {
                    return true;
                }
                if (this.crosstab.getGrandTotal(counterAxisType) != null) {
                    return true;
                }
            }
            if ((totalDimensions = this.crosstab.getDimensionCount(counterAxisType)) > 0) {
                int i = 0;
                while (i < totalDimensions) {
                    DimensionViewHandle dv = this.crosstab.getDimension(counterAxisType, i);
                    int totalLevels = dv.getLevelCount();
                    int j = 0;
                    while (j < totalLevels) {
                        LevelViewHandle lv = dv.getLevel(j);
                        if (i == totalDimensions - 1 && j == totalLevels - 1 || lv.getAggregationHeader() != null) {
                            AggregationCellHandle cell = null;
                            cell = axisType == 0 ? measureView.getAggregationCell(checkDimensionName, checkLevelName, dv.getCubeDimensionName(), lv.getCubeLevelName()) : measureView.getAggregationCell(dv.getCubeDimensionName(), lv.getCubeLevelName(), checkDimensionName, checkLevelName);
                            if (cell != null) {
                                return true;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (totalDimensions == 0 || this.crosstab.getGrandTotal(counterAxisType) != null) {
                AggregationCellHandle cell = null;
                cell = axisType == 0 ? measureView.getAggregationCell(checkDimensionName, checkLevelName, null, null) : measureView.getAggregationCell(null, null, checkDimensionName, checkLevelName);
                if (cell != null) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void validateMeasure(MeasureViewHandle measureView, LevelViewHandle toValidateLevelView, int toValidateAxisType, List aggregationLevels) throws SemanticException {
        if (measureView == null || aggregationLevels == null || toValidateLevelView != null && measureView.getCrosstab() != toValidateLevelView.getCrosstab()) {
            return;
        }
        if (toValidateLevelView != null && toValidateLevelView.getCubeLevelName() == null) {
            return;
        }
        if (toValidateLevelView != null && toValidateAxisType != toValidateLevelView.getAxisType()) {
            return;
        }
        boolean isInnerMost = toValidateLevelView == null ? false : toValidateLevelView.isInnerMost();
        ArrayList<LevelViewHandle> unAggregationLevels = new ArrayList<LevelViewHandle>();
        int unAggregationCount = 0;
        boolean hasOldAggregation = this.isAggregationDefined(measureView, toValidateLevelView, toValidateAxisType, aggregationLevels);
        int toValidataDimCount = this.crosstab.getDimensionCount(toValidateAxisType);
        if (aggregationLevels.size() > 0 && hasOldAggregation) {
            int i = 0;
            while (i < aggregationLevels.size()) {
                LevelViewHandle levelView = (LevelViewHandle)aggregationLevels.get(i);
                if (isInnerMost) {
                    if (!levelView.isInnerMost()) {
                        if (!$assertionsDisabled && levelView.getAggregationHeader() == null) {
                            throw new AssertionError();
                        }
                        if (this.getAggregation(measureView, toValidateLevelView, levelView) == null) {
                            unAggregationLevels.add(levelView);
                            ++unAggregationCount;
                        }
                    }
                } else if (!(toValidataDimCount <= 0 && levelView.isInnerMost() || this.getAggregation(measureView, toValidateLevelView, levelView) != null)) {
                    unAggregationLevels.add(levelView);
                    ++unAggregationCount;
                }
                ++i;
            }
        }
        int maxAggregationCount = aggregationLevels.size();
        if (hasOldAggregation && (maxAggregationCount == 0 || this.crosstab.getGrandTotal(CrosstabModelUtil.getOppositeAxisType(toValidateAxisType)) != null) && this.getAggregation(measureView, toValidateLevelView, null) == null) {
            ++maxAggregationCount;
            ++unAggregationCount;
        }
        if (unAggregationCount > 0) {
            int i = 0;
            while (i < unAggregationLevels.size() && unAggregationCount > 0) {
                LevelViewHandle levelView = (LevelViewHandle)unAggregationLevels.get(i);
                String function = this.getAggregationFunction(measureView, levelView, CrosstabModelUtil.getOppositeAxisType(toValidateAxisType), toValidateLevelView, toValidateAxisType);
                this.addAggregation(measureView, toValidateLevelView, levelView, function);
                --unAggregationCount;
                ++i;
            }
            if (unAggregationCount != 0) {
                String function = this.getAggregationFunction(measureView, null, CrosstabModelUtil.getOppositeAxisType(toValidateAxisType), toValidateLevelView, toValidateAxisType);
                this.addAggregation(measureView, toValidateLevelView, null, function);
            }
        }
    }

    private AggregationCellHandle getAggregation(MeasureViewHandle measureView, LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return null;
        }
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        if (infor == null) {
            return null;
        }
        return measureView.getAggregationCell(infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
    }

    private void addAggregation(MeasureViewHandle measureView, LevelViewHandle leftLevelView, LevelViewHandle rightLevelView, String function) throws SemanticException {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return;
        }
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        if (infor == null) {
            return;
        }
        CrosstabModelUtil.addDataItem(measureView.getCrosstab(), measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
    }

    private String getAggregationFunction(MeasureViewHandle measureView, LevelViewHandle leftLevelView, int leftAxisType, LevelViewHandle rightLevelView, int rightAxisType) {
        if (measureView == null || measureView.getCrosstab() != this.crosstab) {
            return null;
        }
        if (!CrosstabModelUtil.isValidAxisType(leftAxisType) || !CrosstabModelUtil.isValidAxisType(rightAxisType)) {
            return null;
        }
        if (leftAxisType != CrosstabModelUtil.getOppositeAxisType(rightAxisType)) {
            return null;
        }
        if (1 == leftAxisType) {
            String function = null;
            function = this.getAggregationFunction(measureView, leftLevelView, leftAxisType);
            if (function != null) {
                return function;
            }
            return this.getAggregationFunction(measureView, rightLevelView, rightAxisType);
        }
        String function = null;
        function = this.getAggregationFunction(measureView, rightLevelView, rightAxisType);
        if (function != null) {
            return function;
        }
        return this.getAggregationFunction(measureView, leftLevelView, leftAxisType);
    }

    private String getAggregationFunction(MeasureViewHandle measureView, LevelViewHandle levelView, int axisType) {
        if (levelView == null) {
            return this.crosstab.getAggregationFunction(axisType, measureView);
        }
        return levelView.getAggregationFunction(measureView);
    }

    protected void removeMeasureAggregation(LevelViewHandle leftLevelView, LevelViewHandle rightLevelView) throws SemanticException {
        AggregationInfo infor = this.getAggregationInfo(leftLevelView, rightLevelView);
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            measureView.removeAggregation(infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
            ++i;
        }
    }

    public void validateCrosstab() throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        String measureDirection = this.crosstab.getMeasureDirection();
        int axisType = 1;
        axisType = "horizontal".equals(measureDirection) ? 1 : 0;
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        List counterAxisAggregationLevels = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, counterAxisType);
        List toValidateLevelViews = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, axisType);
        int count = toValidateLevelViews.size();
        int i = 0;
        while (i < count) {
            LevelViewHandle levelView = (LevelViewHandle)toValidateLevelViews.get(i);
            if (!$assertionsDisabled && !levelView.isInnerMost() && levelView.getAggregationHeader() == null) {
                throw new AssertionError();
            }
            int j = 0;
            while (j < this.crosstab.getMeasureCount()) {
                MeasureViewHandle measureView = this.crosstab.getMeasure(j);
                this.validateMeasure(measureView, levelView, axisType, counterAxisAggregationLevels);
                ++j;
            }
            ++i;
        }
        if (this.crosstab.getGrandTotal(axisType) != null || this.crosstab.getDimensionCount(axisType) == 0) {
            int j = 0;
            while (j < this.crosstab.getMeasureCount()) {
                MeasureViewHandle measureView = this.crosstab.getMeasure(j);
                this.validateMeasure(measureView, null, axisType, counterAxisAggregationLevels);
                ++j;
            }
        }
    }

    class AggregationInfo {
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;

        public AggregationInfo(String rowDimension, String rowLevel, String colDimension, String colLevel) {
            this.rowDimension = rowDimension;
            this.rowLevel = rowLevel;
            this.colDimension = colDimension;
            this.colLevel = colLevel;
        }

        public String getRowDimension() {
            return this.rowDimension;
        }

        public String getRowLevel() {
            return this.rowLevel;
        }

        public String getColDimension() {
            return this.colDimension;
        }

        public String getColLevel() {
            return this.colLevel;
        }
    }
}

