/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEdgeColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnTotalColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GrandTotalColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.IColumnWalker;
import org.eclipse.birt.report.item.crosstab.core.re.executor.MeasureColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.MeasureHeaderColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.RowEdgeColumnEvent;

class ColumnWalker
implements ICrosstabConstants,
IColumnWalker {
    private static final int STATE_INIT = 0;
    private static final int STATE_ROW_EDGE = 1;
    private static final int STATE_MEASURE_HEADER = 2;
    private static final int STATE_COLUMN_TOTAL_BEFORE = 3;
    private static final int STATE_COLUMN_TOTAL_AFTER = 4;
    private static final int STATE_COLUMN_EDGE = 5;
    private static final int STATE_GRAND_TOTAL = 6;
    private static final int STATE_MEASURE = 7;
    private static final int STATE_END = 10;
    private CrosstabReportItemHandle crosstabItem;
    private EdgeCursor columnEdgeCursor;
    private final List rowGroups;
    private final List columnGroups;
    private final int mCount;
    private final boolean isVerticalMeasure;
    private final boolean isHideMeasureHeader;
    private int currentState;
    private int dimensionIndex;
    private int levelIndex;
    private int measureIndex;
    private int groupIndex;
    private int tmpStartGroupIndex;
    private int tmpEndGroupIndex;
    private List columnDimensionCursors;
    private boolean hasNext;
    private boolean columnProcessed;
    private final int lastColumnGroupIndex;

    ColumnWalker(CrosstabReportItemHandle item, EdgeCursor columnEdgeCursor) {
        this.crosstabItem = item;
        this.columnEdgeCursor = columnEdgeCursor;
        this.rowGroups = GroupUtil.getGroups(this.crosstabItem, 0);
        this.columnGroups = GroupUtil.getGroups(this.crosstabItem, 1);
        this.mCount = this.crosstabItem.getMeasureCount();
        this.isVerticalMeasure = "vertical".equals(this.crosstabItem.getMeasureDirection());
        this.isHideMeasureHeader = this.crosstabItem.isHideMeasureHeader();
        this.groupIndex = 0;
        this.measureIndex = -1;
        this.lastColumnGroupIndex = this.columnGroups.size() - 1;
        this.currentState = 0;
    }

    public void reload() {
        this.groupIndex = 0;
        this.measureIndex = -1;
        this.currentState = 0;
    }

    public boolean hasNext() throws OLAPException {
        if (this.currentState == 0) {
            this.advance();
        }
        return this.currentState != 10;
    }

    private void advance() throws OLAPException {
        switch (this.currentState) {
            case 0: 
            case 1: {
                int i;
                if (this.rowGroups.size() > 0) {
                    i = this.groupIndex++;
                    if (i < this.rowGroups.size()) {
                        EdgeGroup group = (EdgeGroup)this.rowGroups.get(i);
                        this.dimensionIndex = group.dimensionIndex;
                        this.levelIndex = group.levelIndex;
                        this.currentState = 1;
                        return;
                    }
                }
                if (this.mCount > 0 && this.isVerticalMeasure && !this.isHideMeasureHeader) {
                    i = 0;
                    while (i < this.mCount) {
                        MeasureViewHandle mv = this.crosstabItem.getMeasure(i);
                        if (mv.getHeader() != null) {
                            this.currentState = 2;
                            return;
                        }
                        ++i;
                    }
                }
            }
            case 2: {
                if (this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    this.columnDimensionCursors = this.columnEdgeCursor.getDimensionCursor();
                    this.columnEdgeCursor.beforeFirst();
                    this.hasNext = this.columnEdgeCursor.next();
                    this.columnProcessed = false;
                    this.groupIndex = 0;
                    this.measureIndex = -1;
                    this.tmpStartGroupIndex = 0;
                    this.tmpEndGroupIndex = this.lastColumnGroupIndex;
                }
            }
            case 3: 
            case 4: 
            case 5: {
                int i;
                if (this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    while (this.hasNext) {
                        int m;
                        LevelViewHandle lv;
                        DimensionCursor dc;
                        EdgeGroup group;
                        if (this.mCount > 0) {
                            i = this.tmpStartGroupIndex;
                            while (i < this.columnGroups.size()) {
                                group = (EdgeGroup)this.columnGroups.get(i);
                                if (!GroupUtil.isLeafGroup(this.columnDimensionCursors, i) && (dc = (DimensionCursor)this.columnDimensionCursors.get(i)).getEdgeStart() == this.columnEdgeCursor.getPosition() && (lv = this.crosstabItem.getDimension(1, group.dimensionIndex).getLevel(group.levelIndex)).getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation())) {
                                    if (this.mCount > 0 && !this.isVerticalMeasure) {
                                        m = this.measureIndex + 1;
                                        while (m < this.mCount) {
                                            if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, m)) {
                                                this.tmpStartGroupIndex = i;
                                                this.dimensionIndex = group.dimensionIndex;
                                                this.levelIndex = group.levelIndex;
                                                this.measureIndex = m;
                                                this.currentState = 3;
                                                return;
                                            }
                                            ++m;
                                        }
                                        this.measureIndex = -1;
                                    } else if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, -1)) {
                                        this.tmpStartGroupIndex = i + 1;
                                        this.dimensionIndex = group.dimensionIndex;
                                        this.levelIndex = group.levelIndex;
                                        this.currentState = 3;
                                        return;
                                    }
                                }
                                ++i;
                            }
                            this.tmpStartGroupIndex = this.columnGroups.size();
                        }
                        if (this.currentState != 5 && this.currentState != 4) {
                            this.measureIndex = -1;
                        }
                        if (!this.columnProcessed) {
                            if (this.mCount > 0 && !this.isVerticalMeasure) {
                                int m2 = this.measureIndex + 1;
                                if (m2 < this.mCount) {
                                    this.measureIndex = m2;
                                    this.currentState = 5;
                                    return;
                                }
                            } else if (this.measureIndex == -1) {
                                --this.measureIndex;
                                this.currentState = 5;
                                return;
                            }
                            this.columnProcessed = true;
                        }
                        if (this.mCount > 0) {
                            if (this.currentState != 4) {
                                this.measureIndex = -1;
                            }
                            i = this.tmpEndGroupIndex;
                            while (i >= 0) {
                                group = (EdgeGroup)this.columnGroups.get(i);
                                if (!GroupUtil.isLeafGroup(this.columnDimensionCursors, i) && (dc = (DimensionCursor)this.columnDimensionCursors.get(i)).getEdgeEnd() == this.columnEdgeCursor.getPosition() && (lv = this.crosstabItem.getDimension(1, group.dimensionIndex).getLevel(group.levelIndex)).getAggregationHeader() != null && "after".equals(lv.getAggregationHeaderLocation())) {
                                    if (this.mCount > 0 && !this.isVerticalMeasure) {
                                        m = this.measureIndex + 1;
                                        while (m < this.mCount) {
                                            if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, m)) {
                                                this.tmpEndGroupIndex = i;
                                                this.dimensionIndex = group.dimensionIndex;
                                                this.levelIndex = group.levelIndex;
                                                this.measureIndex = m;
                                                this.currentState = 4;
                                                return;
                                            }
                                            ++m;
                                        }
                                        this.measureIndex = -1;
                                    } else if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, -1)) {
                                        this.tmpEndGroupIndex = i - 1;
                                        this.dimensionIndex = group.dimensionIndex;
                                        this.levelIndex = group.levelIndex;
                                        this.currentState = 4;
                                        return;
                                    }
                                }
                                --i;
                            }
                        }
                        this.hasNext = this.columnEdgeCursor.next();
                        this.columnProcessed = false;
                        this.tmpStartGroupIndex = 0;
                        this.tmpEndGroupIndex = this.lastColumnGroupIndex;
                        this.measureIndex = -1;
                    }
                }
                this.measureIndex = -1;
            }
            case 6: {
                int i;
                if (this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    if (this.crosstabItem.getGrandTotal(1) != null && this.mCount > 0) {
                        if (this.mCount > 0 && !this.isVerticalMeasure) {
                            i = this.measureIndex + 1;
                            while (i < this.mCount) {
                                if (GroupUtil.hasTotalContent(this.crosstabItem, 1, -1, -1, i)) {
                                    this.measureIndex = i;
                                    this.currentState = 6;
                                    return;
                                }
                                ++i;
                            }
                        } else if (this.currentState != 6 && GroupUtil.hasTotalContent(this.crosstabItem, 1, -1, -1, -1)) {
                            this.currentState = 6;
                            return;
                        }
                    }
                    this.currentState = 10;
                    return;
                }
            }
            case 7: {
                int i;
                if (!this.isVerticalMeasure) {
                    i = this.measureIndex + 1;
                    if (i < this.mCount) {
                        this.measureIndex = i;
                        this.currentState = 7;
                        return;
                    }
                } else if (this.measureIndex == -1) {
                    --this.measureIndex;
                    this.currentState = 7;
                    return;
                }
                this.currentState = 10;
                return;
            }
        }
    }

    public ColumnEvent next() throws OLAPException {
        ColumnEvent evt = null;
        int mx = this.measureIndex < 0 ? -1 : this.measureIndex;
        switch (this.currentState) {
            case 0: {
                break;
            }
            case 1: {
                evt = new RowEdgeColumnEvent(this.dimensionIndex, this.levelIndex);
                break;
            }
            case 2: {
                evt = new MeasureHeaderColumnEvent();
                break;
            }
            case 3: {
                evt = new ColumnTotalColumnEvent(true, this.dimensionIndex, this.levelIndex, mx);
                break;
            }
            case 4: {
                evt = new ColumnTotalColumnEvent(false, this.dimensionIndex, this.levelIndex, mx);
                break;
            }
            case 5: {
                evt = new ColumnEdgeColumnEvent(mx);
                break;
            }
            case 6: {
                evt = new GrandTotalColumnEvent(mx);
                break;
            }
            case 7: {
                evt = new MeasureColumnEvent(mx);
                break;
            }
        }
        if (this.columnEdgeCursor != null) {
            evt.dataPosition = this.columnEdgeCursor.getPosition();
        }
        this.advance();
        return evt;
    }
}

