/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;

class DataAccessClassLoader
extends URLClassLoader {
    private static final Pattern sm_odaInterfacesPattern = Pattern.compile("org\\.eclipse\\.birt\\.data\\.oda\\.[a-zA-Z]+");
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.DataAccessClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    DataAccessClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
        sm_logger.exiting(sm_className, "DataAccessClassLoader", this);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String methodName = "findClass";
        sm_logger.entering(sm_className, methodName, name);
        Matcher matcher = sm_odaInterfacesPattern.matcher(name);
        if (matcher.matches()) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        Class<?> foundClass = super.findClass(name);
        sm_logger.exiting(sm_className, methodName, foundClass);
        return foundClass;
    }
}

