/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.AggregationAccessor;
import org.eclipse.birt.data.engine.olap.cursor.EdgeCursorImpl;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;

public class CubeCursorImpl
extends AbstractCursorSupport
implements CubeCursor {
    private List ordinateEdge = new ArrayList();
    private List pageEdge = new ArrayList();

    public CubeCursorImpl(BirtCubeView cubeView, IResultSet result, Map relationMap, MeasureNameManager manager) throws OLAPException {
        this(cubeView, result, relationMap, manager, null);
    }

    public CubeCursorImpl(BirtCubeView cubeView, IResultSet result, Map relationMap, MeasureNameManager manager, Map appContext) throws OLAPException {
        super(null, new AggregationAccessor(cubeView, result, relationMap, manager));
        if (result == null) {
            return;
        }
        EdgeAxis[] calculatedMemberAxis = result.getMeasureResult();
        BirtEdgeView[] calculatedMemberView = cubeView.getMeasureEdgeView();
        if (calculatedMemberAxis != null) {
            int i = 0;
            while (i < calculatedMemberAxis.length) {
                this.pageEdge.add(new EdgeCursorImpl(calculatedMemberView[i], true, calculatedMemberAxis[i], this));
                ++i;
            }
        }
        if (cubeView.getColumnEdgeView() != null) {
            EdgeCursorImpl columnEdgeCursor = new EdgeCursorImpl(cubeView.getColumnEdgeView(), false, result.getColumnEdgeResult(), this);
            if (appContext != null) {
                columnEdgeCursor.setFetchSize(this.populateFetchLimitSize(appContext.get("org.eclipse.birt.data.engine.olap.cursor.onColumn")));
            }
            result.getColumnEdgeResult().populateEdgeInfo();
            this.ordinateEdge.add(columnEdgeCursor);
        }
        if (cubeView.getRowEdgeView() != null) {
            EdgeCursorImpl rowEdgeCursor = new EdgeCursorImpl(cubeView.getRowEdgeView(), false, result.getRowEdgeResult(), this);
            if (appContext != null) {
                rowEdgeCursor.setFetchSize(this.populateFetchLimitSize(appContext.get("org.eclipse.birt.data.engine.olap.cursor.onRow")));
            }
            result.getRowEdgeResult().populateEdgeInfo();
            this.ordinateEdge.add(rowEdgeCursor);
        }
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.ordinateEdge;
    }

    public Collection getPageEdge() throws OLAPException {
        return this.pageEdge;
    }

    public void synchronizePages() throws OLAPException {
    }

    private int populateFetchLimitSize(Object propValue) {
        String fetchLimitSize;
        int fetchLimit = -1;
        String string = fetchLimitSize = propValue == null ? "-1" : propValue.toString();
        if (fetchLimitSize != null) {
            fetchLimit = Integer.parseInt(fetchLimitSize);
        }
        return fetchLimit;
    }
}

