/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKey;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

class DimensionPositionSeeker {
    private IDiskArray diskMemberArray;
    private DimensionKey[] memberArray;
    private int diskPostion;
    private int position;

    DimensionPositionSeeker(IDiskArray member) throws IOException {
        IDiskArray members = this.getSortedDimensionKeys(member);
        this.memberArray = new DimensionKey[Math.min(4000, members.size())];
        int i = 0;
        while (i < this.memberArray.length) {
            this.memberArray[i] = (DimensionKey)members.get(i);
            ++i;
        }
        if (members.size() > 4000) {
            this.diskMemberArray = members;
            this.position = this.diskPostion = this.memberArray.length;
        }
    }

    private IDiskArray getSortedDimensionKeys(IDiskArray members) throws IOException {
        DiskSortedStack sortedStack = new DiskSortedStack(40000, true, false, DimensionKey.getCreator());
        int i = 0;
        while (i < members.size()) {
            sortedStack.push(members.get(i));
            ++i;
        }
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionKey.getCreator(), 4000);
        Object key = sortedStack.pop();
        while (key != null) {
            resultArray.add(key);
            key = sortedStack.pop();
        }
        return resultArray;
    }

    int find(DimensionKey key) throws IOException {
        int result = this.binarySearch(key);
        if (result >= 0) {
            return result;
        }
        if (this.diskMemberArray != null) {
            return this.traverseFind(key);
        }
        return result;
    }

    private int binarySearch(DimensionKey key) {
        int result = Arrays.binarySearch(this.memberArray, key);
        if (result >= 0) {
            return this.memberArray[result].getDimensionPos();
        }
        return -1;
    }

    private int traverseFind(DimensionKey key) throws IOException {
        int i = this.position;
        while (i < this.diskMemberArray.size()) {
            if (((DimensionKey)this.diskMemberArray.get(i)).compareTo(key) == 0) {
                this.position = i;
                return ((DimensionKey)this.diskMemberArray.get(i)).getDimensionPos();
            }
            ++i;
        }
        i = this.diskPostion;
        while (i < this.position) {
            if (((DimensionKey)this.diskMemberArray.get(i)).compareTo(key) == 0) {
                this.position = i;
                return ((DimensionKey)this.diskMemberArray.get(i)).getDimensionPos();
            }
            ++i;
        }
        return -1;
    }
}

