/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.DataExceptionMocker;
import org.eclipse.birt.data.engine.script.JSColumnMetaData;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSRowObject
extends ScriptableObject {
    private static final String DATA_SET = "dataSet";
    private static final String COLUMN_MD = "columnDefns";
    public static final String ROW_POSITION = "_rowPosition";
    private DataSetRuntime dataSet;
    private JSColumnMetaData cachedColumnMetaData;
    private static Logger logger;
    private static final long serialVersionUID = 6087456639367600994L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public JSRowObject(DataSetRuntime dataSet) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "JSRowObject");
        this.dataSet = dataSet;
    }

    public String getClassName() {
        return "DataRow";
    }

    public Object[] getIds() {
        IResultObject obj = this.dataSet.getCurrentRow();
        int columnCount = 0;
        if (obj != null) {
            columnCount = obj.getResultClass().getFieldCount();
        }
        int count = 4 + 2 * columnCount;
        int next = 0;
        Object[] ids = new Object[count];
        ids[next++] = DATA_SET;
        ids[next++] = COLUMN_MD;
        ids[next++] = new Integer(0);
        ids[next++] = ROW_POSITION;
        if (columnCount > 0) {
            int i = 1;
            while (i <= columnCount) {
                ids[next++] = new Integer(i);
                try {
                    ids[next++] = obj.getResultClass().getFieldName(i);
                }
                catch (DataException e) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    logger.logp(Level.FINER, clazz.getName(), "getIds", e.getMessage(), (Throwable)((Object)e));
                }
                ++i;
            }
        }
        return ids;
    }

    public boolean has(int index, Scriptable start) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "has", new Integer(index));
        IResultObject obj = this.dataSet.getCurrentRow();
        if (index >= 0 && obj != null && index <= obj.getResultClass().getFieldCount()) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz2.getName(), "has", new Boolean(true));
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz3.getName(), "has", new Boolean(super.has(index, start)));
        }
        return super.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "has", name);
        if (name.equals(DATA_SET) || name.endsWith(COLUMN_MD) || name.equals(ROW_POSITION)) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz2.getName(), "has", new Boolean(true));
            return true;
        }
        IResultObject obj = this.dataSet.getCurrentRow();
        if (obj != null && obj.getResultClass().getFieldIndex(name) >= 0) {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz3.getName(), "has", new Boolean(true));
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz4.getName(), "has", new Boolean(super.has(name, start)));
        }
        return super.has(name, start);
    }

    public Object get(int index, Scriptable start) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "get", new Integer(index));
        try {
            Object value = this.dataSet.getDataRow().getColumnValue(index);
            return JavascriptEvalUtil.convertToJavascriptValue((Object)value, (Scriptable)this.dataSet.getSharedScope());
        }
        catch (BirtException e) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINER, clazz2.getName(), "get", e.getMessage(), e);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz3.getName(), "get", null);
            return null;
        }
    }

    public Object get(String name, Scriptable start) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "get", name);
        if (name.equals(DATA_SET)) {
            if (logger.isLoggable(Level.FINER)) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.exiting(clazz2.getName(), "get");
            }
            return this.dataSet.getJSDataSetObject();
        }
        if (name.equals(COLUMN_MD)) {
            if (logger.isLoggable(Level.FINER)) {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.exiting(clazz3.getName(), "get", this.getColumnMetadataScriptable());
            }
            return this.getColumnMetadataScriptable();
        }
        if (name.equals(ROW_POSITION)) {
            try {
                return new Integer(this.dataSet.getCurrentRowIndex());
            }
            catch (DataException e) {
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.FINER, clazz4.getName(), "get", e.getMessage(), (Throwable)((Object)e));
            }
        }
        try {
            Object value = this.dataSet.getDataRow().getColumnValue(name);
            return JavascriptEvalUtil.convertToJavascriptValue((Object)value, (Scriptable)this.dataSet.getSharedScope());
        }
        catch (BirtException e) {
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINER, clazz5.getName(), "get", e.getMessage(), e);
            return new DataExceptionMocker(e);
        }
    }

    Scriptable getColumnMetadataScriptable() {
        IResultObject obj = this.dataSet.getCurrentRow();
        if (obj == null || obj.getResultClass() == null) {
            return null;
        }
        if (this.cachedColumnMetaData == null || this.cachedColumnMetaData.getResultClass() != obj.getResultClass()) {
            this.cachedColumnMetaData = new JSColumnMetaData(obj.getResultClass());
        }
        return this.cachedColumnMetaData;
    }

    public void put(String name, Scriptable start, Object value) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz2.getName(), "put", name);
        if (name.equals(DATA_SET) || name.equals(COLUMN_MD)) {
            return;
        }
        value = JavascriptEvalUtil.convertJavascriptValue((Object)value);
        try {
            this.dataSet.getDataRow().setColumnValue(name, value);
        }
        catch (BirtException e) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINER, clazz3.getName(), "put", e.getMessage(), e);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "put");
    }

    public void put(int index, Scriptable start, Object value) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz2.getName(), "put", new Integer(index));
        value = JavascriptEvalUtil.convertJavascriptValue((Object)value);
        try {
            this.dataSet.getDataRow().setColumnValue(index, value);
        }
        catch (BirtException e) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.birt.data.engine.script.JSColumnDefn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINER, clazz3.getName(), "put", e.getMessage(), e);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.script.JSRowObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "put");
    }
}

