/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;

public class Block
implements ArchiveConstants {
    int id;
    Block prev;
    Block next;
    final int blockSize;
    byte[] blockData;
    private int dataSize;
    private int dirtyStart;
    private int dirtyEnd;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.archive.compound.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    Block(int size) {
        this.blockSize = size;
        this.blockData = new byte[size];
        this.id = -1;
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
        this.dataSize = 0;
        this.prev = null;
        this.next = null;
    }

    void reset() {
        this.id = -1;
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
        this.dataSize = 0;
        this.prev = null;
        this.next = null;
    }

    public void refresh(RandomAccessFile rf) throws IOException {
        int size;
        this.dataSize = 0;
        if (this.id < 0 && !$assertionsDisabled) {
            throw new AssertionError();
        }
        rf.seek((long)this.id * (long)this.blockSize);
        while ((size = rf.read(this.blockData, this.dataSize, this.blockSize - this.dataSize)) >= 0) {
            this.dataSize += size;
            if (this.dataSize < this.blockSize) continue;
        }
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public void flush(RandomAccessFile file) throws IOException {
        if (this.dirtyEnd != this.dirtyStart) {
            file.seek((long)this.id * (long)this.blockSize + (long)this.dirtyStart);
            file.write(this.blockData, this.dirtyStart, this.dirtyEnd - this.dirtyStart);
        }
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public byte[] getData() {
        return this.blockData;
    }

    public int write(int tgt, byte[] b, int off, int len) throws IOException {
        int size = this.blockSize - tgt;
        if (size > len) {
            size = len;
        }
        System.arraycopy(b, off, this.blockData, tgt, size);
        if (this.dirtyStart > tgt) {
            this.dirtyStart = tgt;
        }
        if (this.dirtyEnd < tgt + size) {
            this.dirtyEnd = tgt + size;
        }
        if (this.dataSize < this.dirtyEnd) {
            this.dataSize = this.dirtyEnd;
        }
        return size;
    }

    public int read(int src, byte[] b, int off, int len) throws IOException {
        int size = this.dataSize - src;
        if (size > len) {
            size = len;
        }
        System.arraycopy(this.blockData, src, b, off, size);
        return size;
    }
}

