/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.List;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;

public final class LayoutHelper {
    private static void applyLayoutOnRow(LayoutSlot mappingSlot, TableRow row, Module module) {
        List cells = row.getContentsSlot();
        if (cells.size() == 0) {
            return;
        }
        LayoutRow mappingRow = mappingSlot.getCurrentLayoutRow();
        int i = 0;
        int startCol = 1;
        while (i < cells.size()) {
            Cell cell = (Cell)cells.get(i);
            int colSpan = cell.getColSpan(module);
            int definedColumn = cell.getColumn(module);
            startCol = definedColumn != 0 ? definedColumn : LayoutHelper.findFillInPosition(mappingRow, startCol, colSpan);
            mappingSlot.addCell(startCol, cell.getRowSpan(module), colSpan, cell, false);
            startCol += colSpan;
            ++i;
        }
    }

    private static int findFillInPosition(LayoutRow row, int startPos, int colSpan) {
        int startCol = 0;
        int i = startPos - 1;
        int interval = 0;
        while (i < row.getColumnCount()) {
            LayoutCell cell = row.getLayoutCell(i);
            interval = !cell.isUsed() ? ++interval : 0;
            if (interval > 0) {
                startCol = i + 1;
                break;
            }
            ++i;
        }
        if (startCol == 0) {
            startCol = row.getColumnCount() + 1;
            i = row.getColumnCount() - 1;
            while (i >= startPos - 1) {
                LayoutCell cell = row.getLayoutCell(i);
                if (cell.isUsed()) break;
                --startCol;
                --i;
            }
        }
        return startCol;
    }

    public static LayoutTable applyLayout(Module module, TableItem table) {
        LayoutSlot slot;
        ContainerSlot header;
        TableGroup group;
        LayoutTable mappingTable = new LayoutTable(table, module);
        LayoutHelper.applyLayoutOnSlot(mappingTable.getHeader(), table.getSlot(0), module);
        ContainerSlot groups = table.getSlot(1);
        int groupCount = groups.getCount();
        int groupIndex = 0;
        while (groupIndex < groupCount) {
            group = (TableGroup)groups.getContent(groupIndex);
            header = group.getSlot(0);
            slot = mappingTable.getGroupHeaders().addSlot(group.getGroupLevel(), mappingTable.getColumnCount());
            LayoutHelper.applyLayoutOnSlot(slot, header, module);
            ++groupIndex;
        }
        LayoutHelper.applyLayoutOnSlot(mappingTable.getDetail(), table.getSlot(2), module);
        groupIndex = groupCount - 1;
        while (groupIndex >= 0) {
            group = (TableGroup)groups.getContent(groupIndex);
            header = group.getSlot(1);
            slot = mappingTable.getGroupFooters().addSlot(group.getGroupLevel(), mappingTable.getColumnCount());
            LayoutHelper.applyLayoutOnSlot(slot, header, module);
            --groupIndex;
        }
        LayoutHelper.applyLayoutOnSlot(mappingTable.getFooter(), table.getSlot(3), module);
        return mappingTable;
    }

    protected static void applyLayoutOnSlot(LayoutSlot mappingSlot, ContainerSlot slot, Module module) {
        int rowIndex = 0;
        while (rowIndex < slot.getCount()) {
            TableRow row = (TableRow)slot.getContent(rowIndex);
            mappingSlot.newLayoutRow(row);
            LayoutHelper.applyLayoutOnRow(mappingSlot, row, module);
            ++rowIndex;
        }
    }
}

