/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class StructureContext {
    private Object dataContainer;
    private IPropertyDefn propDefn;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.StructureContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StructureContext(DesignElement element, String elementPropName) {
        this.dataContainer = element;
        this.propDefn = element.getPropertyDefn(elementPropName);
        if (this.propDefn == null) {
            throw new IllegalArgumentException();
        }
    }

    public StructureContext(IStructure struct, String memberName) {
        this.dataContainer = struct;
        this.propDefn = struct.getDefn().getMember(memberName);
        if (this.propDefn == null) {
            throw new IllegalArgumentException();
        }
    }

    public void add(Structure struct) {
        this.add(-1, struct);
    }

    public void add(int index, Structure struct) {
        ArrayList values = this.getLocalValue();
        if (this.propDefn.isList()) {
            if (values == null) {
                values = new ArrayList();
                this.setValue(values);
            }
            if (index == -1) {
                index = ((List)values).size();
            }
            ((List)values).add(index, struct);
        } else {
            if (!$assertionsDisabled && values != null) {
                throw new AssertionError();
            }
            this.setValue(struct);
        }
        struct.setContext(this);
    }

    public void remove(Structure struct) {
        Object values = this.getLocalValue();
        if (!$assertionsDisabled && values == null) {
            throw new AssertionError();
        }
        if (this.propDefn.isList()) {
            List list = (List)values;
            int index = list.indexOf(struct);
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError();
            }
            list.remove(index);
        } else {
            if (!$assertionsDisabled && values != struct) {
                throw new AssertionError();
            }
            this.setValue(null);
        }
        struct.setContext(null);
    }

    public void remove(int index) {
        Object values = this.getLocalValue();
        if (!$assertionsDisabled && values == null) {
            throw new AssertionError();
        }
        Structure struct = null;
        if (this.propDefn.isList()) {
            List list = (List)values;
            struct = (Structure)list.get(index);
            list.remove(index);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && struct == null) {
            throw new AssertionError();
        }
        struct.setContext(null);
    }

    private void setValue(Object values) {
        if (this.dataContainer instanceof DesignElement) {
            DesignElement tmpElement = (DesignElement)this.dataContainer;
            tmpElement.setProperty(this.propDefn.getName(), values);
        } else if (this.dataContainer instanceof Structure) {
            Structure tmpStruct = (Structure)this.dataContainer;
            tmpStruct.setProperty(this.propDefn.getName(), values);
        }
    }

    public Object getValueContainer() {
        return this.dataContainer;
    }

    public IPropertyDefn getPropDefn() {
        return this.propDefn;
    }

    public IPropertyDefn getElementProp() {
        StructureContext tmpContext = this;
        Object tmpValueContainer = tmpContext.getValueContainer();
        while (tmpValueContainer != null && !(tmpValueContainer instanceof DesignElement)) {
            tmpContext = ((Structure)tmpValueContainer).getContext();
            if (tmpContext == null) break;
            tmpValueContainer = tmpContext.getValueContainer();
        }
        if (tmpContext != null) {
            return tmpContext.getPropDefn();
        }
        return null;
    }

    public DesignElement getElement() {
        Object tmpValueContainer = this.getValueContainer();
        while (tmpValueContainer != null && !(tmpValueContainer instanceof DesignElement)) {
            tmpValueContainer = ((Structure)tmpValueContainer).getContext().getValueContainer();
        }
        if (tmpValueContainer instanceof DesignElement) {
            return (DesignElement)tmpValueContainer;
        }
        return null;
    }

    public Object getLocalValue(Module root) {
        if (this.dataContainer instanceof DesignElement) {
            DesignElement tmpElement = (DesignElement)this.dataContainer;
            return tmpElement.getLocalProperty(root, this.propDefn.getName());
        }
        return ((Structure)this.dataContainer).getLocalProperty(root, (PropertyDefn)this.propDefn);
    }

    private Object getLocalValue() {
        if (this.dataContainer instanceof DesignElement) {
            return this.getLocalValue(((DesignElement)this.dataContainer).getRoot());
        }
        return this.getLocalValue(null);
    }
}

