/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class StyleNameContext
extends AbstractModuleNameContext {
    StyleNameContext(Module module) {
        super(module, 0);
    }

    public List getElements(int level) {
        int i;
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashMap<String, DesignElement> elements = new LinkedHashMap<String, DesignElement>();
        if (theme != null) {
            List allStyles = theme.getAllStyles();
            i = 0;
            while (i < allStyles.size()) {
                StyleElement style = (StyleElement)allStyles.get(i);
                elements.put(style.getName(), style);
                ++i;
            }
        }
        if (this.module instanceof Library) {
            return new ArrayList(elements.values());
        }
        List csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
        i = 0;
        while (csses != null && i < csses.size()) {
            CssStyle s = (CssStyle)csses.get(i);
            elements.put(s.getName(), s);
            ++i;
        }
        NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
        Iterator iter = ns.getElements().iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            elements.put(element.getName(), element);
        }
        return new ArrayList(elements.values());
    }

    private ElementRefValue resolve(DesignElement element) {
        return new ElementRefValue(null, element);
    }

    private ElementRefValue resolve(String elementName) {
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return new ElementRefValue(null, elementName);
        }
        DesignElement target = null;
        if (this.module instanceof ReportDesign) {
            NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
            target = ns.getElement(elementName);
            if (target != null) {
                return new ElementRefValue(null, target);
            }
            List csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
            int i = 0;
            while (csses != null && i < csses.size()) {
                CssStyle s = (CssStyle)csses.get(i);
                if (elementName.equalsIgnoreCase(s.getFullName())) {
                    return new ElementRefValue(null, s);
                }
                ++i;
            }
        }
        StyleElement libraryStyle = null;
        if (theme != null) {
            libraryStyle = theme.findStyle(elementName);
        }
        if (libraryStyle != null) {
            return new ElementRefValue(null, libraryStyle);
        }
        List defaultTocStyle = this.module.getSession().getDefaultTOCStyleValue();
        Iterator iterator = defaultTocStyle.iterator();
        while (iterator.hasNext()) {
            StyleHandle styleHandle = (StyleHandle)iterator.next();
            if (!styleHandle.getName().equalsIgnoreCase(elementName)) continue;
            return new ElementRefValue(null, styleHandle.getElement());
        }
        return new ElementRefValue(null, elementName);
    }

    public ElementRefValue resolve(DesignElement element, PropertyDefn propDefn) {
        return this.resolve(element);
    }

    public ElementRefValue resolve(String elementName, PropertyDefn propDefn) {
        return this.resolve(elementName);
    }

    public DesignElement findElement(String elementName, IElementDefn elementDefn) {
        ElementRefValue refValue = this.resolve(elementName);
        return refValue == null ? null : refValue.getElement();
    }
}

