/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleStructureState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

public class IncludedCssStyleSheetListState
extends ListPropertyState {
    private int lineNumber = 1;

    IncludedCssStyleSheetListState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("structure")) {
            return new IncludedCssStructureState(this.handler, this.element, this.propDefn);
        }
        return super.startElement(tagName);
    }

    class IncludedCssStructureState
    extends CompatibleStructureState {
        IncludedCssStructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
            super(theHandler, element, propDefn);
            this.lineNumber = this.handler.getCurrentLineNo();
        }

        public void end() throws SAXException {
            super.end();
            IncludedCssStyleSheet includeCss = (IncludedCssStyleSheet)this.struct;
            if (this.handler.markLineNumber) {
                this.handler.module.addLineNo(this.struct, new Integer(this.lineNumber));
            }
            String fileName = includeCss.getFileName();
            if (!(this.element instanceof ICssStyleSheetOperation)) {
                return;
            }
            URL url = this.handler.module.findResource(fileName, 3);
            if (url == null) {
                CssException ex = new CssException(this.handler.module, new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                return;
            }
            ICssStyleSheetOperation sheetOperation = (ICssStyleSheetOperation)((Object)this.element);
            CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.handler.module, sheetOperation.getCsses(), url.getFile());
            if (sheet != null) {
                CssException ex = new CssException(this.handler.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                return;
            }
            try {
                sheet = this.handler.module.loadCss(this.element, url, fileName);
                sheetOperation.addCss(sheet);
            }
            catch (StyleSheetException styleSheetException) {
                CssException ex = new CssException(this.handler.module, new String[]{fileName}, "Error.CSSException.BADCSSFILE");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
            }
        }
    }
}

