/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ContextPageBreakHandler;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;

public class RunAndRenderTask
extends EngineTask
implements IRunAndRenderTask {
    protected IReportLayoutEngine layoutEngine;

    public RunAndRenderTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws EngineException {
        try {
            this.changeStatusToRunning();
            this.doRun();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.changeStatusToStopped();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.changeStatusToStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws EngineException {
        this.doValidateParameters();
        this.setupRenderOption();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.startRender();
        try {
            Object htmlOption;
            IContentEmitter emitter = this.createContentEmitter();
            IReportExecutor executor = new ReportExecutor(this.executionContext);
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(this.executionContext, executor);
            this.executionContext.setExecutor(executor);
            this.initializeContentEmitter(emitter, executor);
            String format = this.executionContext.getOutputFormat();
            boolean paginate = true;
            if ("html".equalsIgnoreCase(format)) {
                htmlOption = new HTMLRenderOption(this.renderOptions);
                paginate = ((HTMLRenderOption)htmlOption).getHtmlPagination();
            }
            if ("no-pagination".equals(this.pagination)) {
                paginate = false;
            }
            htmlOption = this;
            synchronized (htmlOption) {
                if (!this.executionContext.isCanceled()) {
                    this.layoutEngine = this.createReportLayoutEngine(this.pagination, this.renderOptions);
                }
            }
            if (this.layoutEngine != null) {
                this.layoutEngine.setLocale(this.executionContext.getLocale());
                CompositeLayoutPageHandler layoutPageHandler = new CompositeLayoutPageHandler();
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                layoutPageHandler.addPageHandler(handle);
                layoutPageHandler.addPageHandler(new ContextPageBreakHandler(this.executionContext));
                this.layoutEngine.setPageHandler(layoutPageHandler);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                IReportContent report = executor.execute();
                outputEmitters.start(report);
                this.layoutEngine.layout(executor, report, outputEmitters, paginate);
                outputEmitters.end(report);
            }
            this.closeRender();
            this.executionContext.closeDataEngine();
            this.closeFactory();
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error happened while running the report", ex);
        }
        catch (OutOfMemoryError err) {
            this.log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Error happened while running the report.", t);
            throw new EngineException("Error happened while running the report", t);
        }
    }

    public void cancel() {
        super.cancel();
        if (this.layoutEngine != null) {
            this.layoutEngine.cancel();
        }
    }
}

