/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;

public class Table {
    protected boolean dynamicColumns = true;
    protected boolean omitEmptyCell = true;
    Row[] rows;
    int rowCount = 0;
    int colCount;
    int nextColId = -1;
    int rowBufferSize;
    int colBufferSize;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.buffermgr.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Table(int rowSize, int colSize) {
        this.colCount = colSize;
        this.ensureSize(rowSize, colSize);
    }

    public Table() {
        this.colCount = 0;
        this.ensureSize(10, 10);
    }

    public void reset() {
        this.fillEmptyCells(0, 0, this.rowBufferSize, this.colBufferSize);
        this.nextColId = -1;
        this.rowCount = 0;
        this.colCount = 0;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void createRow(Object content) {
        this.ensureSize(this.rowCount + 1, this.colCount);
        Row row = this.rows[this.rowCount];
        if (!$assertionsDisabled && row.rowId != this.rowCount) {
            throw new AssertionError();
        }
        row.content = content;
        if (this.rowCount > 0) {
            Cell[] cells = row.cells;
            Cell[] lastCells = this.rows[this.rowCount - 1].cells;
            int cellId = 0;
            while (cellId < this.colCount) {
                Cell cell = lastCells[cellId];
                if (cell.status == 2) {
                    cell = cell.getCell();
                }
                if (cell.status == 1 && (cell.rowSpan < 0 || cell.rowId + cell.rowSpan > this.rowCount)) {
                    cells[cellId] = Cell.createSpanCell(this.rowCount, cellId, cell);
                }
                ++cellId;
            }
        }
        ++this.rowCount;
        this.nextColId = 0;
    }

    public void createCell(int cellId, int rowSpan, int colSpan, Cell.Content content) {
        if (cellId == -1) {
            cellId = this.getNextEmptyCell();
        }
        int rowId = this.rowCount - 1;
        this.ensureSize(rowId + 1, cellId + 1);
        Cell cell = this.rows[rowId].cells[cellId];
        int status = cell.getStatus();
        if (status != 0) {
            if (this.omitEmptyCell && (content == null || content.isEmpty())) {
                return;
            }
            if (status == 1) {
                this.removeCell(cell);
            } else if (status == 2) {
                Cell used = cell.getCell();
                if (!$assertionsDisabled && used.status != 1) {
                    throw new AssertionError();
                }
                if (used.rowId < rowId) {
                    this.resizeCell(used, rowId - used.rowId, used.colSpan);
                } else {
                    if (!$assertionsDisabled && used.rowId != rowId) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && used.colId >= cellId) {
                        throw new AssertionError();
                    }
                    this.resizeCell(used, used.rowSpan, cellId - used.colId);
                }
            }
        }
        colSpan = this.getMaxColSpan(cellId, colSpan);
        this.ensureSize(this.rowCount, cellId + colSpan);
        Cell newCell = Cell.createCell(rowId, cellId, rowSpan, colSpan, content);
        Cell[] cells = this.rows[rowId].cells;
        this.rows[rowId].cells[cellId] = newCell;
        this.nextColId = cellId + colSpan;
        ++cellId;
        while (cellId < this.nextColId) {
            cells[cellId] = Cell.createSpanCell(rowId, cellId, newCell);
            ++cellId;
        }
        if (this.nextColId > this.colCount) {
            this.colCount = this.nextColId;
        }
    }

    public void resolveDropCells() {
        if (this.rowCount <= 0) {
            return;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.colCount) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status == 1) {
                cell.rowSpan = this.rowCount - cell.rowId;
            }
            ++cellId;
        }
    }

    public void resolveDropCells(int bandId) {
        if (this.rowCount <= 0) {
            return;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.colCount) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status == 1 && cell.rowSpan == bandId) {
                cell.rowSpan = this.rowCount - cell.rowId;
            }
            ++cellId;
        }
    }

    public boolean hasDropCell() {
        if (this.rowCount <= 0) {
            return false;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.colCount) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status == 1 && (cell.rowSpan < 0 || cell.rowSpan > this.rowCount - cell.rowId)) {
                return true;
            }
            ++cellId;
        }
        return false;
    }

    protected int getNextEmptyCell() {
        if (!$assertionsDisabled && this.rowCount <= 0) {
            throw new AssertionError();
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int colId = this.nextColId;
        while (colId < this.colCount) {
            if (cells[colId].status == 0) {
                return colId;
            }
            ++colId;
        }
        if (this.dynamicColumns) {
            return this.colCount;
        }
        return this.colCount - 1;
    }

    protected int getMaxColSpan(int colId, int colSpan) {
        int checkSize = this.colCount - colId;
        if (checkSize > colSpan) {
            checkSize = colSpan;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int i = 1;
        while (i < checkSize) {
            if (cells[colId + i].status != 0) {
                return i;
            }
            ++i;
        }
        if (this.dynamicColumns) {
            return colSpan;
        }
        return checkSize;
    }

    protected void ensureSize(int newRowBufferSize, int newColBufferSize) {
        if (newRowBufferSize > this.rowBufferSize) {
            Row[] newRows = new Row[newRowBufferSize];
            if (this.rows != null) {
                System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
            }
            int rowId = this.rowBufferSize;
            while (rowId < newRowBufferSize) {
                Row row = new Row(rowId);
                Cell[] cells = new Cell[this.colBufferSize];
                int colId = 0;
                while (colId < this.colBufferSize) {
                    cells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = cells;
                newRows[rowId] = row;
                ++rowId;
            }
            this.rows = newRows;
            this.rowBufferSize = newRowBufferSize;
        }
        if (newColBufferSize > this.colBufferSize) {
            int rowId = 0;
            while (rowId < this.rowBufferSize) {
                Row row = this.rows[rowId];
                Cell[] newCells = new Cell[newColBufferSize];
                if (row.cells != null) {
                    System.arraycopy(row.cells, 0, newCells, 0, this.colBufferSize);
                }
                int colId = this.colBufferSize;
                while (colId < newColBufferSize) {
                    newCells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = newCells;
                ++rowId;
            }
            this.colBufferSize = newColBufferSize;
        }
    }

    protected void removeCell(Cell cell) {
        int rowId = cell.rowId;
        int colId = cell.colId;
        int rowSpan = cell.rowSpan;
        int colSpan = cell.colSpan;
        if (rowSpan < 0) {
            rowSpan = this.rowCount - rowId;
        }
        if (colId + colSpan > this.colCount) {
            colSpan = this.colCount - colId;
        }
        this.fillEmptyCells(rowId, colId, rowSpan, colSpan);
    }

    protected void fillEmptyCells(int rowId, int colId, int rowSize, int colSize) {
        int lastRowId = rowId + rowSize;
        int lastColId = colId + colSize;
        if (lastRowId > this.rowCount) {
            lastRowId = this.rowCount;
        }
        if (lastColId > this.colCount) {
            lastColId = this.colCount;
        }
        int i = rowId;
        while (i < lastRowId) {
            Cell[] cells = this.rows[i].cells;
            int j = colId;
            while (j < lastColId) {
                cells[j] = Cell.EMPTY_CELL;
                ++j;
            }
            ++i;
        }
    }

    protected void resizeCell(Cell cell, int newRowSpan, int newColSpan) {
        if (!$assertionsDisabled && cell.status != 1) {
            throw new AssertionError();
        }
        int rowId = cell.rowId;
        int colId = cell.colId;
        int rowSpan = cell.rowSpan;
        if (rowSpan <= 0) {
            rowSpan = this.rowCount - rowId;
        }
        int colSpan = cell.colSpan;
        if (!($assertionsDisabled || rowSpan >= newRowSpan && colSpan >= newColSpan)) {
            throw new AssertionError();
        }
        this.fillEmptyCells(rowId, colId + newColSpan, rowSpan, colSpan - newColSpan);
        this.fillEmptyCells(rowId + newRowSpan, colId, rowSpan - newRowSpan, newColSpan);
        cell.colSpan = newColSpan;
        cell.rowSpan = newRowSpan;
    }

    public Cell getCell(int rowId, int colId) {
        return this.rows[rowId].cells[colId];
    }

    public Row getRow(int rowId) {
        return this.rows[rowId];
    }
}

