/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;

public class ReportContentWriterV2
implements IReportContentWriter {
    protected static Logger logger;
    protected ReportDocumentWriter document;
    protected DataOutputStream stream;
    protected long offset;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private DataOutputStream bufferStream = new DataOutputStream(this.buffer);
    protected Stack contents = new Stack();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.internal.document.IReportContentWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ReportContentWriterV2(ReportDocumentWriter document) {
        this.document = document;
    }

    public void open(String name) throws IOException {
        IDocArchiveWriter archive = this.document.getArchive();
        RAOutputStream out = archive.createRandomAccessStream(name);
        this.stream = new DataOutputStream((OutputStream)out);
        this.offset = 0L;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed in close the writer", ex);
            }
            this.stream = null;
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long writeContent(IContent content) throws IOException {
        DocumentExtension docExt;
        this.buffer.reset();
        long parentOffset = -1L;
        IContent parent = (IContent)content.getParent();
        if (parent != null && (docExt = (DocumentExtension)parent.getExtension(0)) != null) {
            parentOffset = docExt.getIndex();
        }
        this.buffer.reset();
        IOUtil.writeInt((OutputStream)this.bufferStream, (int)content.getContentType());
        content.writeContent(this.bufferStream);
        this.bufferStream.flush();
        byte[] values = this.buffer.toByteArray();
        this.stream.writeLong(parentOffset);
        this.stream.writeInt(values.length);
        this.stream.write(values);
        DocumentExtension docExt2 = new DocumentExtension(this.offset);
        content.setExtension(0, docExt2);
        this.offset = this.offset + 8L + 4L + (long)values.length;
        return docExt2.getIndex();
    }

    public long writeFullContent(IContent content) throws IOException {
        ContentWriterVisitor writer = new ContentWriterVisitor();
        writer.write(content, this);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }

    private static class ContentWriterVisitor
    extends ContentVisitorAdapter {
        private ContentWriterVisitor() {
        }

        public void write(IContent content, IReportContentWriter writer) {
            this.visit(content, writer);
        }

        protected void writeContent(IReportContentWriter writer, IContent content) {
            try {
                writer.writeContent(content);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "write content failed");
            }
        }

        public Object visitContent(IContent content, Object value) {
            IReportContentWriter writer = (IReportContentWriter)value;
            this.writeContent(writer, content);
            Iterator iter = content.getChildren().iterator();
            while (iter.hasNext()) {
                IContent child = (IContent)iter.next();
                this.visitContent(child, value);
            }
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IContent content;
            IReportContentWriter writer = (IReportContentWriter)value;
            this.writeContent(writer, page);
            Iterator iter = page.getHeader().iterator();
            while (iter.hasNext()) {
                content = (IContent)iter.next();
                this.visitContent(content, writer);
            }
            iter = page.getFooter().iterator();
            while (iter.hasNext()) {
                content = (IContent)iter.next();
                this.visitContent(content, writer);
            }
            return value;
        }
    }
}

